<?php
namespace Claromentis\Menu\Tests\Unit;

$GLOBALS["__1333f0f3fcc7662c7b92" . "6d12cfbbc299"] = (@$GLOBALS["__1333f0f3fcc7662c7b926d" . "12cfbbc299"] ?: array()) + array("_8b742f9de3e606a5e98c53df" . "e64336dc" => base64_decode("Y3JlYXRlRGl2aWRlcg" . "=="), "_77ca388c9c772f10df" . "143747e308c256" => base64_decode("YmV" . "lcw" . "=="), "_e205d0c99dc5df4" . "4286a616830e1fd0" . "e" => base64_decode("Z2" . "V0"), "_5feede65e7cfe8f0b" . "3d9854c0363d548" => base64_decode("Y" . "Q" . "=" . "="), "_070913b44126cc7a4d" . "6b1bfc06fc2526" => base64_decode("Z2V0Vmlld2FibG" . "VJZHM="), "_74e6c647b312810242fc36" . "0c4ae14d72" => base64_decode("Y" . "g" . "=" . "="), "sav" . "e" => base64_decode("c2" . "F2" . "ZQ" . "=="), "_58f13aa391f72fba204fb8878" . "becd507" => base64_decode("Z2V" . "0SW" . "Q="), "_69d3a14b2db7b4a80d1af049403" . "ebc03" => base64_decode("Z2V0TW" . "F4T3Jk" . "ZXI="), "_a313073b" . "ba42f3bc3" . "bdd3d5c87" . "cdb8be" => base64_decode("R2" . "V0"));
use Claromentis\Core\Acl\Acl;
use Claromentis\Core\Acl\AclRepository;
use Claromentis\Core\Acl\PermOClass;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Menu\Exception\MenuItemForbiddenException;
use Claromentis\Menu\Exception\MenuItemNotFoundException;
use Claromentis\Menu\Exception\MenuItemValidationException;
use Claromentis\Menu\Infobar\ApplicationsListItems;
use Claromentis\Menu\Infobar\MenuItemDivider;
use Claromentis\Menu\Infobar\MenuItemFactory;
use Claromentis\Menu\Infobar\MenuItemRepository;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
use Psr\Log\LoggerInterface;
class ApplicationsListItemsTest extends TestCase
{
    private ApplicationsListItems $applicationsListItems;
    
    
    private MockObject $mockAclRepository;
    
    
    private MockObject $mockMenuItemRepository;
    
    
    private MockObject $mockMenuItemFactory;
    protected function setUp() : void
    {
        $this->mockMenuItemRepository = $this->createMock(MenuItemRepository::class);
        $this->mockMenuItemFactory = $this->createMock(MenuItemFactory::class);
        $this->mockAclRepository = $this->createMock(AclRepository::class);
        $this->applicationsListItems = new ApplicationsListItems($this->mockMenuItemRepository, $this->mockMenuItemFactory, $this->mockAclRepository, $this->createMock(LoggerInterface::class));
    }
    
    
    
    
    
    
    
    
    public function test_saveNewDivider_menuType() : void
    {
        $_14c10b40fe0e2987f65e1df49353b99e = 2;
        $_e2daa121c94479473021c686e5e64c87 = $this->createMock(MenuItemDivider::class);
        $_e2daa121c94479473021c686e5e64c87->method($GLOBALS["__1333f0f3fcc" . "7662c7b926d12" . "cfbbc299"]["_58f13aa391f72f" . "ba204fb8878becd" . "507"])->willReturn(5);
        
        
        $_1160c1a7e6e357504146e68eb9f11b65 = $this->createMock(Acl::class);
        $this->mockAclRepository->method($GLOBALS["__1333f0f3fcc7662c7" . "b926d12cfbbc299"]["_a313073bba42" . "f3bc3bdd3d5c8" . "7cdb8be"])->willReturn($_1160c1a7e6e357504146e68eb9f11b65);
        $this->mockMenuItemFactory->expects($this->once())->method($GLOBALS["__1333f0f3fcc7662c7" . "b926d12cfbbc299"]["_8b742f9de3e606" . "a5e98c53dfe6433" . "6dc"])->with($_14c10b40fe0e2987f65e1df49353b99e)->willReturn($_e2daa121c94479473021c686e5e64c87);
        $this->applicationsListItems->saveNewDivider($_14c10b40fe0e2987f65e1df49353b99e);
    }
    
    
    
    
    
    public function test_saveNewDivider_new() : void
    {
        $_e2daa121c94479473021c686e5e64c87 = $this->createMock(MenuItemDivider::class);
        $_e2daa121c94479473021c686e5e64c87->method($GLOBALS["__1333f0f3f" . "cc7662c7b92" . "6d12cfbbc29" . "9"]["_58f13aa391f72fba204fb8878becd50" . "7"])->willReturnOnConsecutiveCalls(5);
        $this->mockMenuItemFactory->method($GLOBALS["__1333f0f3fcc7662c7b" . "926d12cfbbc299"]["_8b742f9de3e606a5" . "e98c53dfe64336dc"])->willReturn($_e2daa121c94479473021c686e5e64c87);
        
        
        $_1160c1a7e6e357504146e68eb9f11b65 = $this->createMock(Acl::class);
        $this->mockAclRepository->method($GLOBALS["__1333f0f3fcc7662c7b926d12cfbbc29" . "9"]["_a313073bba42f3bc" . "3bdd3d5c87cdb8be"])->willReturn($_1160c1a7e6e357504146e68eb9f11b65);
        $this->mockMenuItemRepository->expects($this->once())->method($GLOBALS["__1333f0f3fcc7662c7b926" . "d12cfbbc299"]["sav" . "e"]);
        $this->applicationsListItems->saveNewDivider(1);
    }
    
    
    
    
    
    
    
    public function test_saveNewDivider_lastDisplayOrder() : void
    {
        $_b10738fc3d0ad3749dcc6ba41d7d616d = 67;
        $_e2daa121c94479473021c686e5e64c87 = $this->createMock(MenuItemDivider::class);
        $_e2daa121c94479473021c686e5e64c87->method($GLOBALS["__1333f0f3fcc7662c7b926d1" . "2cfbbc299"]["_58f13aa391f72fba2" . "04fb8878becd507"])->willReturn(5);
        
        
        $_1160c1a7e6e357504146e68eb9f11b65 = $this->createMock(Acl::class);
        $this->mockAclRepository->method($GLOBALS["__1333f0f3fcc7662c7" . "b926d12cfbbc299"]["_a313073bba" . "42f3bc3bdd3" . "d5c87cdb8be"])->willReturn($_1160c1a7e6e357504146e68eb9f11b65);
        $this->mockMenuItemRepository->method($GLOBALS["__1333f0f3fcc7662" . "c7b926d12cfbbc299"]["_69d3a14b2db7b4" . "a80d1af049403eb" . "c03"])->willReturn($_b10738fc3d0ad3749dcc6ba41d7d616d);
        $this->mockMenuItemFactory->expects($this->once())->method($GLOBALS["__1333f0f3fcc76" . "62c7b926d12cfbb" . "c299"]["_8b742f9de3e606a5e98c" . "53dfe64336dc"])->with($this->anything(), $this->anything(), $_b10738fc3d0ad3749dcc6ba41d7d616d)->willReturn($_e2daa121c94479473021c686e5e64c87);
        $this->applicationsListItems->saveNewDivider(2);
    }
    
    
    
    
    
    
    
    
    public function test_getApplication_appNotFound() : void
    {
        $this->mockMenuItemRepository->method($GLOBALS["__1333f0f3fcc7" . "662c7b926d12cf" . "bbc299"]["_e205d0c99dc5df44286a616830e1" . "fd0e"])->willReturn([]);
        $this->expectException(MenuItemNotFoundException::class);
        $this->applicationsListItems->getApplication($GLOBALS["__1333f0f3fcc" . "7662c7b926d12" . "cfbbc299"]["_77ca388c9c772f10df143747e30" . "8c256"]);
    }
    
    
    
    
    
    
    
    public function test_getApplication_multipleAppsFound() : void
    {
        $this->mockMenuItemRepository->method($GLOBALS["__1333f0f3fc" . "c7662c7b926d" . "12cfbbc299"]["_e205d0c99dc5df44286a6" . "16830e1fd0e"])->willReturn([$GLOBALS["__1333f0f3fcc" . "7662c7b926d12" . "cfbbc299"]["_5feede65e7" . "cfe8f0b3d98" . "54c0363d548"], $GLOBALS["__1333f0f" . "3fcc7662c" . "7b926d12c" . "fbbc299"]["_74e6c647b312810242" . "fc360c4ae14d72"]]);
        $this->expectException(MenuItemValidationException::class);
        $this->applicationsListItems->getApplication($GLOBALS["__1333f0f" . "3fcc7662c" . "7b926d12c" . "fbbc299"]["_77ca388c9c772f10df1" . "43747e308c256"]);
    }
    
    
    
    
    
    
    
    
    public function test_getApplication_noPermission() : void
    {
        
        
        $_e84af44769527f1a47a69dfa05dc31d6 = $this->createMock(SecurityContext::class);
        $this->mockMenuItemRepository->method($GLOBALS["__1333f0f3fcc7662c7b" . "926d12cfbbc299"]["_e205d0c99dc5df4428" . "6a616830e1fd0e"])->willReturn([657 => $GLOBALS["__1333f0f3fcc7662c7" . "b926d12cfbbc299"]["_5feede65e7cf" . "e8f0b3d9854c0" . "363d548"]]);
        $this->mockMenuItemRepository->method($GLOBALS["__1333f0f3fcc7662c7b9" . "26d12cfbbc299"]["_070913b44126cc7a4d6b1bfc06fc252" . "6"])->willReturn([]);
        $this->expectException(MenuItemForbiddenException::class);
        $this->applicationsListItems->getApplication($GLOBALS["__1333f0f3fcc7662c7b92" . "6d12cfbbc299"]["_77ca388c9c772f10df143747e308c2" . "56"], $_e84af44769527f1a47a69dfa05dc31d6);
    }
}