<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// FRAM-185 - Local document content text extraction and caching in a MRU table
$columns = [
	'type' => 'VARCHAR(50) NULL',
	'file_hash' => 'VARCHAR(8) NULL',
	'file_size' => 'INT NOT_NULL DEFAULT 0',
	'content' => 'CLOB NULL',
	'content_size' => 'INT NOT_NULL DEFAULT 0',
	'date_accessed' => 'INT_DATE NOT_NULL DEFAULT 0'        // The last time some content with this hash was indexed
];
$db->CreateTable('indexing_file_content_cache', $columns);
$db->CreateIndex('indexing_file_content_cache', 'indexing_file_content_cache_file_hash_file_size_index', 'file_hash', 'file_size');
$db->CreateIndex('indexing_file_content_cache', 'indexing_file_content_cache_type_date_accessed', 'type', 'date_accessed');
$db->CreateIndex('indexing_file_content_cache', 'indexing_file_content_cache_date_accessed', 'date_accessed');
