<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// Remove unnecessary indexes
$db->DropIndex('hpl_request', 'hpl_request_day_id');
$db->DropIndex('hpl_request', 'hpl_request_day_part');
$db->DropIndex('hpl_request', 'hpl_request_requested_by');
$db->DropIndex('hpl_request', 'hpl_request_date_approved');
$db->DropIndex('hpl_request', 'hpl_request_approved_by');

// Add indexes for specific use cases

/** @see \HpViewRequestList::GetRepositoryFilter() */
$db->CreateIndex('hpl_request', 'hpl_request_user_id_status', 'user_id', 'status');

/** @see \HpProcessZonesData::RecalculateUserHoliday */
$db->CreateIndex('hpl_request', 'hpl_request_date_status', 'date_start', 'date_end', 'status');

/**
 * @see \HpToolKit::PreloadCurUsersDays()
 * @see \HpTeamCalendarProvider::GetRequestInfo()
 * @see \HpProcessZonesData::RecalculateUserHolidays()
 * @see \Claromentis\Holidays\Repository\RequestRepository::ApplyFilters()
 */
$db->CreateIndex('hpl_request', 'hpl_request_cur_user_days', 'date_start', 'date_end', 'user_id', 'status');
