<?php
/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */

use Claromentis\Core\DAL\Exceptions\TransactionException;
use Claromentis\Core\DAL\Interfaces\DbInterface;

$db = $migrations->GetDb();
$logger = $migrations->getLogger();

$custom_ic_like_table = 'sd_ic_like';
$application_name = 'iclike';

$ic_like_config = $migrations->GetConfigFull($application_name);

/** Get the IC projects that are in use by IC Like custom module. */
$project_ids = $ic_like_config->get('cfg_ic_project_select') ?? [];

try {

	$db->DoTransaction(function (DbInterface $db) use ($application_name, $project_ids, $logger) {

		/** Check if the IC Like custom module is installed */
		$result = $db->query('SELECT 1 FROM db_installed WHERE application=str:app', $application_name);

		if (!$result->hasData()) {
			$logger->notice("IC Like app not installed: Skipping Likes migration from custom module to Core InfoCapture");
			return;
		}

		if (!is_array($project_ids) || empty($project_ids)) {
			$logger->warning("IC Likes feature is not enabled for any IC project in custom module, Skip enabling Like feature for InfoCapture projects");
			return;
		}

		// Update the equivalent projects in Core InfoCapture, and enable the Likes feature for them
		$db->query("UPDATE hd_project SET is_likes_enabled = int:is_likes_enabled WHERE id IN in:int:project_ids", 1, $project_ids);
	});

} catch (TransactionException $exception) {
	$logger->warning("IC Likes migration failed: Could not enabled Like feature for Core InfoCapture projects");
	$logger->debug($exception);
}



