<?php
/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */

use Claromentis\Core\DAL\Exceptions\TransactionException;
use Claromentis\Core\DAL\Interfaces\DbInterface;

$db     = $migrations->GetDb();
$logger = $migrations->getLogger();

$application_name = 'iclike';
$custom_ic_like_table = 'sd_ic_like';

/** @see AGGREGATION_IC_ISSUE */
$AGGREGATION_IC_ISSUE = 118;


try {
	$db->DoTransaction(function (DbInterface $db) use ($application_name, $custom_ic_like_table, $AGGREGATION_IC_ISSUE, $logger) {
		/** Check if the IC Like custom module is installed */
		$result = $db->query('SELECT 1 FROM db_installed WHERE application=str:app', $application_name);

		if (!$result->hasData()) {
			$logger->notice("IC Like app not installed: Skipping Likes migration from custom module to Core InfoCapture");
			return;
		}

		$query = "INSERT INTO likes (user_id, object_id, aggregation, timestamp)
			SELECT user_id, issue_id, {$AGGREGATION_IC_ISSUE}, date_created FROM {$custom_ic_like_table}";

		$db->query($query);
	});

} catch (TransactionException $exception) {
	$logger->warning("IC Likes migration failed: Likes have not been migrated from '{$custom_ic_like_table}' custom module table to 'Likes' table");
	$logger->error($exception);
}



