<?php
/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */

use Claromentis\Core\DAL\Exceptions\TransactionException;
use Claromentis\Core\DAL\Interfaces\DbInterface;

$db     = $migrations->GetDb();
$logger = $migrations->getLogger();

/** @see AGGREGATION_IC_ISSUE */
$AGGREGATION_IC_ISSUE = 118;

/**
 * Migration to the update the ticket like_count column.
 * We count the total of likes for an issue from the likes table.
 */

try {
	$db->DoTransaction(function (DbInterface $db) use ($AGGREGATION_IC_ISSUE, $logger) {

		$sub_query = "(SELECT COUNT(*) FROM likes WHERE likes.aggregation = {$AGGREGATION_IC_ISSUE} AND likes.object_id = hd_issue.id)";

		$query = "UPDATE hd_issue SET like_count = {$sub_query}";

		$db->query($query);
	});

} catch (TransactionException $exception) {
	$logger->warning("IC Likes migration failed: Could not update the total of likes for an issue ('like_count' column)");
	$logger->error($exception);
}
