require("../../../web/interface_default/calendar/assets/css/pages-components/mini-calendar-component.scss");

tmpl = require("./minicalendar.tmpl");
calmodal = require("./minicalendarmodal.tmpl");

$ = require('jquery');

function MiniCalendar(element_id, cla_moment, cla_locale) {
    this.element_id = element_id;
    this.$el = $('#' + element_id);
    this.active_day = null;
    this.cla_moment = cla_moment;
    this.cla_locale = cla_locale;
}

MiniCalendar.prototype.init = function(data) {
    var self = this;


    this.$el.on('click', '[data-day-id]', function (ev) {
        ev.preventDefault();
        ev.stopPropagation();
        var day_id = ev.currentTarget.getAttribute('data-day-id');
        self.minicln_toggle_day(day_id);
        self.eventData;
        var i;
        var day;
        for (i = 0; i < self.eventData.length; i++) {
            if (self.eventData[i].day_id == day_id) {
                day = self.eventData[i];
                break;
            }
        }
        day.unique_id = this.element_id;
        day.cla_moment = self.cla_moment;
        self.$el.closest('.mini-calendar').find('.mini-calendar-event-modal').addClass('active').html(calmodal(day));
    });

    if (data) {
        this.redraw(data);
    }


};

MiniCalendar.prototype.redraw = function(data) {
    data.unique_id = this.element_id;
    data.cla_locale = this.cla_locale;
    data.cla_moment = this.cla_moment;
    this.eventData = data.event_days;
    this.$el.html(tmpl(data));
};

MiniCalendar.prototype.minicln_toggle_day = function(day_popup_id_suffix) {
    var day_popup_id = this.element_id + day_popup_id_suffix;
};


module.exports = MiniCalendar;
