require(['domReady', 'jquery'], function(domReady, $) {
    domReady(function () {

        setGradient();


$('.gradient-radio').on('change', setSecondColor);
$('.gradient-color-left, .gradient-color-right, .gradient-radio, .gradient-direction').on('change', setGradient);



// SET GRADIENT ON LOAD AND ON CLICK OF RADIO BUTTONS OR COLOR CHOICE

function setGradient() {
	$( ".gradient-wrapper" ).each(function() {
		var wrapperID = $(this).attr('id');
		conveyClass = ".js-convey-" + wrapperID;
		wrapperID = "#" + wrapperID;

		if ($(wrapperID + ' .gradient-direction').is(":checked")) {
			var gradientDirection = 'bottom';
		} else {
			var gradientDirection = 'right';
		}

		var leftColor = $(wrapperID + ' .gradient-color-left').css('background-color');
		var rightColor = $(wrapperID + ' .gradient-color-right').css('background-color');
		var gradient = "linear-gradient(to " + gradientDirection + ","  + leftColor + " 0%," + rightColor + " 100%)";

		// SET GRADIENT BAR COLOR ON LOAD
		$(wrapperID + ' .gradient-preview-bar').css('background', gradient);

		// SET PREVIEW SECTIONS TO SOLID OR GRADIENT DEPENDANT ON RADIO BUTTON CHOICE
		if ($(wrapperID + ' .gradient').is(":checked")) {
			$(wrapperID).addClass('gradient-active');
			$(conveyClass).css('background', gradient);
		} else {
			$(wrapperID).removeClass('gradient-active');
			$(conveyClass).css('background', leftColor);
		}

	});
}

function setSecondColor() {
	function LightenDarkenColor(col,amt) {
		var usePound = false;
		if ( col[0] == "#" ) {
			col = col.slice(1);
			usePound = true;
		}

		var num = parseInt(col,16);
		var r = (num >> 16) + amt;
		if ( r > 255 ) r = 255;
		else if  (r < 0) r = 0;
		var b = ((num >> 8) & 0x00FF) + amt;
		if ( b > 255 ) b = 255;
		else if  (b < 0) b = 0;
		var g = (num & 0x0000FF) + amt;
		if ( g > 255 ) g = 255;
		else if  ( g < 0 ) g = 0;
		return (usePound?"#":"") + (g | (b << 8) | (r << 16)).toString(16);
	}


	var wrapperID = $(this).parents('.gradient-wrapper').attr('id');
	wrapperID = "#" + wrapperID;

	var leftHex  = $(wrapperID + " .gradient-color-left").val();
	var sibling = $(wrapperID + " .gradient-color-right");
	rightHex = LightenDarkenColor(leftHex,70);

	var rightHexChanged = false;

	if ($(wrapperID + ' .gradient').is(":checked")) {
		sibling.val(rightHex).css("background", rightHex);
	}
}



});
});
