<?php
namespace Claromentis\Core\Security\Authorization;

$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"] ?: array()) + array("_f73dab606630b3" . "88645c4f7d3fbb1" . "3bb" => base64_decode("YXJyYXlfbWVyZ2U" . "="), "_4d707fab93beb" . "b00bbe69e81596" . "97c90" => base64_decode(""), "_f2f473f724791a999268397ce204f" . "50e" => base64_decode("VXNlciBub3QgZm91bmQgaW4gdXNlciBkaXJ" . "lY3Rvcnkgb3IgaW4gbG9jYWwgdXNlcnM="), "_6ef4717df5dbc77a3a6c75e3c6" . "d87521" => base64_decode("IE9S" . "IA=="), "_77eadd1afe787fcbf44fffda" . "0cbd7b78" => base64_decode("CgkJCVNFTEVDVCBpZ" . "CwgcGFzc3dvcmQgRl" . "JPTSB1c2VycwoJCQl" . "XSEVSRSA="), "_9ac94d97b" . "e9fe1faed0" . "ec67543b49" . "eef" => base64_decode("U0VMRUNUIGExX2hhc2ggR" . "lJPTSB1c2VycyBXSEVSRS" . "BpZD1pbnQ6aWQ="), "_0284d38f97f9e8b9c7b03bb8928afa" . "e1" => base64_decode("K" . "Q" . "=" . "="), "_31ca1b51eacf7a" . "b591a1a37dd4182" . "b34" => base64_decode("bG9naW4uaW52YWxpZF9jcm" . "VkZW50aWFsc19sZGFw"), "_3b02d02d461e2bdea3072" . "79cfc43efb6" => base64_decode("CgkJCUFORCAoaW50cmFuZXR1c2VyIGVxOnN0cjphY3RpdmUgT1IgaWQ9MSkKCQkJQU5EIG" . "V4dF90eXBlIElTIE5VTEwKCQk="), "_2c9f44286d" . "5949bfaf2e5" . "f179e5c4ed0" => base64_decode("VVBEQVRFIHVzZXJzIFNFVCBhMV9oY" . "XNoPXN0cjpoYXNoIFdIRVJFIGlkPW" . "ludDppZA=="), "_c39012bca2a8a34dfe" . "139297adfadc59" => base64_decode("Tm8gdXNlcm5hbWUvZW1haWwgb3IgcGFzc3dvcmQgZ2l2Z" . "W4="), "_4b608eee32f1283369a5348380" . "83396b" => base64_decode("VXNlciBub3QgZm91bmQgaW4gbG9jYW" . "wgdXNlcnM="), "_1e0185bf334c68480122c82099c220" . "1b" => base64_decode("ID0gc3RyOm" . "ZybXVzZXI="), "_f149cf29770e82095e9" . "92315e2ab26e2" => base64_decode("KA=" . "="), "_5159b3572969e" . "ca46acd1b2e141" . "8459c" => base64_decode("aW1wb" . "G9kZQ" . "=="), "_38f12d8b8c719a8ce0fc2f" . "aefc225f35" => base64_decode("YXJyYX" . "lfbWFw"));
use Claromentis\Core\DAL;
use Claromentis\Core\DAL\Interfaces\DbInterface;
use Claromentis\Core\Localization\Lmsg;
use Claromentis\Core\Security\Exception\BadCredentialsException;
use Claromentis\Core\User\Directory\UsersDirectoryInterface;
use CryptUtils;
use UsersDirectory;
abstract class AbstractAuthorizationChecker
{
    
    
    
    
    protected string $last_user_id;
    
    
    
    
    protected string $last_dir_key;
    
    
    
    
    protected DbInterface $db;
    
    
    
    
    protected UsersDirectoryInterface $directory;
    
    
    
    
    protected Lmsg $lmsg;
    
    
    
    
    
    
    
    
    public function __construct(DAL\Db $db, UsersDirectoryInterface $_4a92477f9348babb15c20a0ca0f9073b, Lmsg $lmsg)
    {
        $this->db = $db;
        $this->directory = $_4a92477f9348babb15c20a0ca0f9073b;
        $this->lmsg = $lmsg;
        $this->last_dir_key = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_4d707fab93" . "bebb00bbe69" . "e8159697c90"];
        $this->last_user_id = 0;
    }
    
    
    
    
    
    
    
    
    public abstract function GetLoginColumns() : array;
    
    
    
    
    
    
    public abstract function GetFailedLoginMessage() : string;
    public function GetLastUserId() : int
    {
        return $this->last_user_id;
    }
    public function GetDirKey() : string
    {
        return $this->last_dir_key;
    }
    public function Check(string $_512402ec274462b0cc90595071368350, string $_e0637eee905ebe3938c5da50e3db10d7) : int
    {
        $this->ValidateCredentials($_512402ec274462b0cc90595071368350, $_e0637eee905ebe3938c5da50e3db10d7);
        $_473b9fd42a0c37e782564528f4c941b7 = $this->CheckLocalCredentials($_512402ec274462b0cc90595071368350, $_e0637eee905ebe3938c5da50e3db10d7);
        if (!$_473b9fd42a0c37e782564528f4c941b7 && $this->directory->Enabled()) {
            $_473b9fd42a0c37e782564528f4c941b7 = $this->CheckDirectoryCredentials($_512402ec274462b0cc90595071368350, $_e0637eee905ebe3938c5da50e3db10d7);
        }
        if (!$_473b9fd42a0c37e782564528f4c941b7) {
            $_136eb26d456ccb522c23fccbbee32f28 = $this->directory->Enabled() ? ($this->lmsg)($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_31ca1b51eacf7ab591a1a37dd418" . "2b34"]) : ($this->lmsg)($this->GetFailedLoginMessage());
            $_9cf30b942b47d857c27ad43896d15dc6 = $this->directory->Enabled() ? $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_f2f473f724791a999268397ce204f5" . "0e"] : $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_4b608eee32f12" . "83369a53483808" . "3396b"];
            throw (new BadCredentialsException($_136eb26d456ccb522c23fccbbee32f28))->setAuditMessage($_9cf30b942b47d857c27ad43896d15dc6);
        }
        $this->CheckAndUpdateUserHash($_512402ec274462b0cc90595071368350, $_e0637eee905ebe3938c5da50e3db10d7);
        return $this->last_user_id;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    private function ValidateCredentials(string $_512402ec274462b0cc90595071368350, string $_e0637eee905ebe3938c5da50e3db10d7) : void
    {
        if ($_512402ec274462b0cc90595071368350 === $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_4d707fa" . "b93bebb0" . "0bbe69e8" . "159697c9" . "0"] || $_e0637eee905ebe3938c5da50e3db10d7 === $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_4d707fab93bebb00bbe6" . "9e8159697c90"]) {
            throw (new BadCredentialsException(($this->lmsg)($this->GetFailedLoginMessage())))->setAuditMessage($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_c39012b" . "ca2a8a34" . "dfe13929" . "7adfadc5" . "9"]);
        }
    }
    
    
    
    
    
    
    
    
    
    private function CheckLocalCredentials(string $_512402ec274462b0cc90595071368350, string $_e0637eee905ebe3938c5da50e3db10d7) : bool
    {
        
        
        $_9d5dadc90f466f21468d5683ad90dd9d = $this->GetLoginColumns();
        $_17541857763957e21bd0b7ed1a701996 = $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_38f12d8b8c719a8ce0fc2f" . "aefc225f35"](function ($_16e904583014a98ae3677f33f097518d) {
            return $_16e904583014a98ae3677f33f097518d . $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_1e0185bf334c68480122c820" . "99c2201b"];
        }, $_9d5dadc90f466f21468d5683ad90dd9d);
        $_bb29b12bd4d13b379a407ab4361908e0 = $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_f149cf29770e82095e99" . "2315e2ab26e2"] . $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_5159b3572" . "969eca46ac" . "d1b2e14184" . "59c"]($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_6ef4717df5dbc77a3a6c7" . "5e3c6d87521"], $_17541857763957e21bd0b7ed1a701996) . $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_0284d38f97f9e8b9c7b03b" . "b8928afae1"];
        $_7f5aa4e96d4b415a86ed72ebff677cbe = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_77eadd1afe787f" . "cbf44fffda0cbd7" . "b78"] . $_bb29b12bd4d13b379a407ab4361908e0 . $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_3b02d02d461e2bdea307279cf" . "c43efb6"];
        $_4c4d12d3e4f6cac68e3eecffe9887915 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_f73dab606630b38864" . "5c4f7d3fbb13bb"]($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_38f12d8b" . "8c719a8ce" . "0fc2faefc" . "225f35"](function () use($_512402ec274462b0cc90595071368350) {
            return $_512402ec274462b0cc90595071368350;
        }, $_9d5dadc90f466f21468d5683ad90dd9d), [\Claromentis\People\Entity\User::STATUS_ACTIVE]);
        $_6c544202e5fe8024f9a198d70c6583c8 = $this->db->query($_7f5aa4e96d4b415a86ed72ebff677cbe, ...$_4c4d12d3e4f6cac68e3eecffe9887915);
        if ($_6c544202e5fe8024f9a198d70c6583c8->hasData()) {
            list($user_id, $_47140914655ca3e29c6b6525b7c0b504) = $_6c544202e5fe8024f9a198d70c6583c8->fetchRow();
            if (CryptUtils::CheckPassword($user_id, $_e0637eee905ebe3938c5da50e3db10d7, $_47140914655ca3e29c6b6525b7c0b504)) {
                $this->last_user_id = $user_id;
                return true;
            }
        }
        return false;
    }
    
    
    
    
    
    
    
    
    private function CheckDirectoryCredentials(string $_512402ec274462b0cc90595071368350, string $_e0637eee905ebe3938c5da50e3db10d7) : bool
    {
        
        
        try {
            $this->directory->CheckPassword($_512402ec274462b0cc90595071368350, $_e0637eee905ebe3938c5da50e3db10d7);
            $this->last_user_id = UsersDirectory::USERID_AUTO;
            $this->last_dir_key = $this->directory->GetDirKey();
        } catch (\Exception $_58d506edba9ce80af6a061b73e2eb66c) {
            return false;
        }
        return true;
    }
    
    
    
    
    
    
    
    
    
    private function CheckAndUpdateUserHash(string $_512402ec274462b0cc90595071368350, string $_e0637eee905ebe3938c5da50e3db10d7) : void
    {
        if ($this->last_user_id > 0) {
            list($_4360c3e465bb707396db417bf9f32aef) = $this->db->query_row($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_9ac94d97b" . "e9fe1faed0" . "ec67543b49" . "eef"], $this->last_user_id);
            $_daf5937c2c2f87c06256aa21a108da56 = CryptUtils::GetA1Hash($_512402ec274462b0cc90595071368350, $_e0637eee905ebe3938c5da50e3db10d7);
            if ($_daf5937c2c2f87c06256aa21a108da56 != $_4360c3e465bb707396db417bf9f32aef || !$_4360c3e465bb707396db417bf9f32aef) {
                $this->db->unsafe_query = 1;
                $this->db->query($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_2c9f44286d5949" . "bfaf2e5f179e5c4" . "ed0"], $_daf5937c2c2f87c06256aa21a108da56, $this->last_user_id);
            }
        }
    }
}