<?php
$_db_migration_to = '39.19'; // 8.13.15
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('2022-07-21_reindex_people.php', <<<'DB_UPDATE_FILE'
<?php

use Claromentis\Core\Services;
use Claromentis\Search;
use Claromentis\Setup\SetupFacade;

/**
 * claromentis/core !1208 BT-3361 Fixed filtering for a field type date (no year) in people application
 *
 * @var SetupFacade $migrations
 */

$logger = $migrations->getLogger();

$logger->notice('Remapping People to Elasticsearch and queuing them for reindexing');

$core = Services::I()->container;

try {
	/**
	 * @var Search\Indexing\Client\ClientInterface $indexer
	 * @var Search\Indexing\Reindexer              $reindexer
	 * @var Search\ItemTypeFactory                 $factory
	 */
	$indexer   = $core['search.indexer'];
	$reindexer = $core['search.reindexer'];
	$factory   = $core['search.item_type_factory'];

	$item = $factory->GetIndexingObject(\Claromentis\Search\ItemType\Indexing\User::TYPE_NAME);
	$item->InitMapping($indexer);
	$reindexer->Reindex(\Claromentis\Search\ItemType\Indexing\User::TYPE_NAME);
} catch (Exception $exception) {
	$logger->error($exception);
	$logger->error("Error remapping and queueing reindexing for users");
	$logger->warning("PLEASE REMAP AND REINDEX USERS MANUALLY");
}

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('39.19');
