/*
Copyright Scand LLC http://www.scbr.com
To use this component please contact info@scbr.com to obtain license

*/ 



function dataProcessor(serverProcessorURL){
 this.serverProcessor = serverProcessorURL;
 this.obj = null;
 this.mandatoryFields = new Array(0);
 this.updatedRows = new Array(0);
 this.autoUpdate = true;
 this.updateMode = "cell";
 this._waitMode=0;
 this._tMode="GET";
 return this;
}

 
 dataProcessor.prototype.setTransactionMode = function(mode){
 this._tMode=mode;
}


 
 dataProcessor.prototype.setOnAfterUpdate = function(ev){
 if(typeof(ev)!="function")ev=eval(ev);
 this._afterUEvent=ev;
}




 
 dataProcessor.prototype.setUpdateMode = function(mode){
 if(mode=="cell")
 this.autoUpdate = true;
 else{
 this.autoUpdate = false;
}
 this.updateMode = mode;
}


 dataProcessor.prototype.findRow = function(pattern){
 for(var i=0;i<this.updatedRows.length;i++){
 if(pattern==this.updatedRows[i])
 return i;
}
 return -1;
}

 
 dataProcessor.prototype.setUpdated = function(rowId,state){
 var rowInArray = this.findRow(rowId)
 if(rowInArray==-1)
 rowInArray = this.updatedRows.length;
 if(state){
 this.updatedRows[rowInArray] = rowId;
 this.setRowTextBold(rowId);
 this.checkBeforeUpdate(rowId,this.autoUpdate);
}else{
 this.updatedRows[rowInArray] = null;
 this.setRowTextNormal(rowId);
 
 
 
 
}

}

 dataProcessor.prototype.setUpdatedTM = function(rowId,state){
 this._lccm=true;

 if(this._waitMode){
 this.autoUpdate=false;
 this.setUpdated(rowId,true);
 this.autoUpdate=true;
}
 else
 this.setUpdated(rowId,true)

}

 dataProcessor.prototype.setRowTextBold=function(rowId){
 if(this.obj.mytype=="tree")
 this.obj.setItemStyle(rowId,"font-weight:bold;");
 else
 this.obj.setRowTextBold(rowId);
};
 dataProcessor.prototype.setRowTextNormal=function(rowId){
 if(this.obj.mytype=="tree")
 this.obj.setItemStyle(rowId,"font-weight:normal;");
 else
 this.obj.setRowTextNormal(rowId);
};
 
 dataProcessor.prototype.checkBeforeUpdate = function(rowId,updateFl){
 var fl = true;
 var mandExists = false;
 for(var i=0;i<this.mandatoryFields.length;i++){
 if(this.mandatoryFields[i]){
 mandExists = true;
 var val = this.obj.cells(rowId,i).getValue()
 var colName = this.obj.getHeaderCol(i)
 if((typeof(this.mandatoryFields[i])=="function" && this.mandatoryFields[i](val,colName))||(typeof(this.mandatoryFields[i])!="function" && val.toString()._dhx_trim()!="")){
 this.obj.cells(rowId,i).cell.style.borderColor = "";
}else{
 fl = false;
 this.obj.cells(rowId,i).cell.style.borderColor = "red";
}
}
}
 if((fl || !mandExists)&& updateFl)
{
 this.sendData(rowId);
}
}
 
 dataProcessor.prototype.sendData = function(rowId){
 if(rowId){
 
 var a1=this._getRowData(rowId);
 var a2=new dtmlXMLLoaderObject(this.afterUpdate,this,true);
 var a3=this.serverProcessor+((this.serverProcessor.indexOf("?")!=-1)?"&":"?");
 if(this._tMode!="POST")
 a2.loadXML(a3+a1);
 else
 a2.loadXML(a3,true,a1);

 

 this._waitMode++;
 
}else{
 for(var i=0;i<this.updatedRows.length;i++){
 if(this.updatedRows[i]){
 this.checkBeforeUpdate(this.updatedRows[i],true)
}
}
}
}

 
 dataProcessor.prototype.afterUpdate = function(that,b,c,d,xml){
 that._waitMode--;
 var atag=xml.getXMLTopNode("data").childNodes[0];
 var action = atag.getAttribute("type");
 var sid = atag.getAttribute("sid");
 var tid = atag.getAttribute("tid");
 that.setUpdated(sid,false);

 switch(action){
 case "insert":
 if(that.obj.mytype=="tree")
 that.obj.changeItemId(sid,tid);
 else
 that.obj.changeRowId(sid,tid);
 sid=tid;
 break;
 case "delete":
 if(that.obj.mytype=="tree"){
 that.obj.deleteItem(sid);
 if(this._afterUEvent)
 this._afterUEvent(sid,action,tid);
 return;
}
 else
 that.obj.deleteRow(sid);
 break;

}
 var z=that.obj.getUserData(sid,"!nativeeditor_status",'');
 if(z!="deleted")
 that.obj.setUserData(sid,"!nativeeditor_status",'');

 if(that._lccm){
 for(var i=0;i<that.updatedRows.length;i++)
 if(that.updatedRows[i]){
 that.obj.setUserData(that.updatedRows[i],"!nativeeditor_status","inserted");
 that.setUpdated(that.updatedRows[i],true);
}
}
 
 if(this._afterUEvent)
 this._afterUEvent(sid,action,tid);
}

 
 dataProcessor.prototype._getRowData = function(rowId){
 if(this.obj.mytype=="tree"){
 var z=this.obj._globalIdStorageFind(rowId);
 var z2=z.parentObject;

 var i=0;
 for(i=0;i<z2.childsCount;i++)
 if(z2.childNodes[i]==z)break;

 var str="tr_id="+z.id;
 str+="&tr_pid="+z2.id;
 str+="&tr_order="+i;
 str+="&tr_text="+escape(z.span.innerHTML);

 z2=(z._userdatalist||"").split(",");
 for(i=0;i<z2.length;i++)
 str+="&"+escape(z2[i])+"="+escape(z.userData["t_"+z2[i]]);

}
 else
{
 var str="gr_id="+rowId;
 var r=this.obj.getRowById(rowId);

 for(var i=0;i<r.childNodes.length;i++)
{
 var c=this.obj.cells(r.idd,i);
 str+="&c"+i+"="+escape(c.getValue());
}
 var data=this.obj.UserData[rowId];
 if(data){
 for(var j=0;j<data.keys.length;j++)
 str+="&"+data.keys[j]+"="+escape(data.values[j]);
}
}
 return str;

}

 
 dataProcessor.prototype.setVerificator = function(ind,verifFunction){
 if(verifFunction){
 this.mandatoryFields[ind] = verifFunction;
}else
 this.mandatoryFields[ind] = true;
}
 
 dataProcessor.prototype.clearVerificator = function(ind){
 this.mandatoryFields[ind] = false;
}
 
 
 dataProcessor.prototype.init = function(anObj){
 this.obj = anObj;
 this.obj.lWin=(new Date()).valueOf()+"-"+Math.random(1000)+"-"+(anObj.entBox||anObj.parentObject).id;
 var self = this;
 if(this.obj.mytype=="tree"){
 if(this.obj.setOnEditHandler)
 this.obj.setOnEditHandler(function(state,id){
 if(state==3)
 self.setUpdated(id,true)
 return true;
});

 this.obj.setDropHandler(function(id,id_2,id_3,tree_1,tree_2){
 if(tree_1==tree_2)
 self.setUpdated(id,true);
});
 this.obj._onrdlh=function(rowId){
 var z=self.obj.getUserData(rowId,"!nativeeditor_status");
 if(z=="deleted")
 return true;
 self.obj.setUserData(rowId,"!nativeeditor_status","deleted");
 self.setUpdated(rowId,true)
 self.obj.setItemStyle(rowId,"text-decoration : line-through;");
 return false;
};
 this.obj._onradh=function(rowId){
 self.obj.setUserData(rowId,"!nativeeditor_status","inserted");
 self.setUpdatedTM(rowId,true)
};
}
 else{
 this.obj.setOnEditCellHandler(function(state,id,index){
 var cell = self.obj.cells(id,index)
 if(state==0){

}else if(state==1){
 if(cell.isCheckbox()){
 self.setUpdated(id,true)
}
}else if(state==2){
 if(cell.wasChanged()){
 self.setUpdated(id,true)
}
}
 return true;
})
 this.obj.setOnRowSelectHandler(function(rowId){
 if(self.updateMode=="row")
 self.sendData();
 return true;
});
 this.obj.setOnEnterPressedHandler(function(rowId,celInd){
 if(self.updateMode=="row")
 self.sendData();
 return true;
});
 this.obj.setOnBeforeRowDeletedHandler(function(rowId){
 var z=self.obj.getUserData(rowId,"!nativeeditor_status");
 if(z=="inserted"){self.setUpdated(rowId,false);return true;}
 if(z=="deleted"){return true;}


 self.obj.setUserData(rowId,"!nativeeditor_status","deleted");
 self.obj.setRowTextStyle(rowId,"text-decoration : line-through;");
 self.setUpdated(rowId,true);
 return false;
});
 this.obj.setOnRowAddedHandler(function(rowId){
 self.obj.setUserData(rowId,"!nativeeditor_status","inserted");
 self.setUpdated(rowId,true)
 return true;
});

}
}



