<?php
namespace Claromentis\Infocapture\Repository;

$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"] ?: array()) + array("_49c6565477ee9" . "f822b499a53e6d" . "2995f" => base64_decode("YXJyYXlfa2V5" . "X2V4aXN0cw=="), "_064a039fdabac69a532d3225d0ed" . "0f57" => base64_decode("UHJvamVjdCBub3Qg" . "Zm91bmQ="), "project_" . "id" => base64_decode("cHJvamVj" . "dF9pZA=="), "i" . "d" => base64_decode("aW" . "Q="));
use Claromentis\Core\DAL;
use Claromentis\Infocapture\Exception\NotFoundException;
use Webmozart\Assert\Assert;
class ProjectRepository
{
    protected DAL\Db $database;
    
    
    
    
    
    
    protected array $projectCache = [];
    public function __construct(DAL\Db $_4504853ce5094b088c8bdc3d570a0a5d)
    {
        $this->database = $_4504853ce5094b088c8bdc3d570a0a5d;
    }
    
    
    
    
    
    
    
    public function findProject(int $projectId) : ?\HDProject
    {
        if (!$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_49c6565477ee9" . "f822b499a53e6d" . "2995f"]($projectId, $this->projectCache)) {
            $project = new \HDProject($this->database);
            if (!$project->Load($projectId)) {
                $project = null;
            }
            $this->projectCache[$projectId] = $project;
        }
        return $this->projectCache[$projectId];
    }
    
    
    
    
    
    
    
    
    public function findProjectOrFail(int $projectId) : \HDProject
    {
        $project = $this->findProject($projectId);
        if (null === $project) {
            throw new NotFoundException($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_064a039fdabac69a" . "532d3225d0ed0f57"]);
        }
        return $project;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    public function findProjectsForIssues(array $issues) : array
    {
        Assert::allIsInstanceOf($issues, \HDIssue::class);
        $_68680c984182bf7876b2bb0ab77ebe01 = [];
        foreach ($issues as $issue) {
            $projectId = (int) $issue->GetProperty($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["proj" . "ect_" . "id"]) ?? null;
            if ($projectId) {
                $issueId = $issue->GetProperty($GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["i" . "d"]);
                $_68680c984182bf7876b2bb0ab77ebe01[$issueId] = $this->findProject($projectId);
            }
        }
        return $_68680c984182bf7876b2bb0ab77ebe01;
    }
    
    
    
    
    
    
    
    public function clearCache(?int $projectId = null) : void
    {
        if (isset($projectId)) {
            unset($this->projectCache[$projectId]);
        } else {
            $this->projectCache[$projectId] = null;
        }
    }
}