<?php

/**
 * Claromentis-specific configuration and code for JPGraph, as used in Room Booking.
 *
 * This file used to define a lot more constants, being a modified version of the official JPGraph config, but it's
 * been reduced to Claromentis specific changes only to work with a Composer-friendly fork. This is primarily to prevent
 * class names conflicting in the global namespace, allowing us to use Composer's optimised autoloader without error.
 *
 * @deprecated This library needs to be removed, and its usages replaced. **DO NOT** use it any more.
 * @see https://github.com/HuasoFoundries/jpgraph
 * @see https://claromentis.atlassian.net/browse/FRAM-548
 * @see https://claromentis.atlassian.net/browse/FRAM-452
 */

defined('FF_CLA0') || define("FF_CLA0", 1000);
defined('FF_CLA1') || define("FF_CLA1", 1001);
defined('FF_CLA2') || define("FF_CLA2", 1002);

/**
 * Set one of standard font size using built-in font. Font face for FF_CLA0/1/2 is Arial.
 *
 * @param object $obj
 * @param int $font
 * @param int $style
 * @param int $size
 */
function jpgraph_set_font($obj, $font, $style=FS_NORMAL, $size='default')
{
	$default_font_face = FF_ARIAL;
	switch ($font)
	{
		case FF_CLA0: $size = ($size == 'default') ? 8 : $size; $font = $default_font_face; break;
		case FF_CLA1: $size = ($size == 'default') ? 10 : $size; $font = $default_font_face; break;
		case FF_CLA2: $size = ($size == 'default') ? 12 : $size; $font = $default_font_face; break;
	}

	$obj->SetFont($font, $style, $size);
}

// Prepare for loading the Composer library's global configuration
// TODO: BT-3082 This is hacky, it would be nice to submit a PR that stops us needing to do this
defined('ROOT_PATH') || define('ROOT_PATH', \Claromentis\Core\Services::I()->{'core.base_path'});

if (!is_file(ROOT_PATH . '/vendor/autoload.php')) {
	mkdir(ROOT_PATH  . '/vendor', 0775, true);
	touch(ROOT_PATH . '/vendor/autoload.php');
}

// Force-load the Composer library's global configuration
$__graph = new \Amenadiel\JpGraph\Graph\Graph();
unset($__graph);
