define(['cla_angular', 'ng.cla.core.checkbox'], function (angular, template) {
    var moduleName = 'cla.core.checkbox';
    var module;
    try {
        module = angular.module(moduleName);
    } catch (err) {
        // named module does not exist, so create one
        module = angular.module(moduleName, []);
    }

    /**
     * Wrapping stencil cla-checkbox element into directive
     */
    module.directive('clangCheckbox', function () {
        return {
            template: function(element, attr) {
                return '<cla-checkbox hidden="' + attr.hidden + '" ng-transclude name="' + attr.name + '" ng-checked="picker.ngChecked">yyyy</cla-checkbox>'
            },
            restrict: 'E',
            transclude: true,
            scope: {
                ngChecked: '='
            },
        };
    });
});
