<?php
namespace Claromentis\Core\Filesystem;

$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"] ?: array()) + array();
use Claromentis\Core\Filesystem\Exception\FileExistsException;
use Claromentis\Core\Filesystem\Exception\FileNotFoundException;
use Claromentis\Core\Filesystem\Exception\FilesystemException;
use Claromentis\Core\Filesystem\Exception\InsufficientSpaceException;






interface FilesystemInterface
{
    
    
    
    
    
    
    
    
    
    public function Read(string $path) : string;
    
    
    
    
    
    
    
    
    
    public function GetStream(string $path);
    
    
    
    
    
    
    
    
    
    public function WriteFromFile(string $path, string $source_path, array $config = []) : void;
    
    
    
    
    
    
    
    
    
    
    
    
    public function Write(string $path, string $contents, array $config = []) : void;
    
    
    
    
    
    
    
    
    
    
    
    
    public function WriteFromStream(string $path, $stream, array $config = []) : void;
    
    
    
    
    
    
    
    
    
    
    
    
    public function UpdateFromFile(string $path, string $source_path, array $config = []) : void;
    
    
    
    
    
    
    
    
    
    
    
    
    public function Update(string $path, string $contents, array $config = []) : void;
    
    
    
    
    
    
    
    
    
    
    
    
    public function UpdateFromStream(string $path, $stream, array $config = []) : void;
    
    
    
    
    
    
    
    
    
    
    
    public function PutFromFile(string $path, string $source_path, array $config = []) : void;
    
    
    
    
    
    
    
    
    
    
    
    public function Put(string $path, string $contents, array $config = []) : void;
    
    
    
    
    
    
    
    
    
    
    
    public function PutFromStream(string $path, $stream, array $config = []) : void;
    
    
    
    
    
    
    
    public function IsDir(string $path) : bool;
    
    
    
    
    
    
    
    public function Exists(string $path) : bool;
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function GetMetadata(string $path) : array;
    
    
    
    
    
    
    
    
    
    
    
    
    public function ListContents(string $path) : array;
    
    
    
    
    
    
    
    
    
    
    
    
    public function ListContentsInfo(string $path) : array;
    
    
    
    
    
    
    
    
    
    
    
    
    public function ListContentsRecursive(string $path) : array;
    
    
    
    
    
    
    
    
    
    public function ListFiles(string $path) : array;
    
    
    
    
    
    
    
    
    public function ListDirs(string $path) : array;
    
    
    
    
    
    
    
    
    
    
    
    public function Copy(string $path, string $new_path) : void;
    
    
    
    
    
    
    
    
    
    
    
    public function Rename(string $path, string $new_path) : void;
    
    
    
    
    
    
    
    
    
    public function Delete(string $path) : void;
    
    
    
    
    
    
    
    
    public function SetVisibility(string $path, string $visibility) : void;
    
    
    
    
    
    
    
    
    
    
    public function GetUrl(string $path) : ?string;
    
    
    
    
    
    
    
    public function GetUsedSpace() : string;
    
    
    
    
    
    
    
    public function RegisterProtocol(string $protocol) : void;
    
    
    
    
    
    
    
    
    
    
    public function GetLocalPath(string $path) : string;
}