
var ClipboardView = Backbone.View.extend({
	el: $('.js-clipboard'),
	clipboard: null, // clipboard content
	actions_view: null,

	events: {
		'change input[name=clipboard_selected_doc]' : "onCheckbox"
	},

	initialize: function ()
	{
		this.actions_view = new ClipboardActionsView();
	},

	setCollection: function (collection)
	{
		this.clipboard = collection;
		this.actions_view.setCollection(this.clipboard.selected_collection);
	},

	onCheckbox: function (event)
	{
		var parts = $(event.currentTarget).val().split(' ');
		var obj = this.clipboard.find(function (d) { return (d.get('type') == parts[0] && d.getObjId() == parts[1]); } );

		if ($(event.currentTarget).prop('checked'))
			this.clipboard.selected_collection.add(obj);
		else
			this.clipboard.selected_collection.remove(obj);
		this.actions_view.render();
	},

	hide: function ()
	{
		this.$el.hide();
	},

	render: function ()
	{
		var template,
			list_el = $('.js-clipboard-content');
		
		list_el.empty();
		if (this.clipboard.length == 0) {
		
			this.$el.hide();
		
		} else {
		
			this.$el.show();

			template = _.template($('#clipboard_content_tmpl').html());
			
			for (var i=0; i < this.clipboard.length; i++) {
				var doc = this.clipboard.at(i);
				var data = doc.toJSON();
				data.obj_id = doc.getObjId();
				if(data.type === 'document') {
					data.icon = data.is_doc_type_link ? 'icon-new_window' : claIcon(data.title);
				}
				list_el.append(template(data));
			}

		}

		this.updateCheckboxes();

		this.actions_view.render();
	},

	updateCheckboxes: function ()
	{
		this.$('input[name=clipboard_selected_doc]').prop('checked', false);
		this.clipboard.selected_collection.each(function (doc, index) {
			var val = doc.get('type') + ' ' + doc.getObjId();
			this.$('input[name=clipboard_selected_doc][value="' + val + '"]').prop('checked', true);
		}, this);
	}

});