<?php
namespace Claromentis\Infocapture\Controller\Rest;

$GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"] ?: array()) + array("_620d0bf67b054b" . "a2ec0f2fe084782" . "152" => base64_decode("aW5mb2NhcHR1cmUucmVzdC5ub19wZXJtaXNzaW9uX" . "2lzc3Vl"), "_c05f8f22b906" . "92278db70d3c3" . "04711e5" => base64_decode("aW5mb2NhcHR1cmUu" . "cmVzdC5ub19wZXJt" . "aXNzaW9uX3Byb2pl" . "Y3Q="), "_f76b20cae22026c8464c78243696" . "de97" => base64_decode("aW5mb2Nhc" . "HR1cmUucm" . "VzdC5ub19" . "wcm9qZWN0"), "project_i" . "d" => base64_decode("cHJvamVjdF9" . "pZA=="), "_5b40f7ef8f96b73095c82ad1" . "b60eabbe" => base64_decode("aW5mb2NhcHR1cmUucmVzdC5ub19" . "pc3N1ZQ=="));
use Claromentis\Core\Audit\Audit;
use Claromentis\Core\Http\JsonPrettyResponse;
use Claromentis\Core\Http\ResponseFactory;
use Claromentis\Core\Localization\Lmsg;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Infocapture\Api;
use Claromentis\Infocapture\Exception\NotFoundException;
use Claromentis\Infocapture\Exception\PermissionException;
use Claromentis\Infocapture\Filter\IssueFilter;
use Claromentis\Infocapture\RestFormatter;
use Psr\Http\Message\ServerRequestInterface;
class IssueController
{
    protected RestFormatter $formatter;
    protected ResponseFactory $response;
    protected Api $api;
    protected Lmsg $lmsg;
    protected Audit $audit;
    public function __construct(RestFormatter $formatter, ResponseFactory $response, Api $api, Lmsg $lmsg)
    {
        $this->formatter = $formatter;
        $this->response = $response;
        $this->api = $api;
        $this->lmsg = $lmsg;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    public function getIssue(SecurityContext $context, int $projectId, int $issueId) : JsonPrettyResponse
    {
        try {
            $issue = $this->api->getIssue($context, $projectId, $issueId);
            $this->api->loadHistoryForIssues($context, $projectId, [$issue]);
        } catch (PermissionException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new \RestExForbidden(($this->lmsg)($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_620d0bf67b054ba" . "2ec0f2fe08478215" . "2"]));
        } catch (NotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new \RestExNotFound(($this->lmsg)($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_5b40f7ef8f96b73095c" . "82ad1b60eabbe"]));
        } catch (\InvalidArgumentException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new \RestExError($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage());
        }
        $_69060fd98946c48b106c3cfed6f233a7 = $this->formatter->FormatIssue($issue);
        return $this->response->GetJsonPrettyResponse($_69060fd98946c48b106c3cfed6f233a7);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function getIssues(ServerRequestInterface $request, SecurityContext $context, int $projectId) : JsonPrettyResponse
    {
        $_03e9164d0a343b742df4793268b80767 = new IssueFilter();
        $_03e9164d0a343b742df4793268b80767->setProjectId($projectId);
        $_03e9164d0a343b742df4793268b80767->fill($request);
        try {
            $_a020ae3bf420cc88a5518a5ff484ac6f = $this->api->getIssues($context, $_03e9164d0a343b742df4793268b80767);
            $_6c561ef3cab8b84b15653472f877643e = $this->api->getIssuesCount($context, $_03e9164d0a343b742df4793268b80767);
            $this->api->loadHistoryForIssues($context, $projectId, $_a020ae3bf420cc88a5518a5ff484ac6f);
        } catch (PermissionException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new \RestExForbidden(($this->lmsg)($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_c05f8f2" . "2b906922" . "78db70d3" . "c304711e" . "5"]));
        } catch (NotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new \RestExNotFound(($this->lmsg)($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_f76b20c" . "ae22026c" . "8464c782" . "43696de9" . "7"]));
        } catch (\InvalidArgumentException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new \RestExError($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage());
        }
        $_7fa7c4fca4fac915f0ab1ef667084a04 = $_03e9164d0a343b742df4793268b80767->toArray();
        unset($_7fa7c4fca4fac915f0ab1ef667084a04[$GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["proje" . "ct_id"]]);
        $response = $this->formatter->Paginate($request, $this->formatter->FormatIssues($_a020ae3bf420cc88a5518a5ff484ac6f), $_7fa7c4fca4fac915f0ab1ef667084a04, $_6c561ef3cab8b84b15653472f877643e);
        return $this->response->GetJsonPrettyResponse($response);
    }
}