<?php
namespace Claromentis\Infocapture\Controller\Rest;

$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"] ?: array()) + array("_79bd87060993ff622ef212c1e" . "8b6a79a" => base64_decode("Rm9yYm" . "lkZGVu"), "_c05f8f22b90692278db70d3c304711e" . "5" => base64_decode("aW5mb2NhcHR1cmUucmVzdC5ub19wZXJtaXNzaW9uX3B" . "yb2plY3Q="), "_a4a101825" . "8adabb74e7" . "b04836d8d7" . "e3b" => base64_decode("Tm90IEZvd" . "W5k"), "_f76b20cae22026c8464c78243" . "696de97" => base64_decode("aW5mb2NhcHR1cmUucmVzd" . "C5ub19wcm9qZWN0"));
use Claromentis\Core\Http\JsonPrettyResponse;
use Claromentis\Core\Http\ResponseFactory;
use Claromentis\Core\Localization\Lmsg;
use Claromentis\Infocapture\Exception\NotFoundException;
use Claromentis\Infocapture\Exception\PermissionException;
use Claromentis\Infocapture\Filter\ProjectFilter;
use Claromentis\Infocapture\RestFormatter;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Infocapture\Api;
use Psr\Http\Message\ServerRequestInterface;
class ProjectController
{
    protected Api $api;
    protected Lmsg $lmsg;
    protected RestFormatter $formatter;
    protected ResponseFactory $response;
    public function __construct(Api $api, RestFormatter $formatter, ResponseFactory $response, Lmsg $lmsg)
    {
        $this->api = $api;
        $this->formatter = $formatter;
        $this->response = $response;
        $this->lmsg = $lmsg;
    }
    
    
    
    
    
    
    
    
    
    
    public function getProject(SecurityContext $context, int $projectId) : JsonPrettyResponse
    {
        try {
            $project = $this->api->getProject($context, $projectId);
        } catch (NotFoundException $_c35473364fa7a050299058f332ec29c1) {
            throw new \RestExNotFound(($this->lmsg)($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_f76b20cae22026c" . "8464c78243696de9" . "7"]), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_a4a1018258adabb74e7b04836d8d7" . "e3b"], $_c35473364fa7a050299058f332ec29c1);
        } catch (PermissionException $_c35473364fa7a050299058f332ec29c1) {
            throw new \RestExForbidden(($this->lmsg)($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_c05f8f22b90692278db70d3c304" . "711e5"]), $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_79bd87060993ff622ef212c1e8b" . "6a79a"], $_c35473364fa7a050299058f332ec29c1);
        }
        return $this->response->GetJsonPrettyResponse($this->formatter->FormatProject($project));
    }
    
    
    
    
    
    
    
    
    
    public function getProjects(SecurityContext $context, ServerRequestInterface $request) : JsonPrettyResponse
    {
        $_03e9164d0a343b742df4793268b80767 = new ProjectFilter();
        $_03e9164d0a343b742df4793268b80767->fill($request);
        $_68680c984182bf7876b2bb0ab77ebe01 = $this->api->getProjects($context, $_03e9164d0a343b742df4793268b80767);
        $_264e8772c4dd469c7acd9dc850e932fa = $this->formatter->FormatProjects($_68680c984182bf7876b2bb0ab77ebe01);
        $total = $this->api->getProjectsCount($_03e9164d0a343b742df4793268b80767);
        $response = $this->formatter->Paginate($request, $_264e8772c4dd469c7acd9dc850e932fa, $_03e9164d0a343b742df4793268b80767->toArray(), $total);
        return $this->response->GetJsonPrettyResponse($response);
    }
}