<?php
$_db_migration_to = '32.01'; // 8.6.0
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_create_session_timestamps.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$table_desc = [
	"user_id" => "INT NOT_NULL",
	"group_time" => "INT_DATE",
	"grouptree_time" => "INT_DATE",
	"role_time" => "INT_DATE",
];

$db->CreateTable('user_timestamps', $table_desc);
$db->CreatePrimaryKey('user_timestamps', 'user_id');

DB_UPDATE_FILE
);


$migrations->Run('02_create_onesignal_table.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$table_desc = [
	"user_id" => "INT NOT_NULL",
	"player_id" => "VARCHAR(40)"
];

$db->CreateTable('onesignal_users', $table_desc);
$db->CreateIndex('onesignal_users', 'user_id_index', 'user_id');

DB_UPDATE_FILE
);


$migrations->Run('02_create_uuid.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$uuid = \Claromentis\Core\Util\UuidGenerator::GenerateVersionFour();

list($exists) = $db->query_row("SELECT COUNT(1) FROM variables WHERE var_name = str:name", 'system_uuid');
if(!$exists)
	$db->query("INSERT INTO variables (var_value, var_name) VALUES (str:value, str:name)", $uuid, 'system_uuid');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('32.01');
