<?php
$_db_migration_to = '39.20'; // 8.13.17
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01-publish-menunode-url-length.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AlterColumn('publish_menunode', 'url', 'url', 'VARCHAR(1024) NULL');

DB_UPDATE_FILE
);


$migrations->Run('01_ic_bad_data_cleanup.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();
$logger = $migrations->getLogger();

// This migration will try to remove issues that have no associated data

$result = $db->query('SELECT i.id, i.id_in_project, i.project_id FROM hd_issue i LEFT JOIN fb_field_data f ON f.form_data_id = i.form_data_id WHERE f.form_data_id IS NULL');

$issue_ids = [];
while ($arr = $result->fetchArray())
{
	$id = (int)$arr['id'];
	$issue_ids[]  = $id;
	$logger->notice('Removing Infocapture issue with lost form/field data, ID: ' . $id . ', ID in project: ' . $arr['id_in_project'] . ', Project ID: ' . $arr['project_id']);
}

if (count($issue_ids) > 0)
	$db->query('DELETE FROM hd_issue WHERE id IN in:int:issue_ids', $issue_ids);

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('39.20');
