<?php
// This file contains the database schema version 41.08
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
if ($migrations->GetVersion() > 0)
	throw new Exception("The database is already initialized");
//===========================================================================================

// ERMS_audit_log_txt
$table_descr = array(
	'dt'	=>	"INT NULL",
	'dt2'	=>	"INT NULL DEFAULT 0",
	'userid'	=>	"INT NULL",
	'ip_addr'	=>	"VARCHAR(128) NULL",
	'type'	=>	"INT NULL",
	'category'	=>	"VARCHAR(50) NULL",
	'sub_cat'	=>	"VARCHAR(50) NULL",
	'obj_id'	=>	"INT NULL",
	'details'	=>	"VARCHAR_MAX NULL",
	'proxy_ip'	=>	"VARCHAR(128) NULL",
	'sudo_userid'	=>	"INT NULL",
);

$db->CreateTable('ERMS_audit_log_txt', $table_descr, true);



// ERMS_component_url
$table_descr = array(
	'component_id'	=>	"INT NULL",
	'user_id'	=>	"INT NULL",
	'date_created_utime'	=>	"INT NULL",
	'url_hash'	=>	"VARCHAR(32) NULL",
);

$db->CreateTable('ERMS_component_url', $table_descr, true);
$db->CreateIndex('ERMS_component_url', 'date_and_hash_idx', 'date_created_utime', 'url_hash');



// ERMS_data
$table_descr = array(
	'id'	=>	"IDENTITY",
	'doc_id'	=>	"INT NOT_NULL DEFAULT 0",
	'refcode'	=>	"VARCHAR(80) NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'date_created'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'date_last_modified'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'date_last_accessed'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'date_declared'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'type'	=>	"INT NOT_NULL DEFAULT 0",
	'primary_version_id'	=>	"INT NOT_NULL DEFAULT 0",
	'creator'	=>	"INT NOT_NULL DEFAULT 0",
	'primary_component_id'	=>	"INT NOT_NULL DEFAULT 0",
	'version_num'	=>	"INT NOT_NULL DEFAULT 0",
	'deleted'	=>	"BOOL NULL DEFAULT 0",
	'signature'	=>	"VARCHAR(32) NULL",
	'filesize'	=>	"BIGINT NOT_NULL DEFAULT 0",
	'wf_id'	=>	"INT NOT_NULL DEFAULT 0",
	'wf_state_id'	=>	"INT NOT_NULL DEFAULT 0",
	'wf_responsible_uid'	=>	"INT NOT_NULL DEFAULT 0",
	'doc_type'	=>	"INT NULL",
	'parent_id'	=>	"INT NOT_NULL DEFAULT 0",
	'perm_id'	=>	"INT NOT_NULL DEFAULT 0",
	'is_draft'	=>	"INT NOT_NULL DEFAULT 0",
	'latest_version_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('ERMS_data', $table_descr, true);
$db->CreateIndex('ERMS_data', 'ERMS_data_doc_id', 'doc_id');



// ERMS_data_component
$table_descr = array(
	'id'	=>	"IDENTITY",
	'parent_id'	=>	"INT NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL",
	'format'	=>	"VARCHAR(10) NULL",
	'filesize'	=>	"BIGINT NULL DEFAULT 0",
	'path'	=>	"VARCHAR(255) NULL",
	'signature'	=>	"VARCHAR(32) NULL",
);

$db->CreateTable('ERMS_data_component', $table_descr, true);
$db->CreateIndex('ERMS_data_component', 'ERMS_data_component_parent_id', 'parent_id');



// ERMS_export_log
$table_descr = array(
	'id'	=>	"IDENTITY",
	'dt'	=>	"INT NOT_NULL DEFAULT 0",
	'userid'	=>	"INT NOT_NULL DEFAULT 0",
	'structure'	=>	"CLOB NULL",
);

$db->CreateTable('ERMS_export_log', $table_descr, true);



// ERMS_file_plan
$table_descr = array(
	'id'	=>	"IDENTITY",
	'refcode'	=>	"VARCHAR(80) NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'date_created'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'date_last_modified'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'aggregation'	=>	"INT NOT_NULL DEFAULT 0",
	'date_closed'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'parent_id'	=>	"INT NOT_NULL DEFAULT 0",
	'creator'	=>	"INT NOT_NULL DEFAULT 0",
	'deleted'	=>	"BOOL NULL DEFAULT 0",
	'wf_id'	=>	"INT NULL DEFAULT 0",
	'perm_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('ERMS_file_plan', $table_descr, true);
$db->CreateIndex('ERMS_file_plan', 'ERMS_file_plan_parent_deleted', 'parent_id', 'deleted');



// ERMS_instructions
$table_descr = array(
	'id'	=>	"IDENTITY",
	'schedule_id'	=>	"INT NOT_NULL",
	'event_code'	=>	"VARCHAR(50) NULL",
	'instruction'	=>	"INT NOT_NULL DEFAULT 0",
	'retention_years'	=>	"INT NOT_NULL DEFAULT 0",
	'retention_months'	=>	"INT NOT_NULL DEFAULT 0",
	'retention_days'	=>	"INT NOT_NULL DEFAULT 0",
	'retention_period'	=>	"BIGINT NOT_NULL DEFAULT 0",
);

$db->CreateTable('ERMS_instructions', $table_descr, true);



// ERMS_metadata_element
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(100) NULL",
	'intval'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'txtval'	=>	"VARCHAR_MAX NULL",
	'type'	=>	"INT NOT_NULL DEFAULT 0",
	'to_index'	=>	"BOOL NOT_NULL DEFAULT 0",
	'clobval'	=>	"CLOB NULL",
);

$db->CreateTable('ERMS_metadata_element', $table_descr, true);
$db->CreateIndex('ERMS_metadata_element', 'ERMS_metadata_element_names', 'name');



// ERMS_metadata_field
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(100) NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'default_value'	=>	"VARCHAR(255) NULL",
	'editable'	=>	"INT NULL DEFAULT 1",
	'repeatable'	=>	"BOOL NULL DEFAULT 0",
	'meta_type'	=>	"INT NOT_NULL DEFAULT 0",
	'meta_html_type'	=>	"INT NOT_NULL DEFAULT 0",
	'implicit'	=>	"INT NULL DEFAULT 0",
	'inheritable'	=>	"INT NOT_NULL DEFAULT 0",
	'visible'	=>	"BOOL NOT_NULL DEFAULT 0",
	'mandatory'	=>	"BOOL NULL DEFAULT 0",
);

$db->CreateTable('ERMS_metadata_field', $table_descr, true);
$db->CreateIndex('ERMS_metadata_field', 'ERMS_metadata_field_name', 'name');



// ERMS_metadata_field_values
$table_descr = array(
	'metadata_id'	=>	"INT NOT_NULL DEFAULT 0",
	'meta_value'	=>	"INT NOT_NULL DEFAULT 0",
	'meta_text'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('ERMS_metadata_field_values', $table_descr, true);
$db->CreatePrimaryKey('ERMS_metadata_field_values', 'metadata_id', 'meta_value');



// ERMS_metadata_inherit
$table_descr = array(
	'object_id'	=>	"INT NOT_NULL DEFAULT 0",
	'aggregation'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(100) NOT_NULL DEFAULT ' '",
	'parent_id'	=>	"INT NOT_NULL DEFAULT 0",
	'inherited'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('ERMS_metadata_inherit', $table_descr, true);
$db->CreatePrimaryKey('ERMS_metadata_inherit', 'object_id', 'aggregation', 'name', 'parent_id');
$db->CreateIndex('ERMS_metadata_inherit', 'ERMS_metadata_inherit_p_id', 'parent_id');



// ERMS_metadata_link
$table_descr = array(
	'object_id'	=>	"INT NOT_NULL DEFAULT 0",
	'aggregation'	=>	"INT NOT_NULL DEFAULT 0",
	'element_id'	=>	"INT NOT_NULL DEFAULT 0",
	'inherited'	=>	"BOOL NOT_NULL DEFAULT 0",
	'parent_id'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(100) NULL",
);

$db->CreateTable('ERMS_metadata_link', $table_descr, true);
$db->CreatePrimaryKey('ERMS_metadata_link', 'object_id', 'aggregation', 'element_id', 'parent_id');
$db->CreateIndex('ERMS_metadata_link', 'ERMS_metadata_link_elements', 'element_id', 'aggregation', 'object_id');



// ERMS_objects_instructions
$table_descr = array(
	'aggregation'	=>	"INT NOT_NULL DEFAULT 0",
	'object_id'	=>	"INT NOT_NULL DEFAULT 0",
	'parent_id'	=>	"INT NULL DEFAULT 0",
	'instruction_id'	=>	"INT NOT_NULL DEFAULT 0",
	'result'	=>	"INT NOT_NULL DEFAULT 0",
	'execution_time'	=>	"INT NOT_NULL",
	'exec_comment'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('ERMS_objects_instructions', $table_descr, true);



// ERMS_objects_schedules
$table_descr = array(
	'schedule_id'	=>	"INT NOT_NULL",
	'aggregation'	=>	"INT NOT_NULL",
	'object_id'	=>	"INT NOT_NULL",
	'parent_id'	=>	"INT NULL DEFAULT 0",
	'inherited_from'	=>	"INT NULL",
	'inherited_from_aggregation'	=>	"INT NULL",
);

$db->CreateTable('ERMS_objects_schedules', $table_descr, true);



// ERMS_record_types
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(100) NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'default_type'	=>	"BOOL NOT_NULL DEFAULT 0",
	'md_set_id'	=>	"INT NULL",
);

$db->CreateTable('ERMS_record_types', $table_descr, true);
$db->CreateIndex('ERMS_record_types', 'ERMS_record_types_name', 'name');



// ERMS_review
$table_descr = array(
	'id'	=>	"IDENTITY",
	'aggregation'	=>	"INT NOT_NULL",
	'object_id'	=>	"INT NOT_NULL",
	'parent_id'	=>	"INT NULL",
	'review_time'	=>	"INT NOT_NULL",
	'review_note'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('ERMS_review', $table_descr, true);



// ERMS_schedule_holds
$table_descr = array(
	'aggregation'	=>	"INT NOT_NULL",
	'object_id'	=>	"INT NOT_NULL",
	'parent_id'	=>	"INT NULL",
);

$db->CreateTable('ERMS_schedule_holds', $table_descr, true);



// ERMS_schedules
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'target_aggregation'	=>	"INT NOT_NULL",
);

$db->CreateTable('ERMS_schedules', $table_descr, true);



// acl_role
$table_descr = array(
	'id'	=>	"IDENTITY",
	'aggregation'	=>	"INT NOT_NULL DEFAULT 0",
	'object_id'	=>	"INT NOT_NULL DEFAULT 0",
	'read_only'	=>	"BOOL NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(255) NULL",
	'position'	=>	"INT NOT_NULL DEFAULT 0",
	'rights'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('acl_role', $table_descr, true);



// audit_conf_txt
$table_descr = array(
	'category'	=>	"VARCHAR(50) NULL",
	'sub_cat'	=>	"VARCHAR(50) NULL",
	'status'	=>	"INT NULL",
	'rank_value'	=>	"INT NULL DEFAULT 0",
);

$db->CreateTable('audit_conf_txt', $table_descr, true);



// audit_log_txt
$table_descr = array(
	'dt'	=>	"INT NULL",
	'dt2'	=>	"INT NULL DEFAULT 0",
	'userid'	=>	"INT NULL",
	'ip_addr'	=>	"VARCHAR(128) NULL",
	'type'	=>	"INT NULL",
	'category'	=>	"VARCHAR(50) NULL",
	'sub_cat'	=>	"VARCHAR(50) NULL",
	'obj_id'	=>	"INT NULL",
	'details'	=>	"VARCHAR_MAX NULL",
	'proxy_ip'	=>	"VARCHAR(128) NULL",
	'sudo_userid'	=>	"INT NULL",
);

$db->CreateTable('audit_log_txt', $table_descr, true);



// audit_time
$table_descr = array(
	'num_days'	=>	"INT NULL",
	'last_clean'	=>	"INT NULL",
);

$db->CreateTable('audit_time', $table_descr, true);



// autologon_cookie
$table_descr = array(
	'user_id'	=>	"INT NOT_NULL",
	'cookie'	=>	"VARCHAR(255) NULL",
	'date_created'	=>	"INT NOT_NULL",
	'date_used'	=>	"INT NOT_NULL",
	'ip_created'	=>	"VARCHAR(255) NULL",
	'ip_used'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('autologon_cookie', $table_descr, true);



// backup_elements
$table_descr = array(
	'fid'	=>	"INT NOT_NULL DEFAULT 0",
	'sid'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('backup_elements', $table_descr, true);
$db->CreateIndex('backup_elements', 'backup_elements_fid', 'fid');
$db->CreateIndex('backup_elements', 'backup_elements_sid', 'sid');



// backup_series
$table_descr = array(
	'id'	=>	"IDENTITY",
	'full_period'	=>	"INT NOT_NULL DEFAULT 0",
	'inc_period'	=>	"INT NOT_NULL DEFAULT 0",
	'ttl'	=>	"INT NOT_NULL DEFAULT 7",
	'e_time'	=>	"VARCHAR(5) NULL DEFAULT '00:00'",
	'name'	=>	"VARCHAR(50) NULL",
	'descr'	=>	"VARCHAR_MAX NULL",
	'next_full'	=>	"INT NOT_NULL DEFAULT 0",
	'next_inc'	=>	"INT NOT_NULL DEFAULT 0",
	'storage_id'	=>	"INT NOT_NULL DEFAULT 0",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('backup_series', $table_descr, true);
$db->CreateIndex('backup_series', 'backup_series_storage_id', 'storage_id', 'status');
$db->CreateIndex('backup_series', 'backup_series_e_time', 'e_time');



// backup_storages
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(50) NULL",
	'location'	=>	"VARCHAR_MAX NULL",
	'files'	=>	"INT NOT_NULL DEFAULT 0",
	'total'	=>	"INT NOT_NULL DEFAULT 0",
	'available'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('backup_storages', $table_descr, true);



// blog_channel
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'owner_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('blog_channel', $table_descr, true);



// blog_post
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'link'	=>	"VARCHAR(255) NULL",
	'channel_id'	=>	"INT NOT_NULL DEFAULT 0",
	'date_start'	=>	"INT_DATE NULL",
	'date_delete'	=>	"INT_DATE NULL",
	'full_text_type'	=>	"VARCHAR(10) NULL",
	'is_draft'	=>	"BOOL NOT_NULL DEFAULT 0",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'comments_mode'	=>	"INT NOT_NULL DEFAULT 0",
	'deleted'	=>	"INT NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL",
	'summary'	=>	"VARCHAR_MAX NULL",
	'full_text'	=>	"CLOB NULL",
	'notification_sent'	=>	"BOOL NULL DEFAULT 0",
);

$db->CreateTable('blog_post', $table_descr, true);
$db->CreateIndex('blog_post', 'user_id', 'user_id');
$db->CreateIndex('blog_post', 'date_start', 'date_start');
$db->CreateIndex('blog_post', 'is_draft', 'is_draft');
$db->CreateIndex('blog_post', 'status', 'status');



// blog_subscriptions
$table_descr = array(
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'channel_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('blog_subscriptions', $table_descr, true);
$db->CreatePrimaryKey('blog_subscriptions', 'user_id', 'channel_id');
$db->CreateIndex('blog_subscriptions', 'user_id', 'user_id');
$db->CreateIndex('blog_subscriptions', 'channel_id', 'channel_id');



// bookmark
$table_descr = array(
	'bookmarkid'	=>	"IDENTITY",
	'userid'	=>	"INT NOT_NULL DEFAULT 0",
	'fileid'	=>	"INT NOT_NULL DEFAULT 0",
	'parent_id'	=>	"INT NOT_NULL DEFAULT 0",
	'bookcomment'	=>	"VARCHAR_MAX NULL",
	'primary_version'	=>	"BOOL NULL DEFAULT 0",
	'type'	=>	"INT NOT_NULL DEFAULT 1",
	'category'	=>	"INT NULL",
	'date_created'	=>	"INT NULL",
);

$db->CreateTable('bookmark', $table_descr, true);



// bookmark_categories
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'user_id'	=>	"INT NULL",
);

$db->CreateTable('bookmark_categories', $table_descr, true);



// calendar
$table_descr = array(
	'id'	=>	"IDENTITY",
	'start_date'	=>	"INT NULL",
	'end_date'	=>	"INT NULL",
	'location'	=>	"VARCHAR(255) NULL",
	'description'	=>	"CLOB NULL",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'importance'	=>	"INT NOT_NULL DEFAULT 0",
	'type'	=>	"INT NOT_NULL DEFAULT 0",
	'creator'	=>	"INT NOT_NULL DEFAULT 0",
	'notification_time'	=>	"INT NULL",
	'notification_type'	=>	"INT NULL DEFAULT 0",
	'assigned_to'	=>	"INT NULL DEFAULT 0",
	'subject'	=>	"VARCHAR_MAX NULL",
	'event_id'	=>	"INT NOT_NULL DEFAULT 0",
	'all_day'	=>	"BOOL NOT_NULL DEFAULT 0",
	'room'	=>	"INT NOT_NULL DEFAULT 0",
	'contract_id'	=>	"INT NOT_NULL DEFAULT 0",
	'period'	=>	"VARCHAR(255) NULL",
	'activity_type'	=>	"INT NOT_NULL DEFAULT 0",
	'ext_object_type'	=>	"INT NULL",
	'ext_object_id'	=>	"INT NULL",
);

$db->CreateTable('calendar', $table_descr, true);



// calendar_attachment
$table_descr = array(
	'id'	=>	"IDENTITY",
	'event_id'	=>	"INT NOT_NULL DEFAULT 0",
	'inner_document_id'	=>	"INT NOT_NULL DEFAULT 0",
	'file_name'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('calendar_attachment', $table_descr, true);



// cdn_files
$table_descr = array(
	'parent_path'	=>	"VARCHAR_MAX NULL",
	'type'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR_MAX NULL",
	'url'	=>	"VARCHAR_MAX NULL",
	'file_size'	=>	"INT NULL",
	'modified'	=>	"INT_DATE NULL",
);

$db->CreateTable('cdn_files', $table_descr, true);
$db->CreateIndex('cdn_files', 'cdn_files_url_lookup', 'type', 'parent_path(50)', 'name(50)');



// cdn_utility_logs
$table_descr = array(
	'id'	=>	"IDENTITY",
	'dt'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'log_level'	=>	"VARCHAR(16) NULL",
	'channel'	=>	"VARCHAR(64) NULL",
	'message'	=>	"CLOB NULL",
	'context'	=>	"CLOB NULL",
	'extra'	=>	"CLOB NULL",
);

$db->CreateTable('cdn_utility_logs', $table_descr, true);



// cln_attendees
$table_descr = array(
	'list_id'	=>	"INT NULL",
	'user_id'	=>	"INT NULL",
	'contact_id'	=>	"INT NULL",
	'confirmation_hash'	=>	"VARCHAR(33) NULL",
);

$db->CreateTable('cln_attendees', $table_descr, true);



// cln_calendar
$table_descr = array(
	'id'	=>	"IDENTITY",
	'creator_id'	=>	"INT NULL",
	'group_id'	=>	"INT NULL",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'color'	=>	"VARCHAR(7) NULL",
	'cln_no_ical'	=>	"BOOL NOT_NULL DEFAULT 0",
	'link_ical'	=>	"VARCHAR(255) NULL",
	'last_background_sync'	=>	"INT_DATE NOT_NULL DEFAULT 0",
);

$db->CreateTable('cln_calendar', $table_descr, true);



// cln_confirm
$table_descr = array(
	'event_id'	=>	"INT NULL",
	'user_id'	=>	"INT NULL",
	'contact_id'	=>	"INT NULL",
	'confirm_status'	=>	"INT NULL",
	'time_status'	=>	"INT NULL",
);

$db->CreateTable('cln_confirm', $table_descr, true);



// cln_event
$table_descr = array(
	'id'	=>	"IDENTITY",
	'cln_id'	=>	"INT NULL",
	'seq_id'	=>	"INT NULL DEFAULT 0",
	'seq_changed_flag'	=>	"INT NULL DEFAULT 0",
	'att_list_id'	=>	"INT NULL",
	'room_id'	=>	"INT NULL",
	'creator_id'	=>	"INT NULL",
	'full_day'	=>	"INT NULL",
	'date_start'	=>	"INT_DATE NULL",
	'date_end'	=>	"INT_DATE NULL",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'location'	=>	"VARCHAR(1024) NULL",
	'tz'	=>	"VARCHAR(255) NULL",
	'is_personal'	=>	"BOOL NULL",
	'is_imported'	=>	"BOOL NOT_NULL DEFAULT 0",
	'cln_no_ical'	=>	"BOOL NOT_NULL DEFAULT 0",
	'ical_uid'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('cln_event', $table_descr, true);
$db->CreateIndex('cln_event', 'cln_event_date_start', 'date_start');



// cln_export_links
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL",
	'calendar_ids'	=>	"VARCHAR(255) NULL",
	'link_key'	=>	"VARCHAR(10) NULL",
	'start_date_period'	=>	"INT NULL",
	'end_date_period'	=>	"INT NULL",
);

$db->CreateTable('cln_export_links', $table_descr, true);



// cln_reminder
$table_descr = array(
	'event_id'	=>	"INT NULL",
	'user_id'	=>	"INT NULL",
	'contact_id'	=>	"INT NULL",
	'rem_type'	=>	"INT NULL",
	'rem_time'	=>	"INT_DATE NULL",
);

$db->CreateTable('cln_reminder', $table_descr, true);



// cln_sent_reminders
$table_descr = array(
	'send_date'	=>	"INT_DATE NULL",
	'hash'	=>	"VARCHAR(100) NULL",
);

$db->CreateTable('cln_sent_reminders', $table_descr, true);
$db->CreateIndex('cln_sent_reminders', 'cln_sent_reminders_hash', 'hash');



// cln_seq_confirm
$table_descr = array(
	'seq_id'	=>	"INT NULL",
	'user_id'	=>	"INT NULL",
	'contact_id'	=>	"INT NULL",
	'confirm_status'	=>	"INT NULL",
	'time_status'	=>	"INT NULL",
);

$db->CreateTable('cln_seq_confirm', $table_descr, true);



// cln_seq_reminder
$table_descr = array(
	'seq_id'	=>	"INT NULL",
	'user_id'	=>	"INT NULL",
	'contact_id'	=>	"INT NULL",
	'rem_type'	=>	"INT NULL",
	'rem_time'	=>	"INT_DATE NULL",
);

$db->CreateTable('cln_seq_reminder', $table_descr, true);



// cln_sequence
$table_descr = array(
	'id'	=>	"IDENTITY",
	'cln_id'	=>	"INT NULL",
	'att_list_id'	=>	"INT NULL",
	'room_id'	=>	"INT NULL",
	'creator_id'	=>	"INT NULL",
	'full_day'	=>	"INT NULL",
	'date_start'	=>	"INT_DATE NULL",
	'date_end'	=>	"INT_DATE NULL",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'location'	=>	"VARCHAR(255) NULL",
	'tz'	=>	"VARCHAR(255) NULL",
	'is_personal'	=>	"BOOL NULL",
	'repetition_string'	=>	"VARCHAR(255) NULL",
	'is_imported'	=>	"BOOL NOT_NULL DEFAULT 0",
	'cln_no_ical'	=>	"BOOL NOT_NULL DEFAULT 0",
	'ical_uid'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('cln_sequence', $table_descr, true);



// cln_sys_event_options
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NULL",
	'reminder_date'	=>	"INT_DATE NULL",
	'reminder_time'	=>	"INT NULL",
	'event_key'	=>	"VARCHAR(100) NULL",
	'sended_flag'	=>	"BOOL NULL",
);

$db->CreateTable('cln_sys_event_options', $table_descr, true);
$db->CreateIndex('cln_sys_event_options', 'cln_sys_event_opt_date', 'reminder_date', 'sended_flag');
$db->CreateIndex('cln_sys_event_options', 'cln_sys_event_opt_event_user', 'event_key', 'user_id');



// cln_system_calendar
$table_descr = array(
	'id'	=>	"IDENTITY",
	'symname'	=>	"VARCHAR(255) NULL",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'color'	=>	"VARCHAR(7) NULL",
	'is_visible'	=>	"BOOL NULL DEFAULT 0",
);

$db->CreateTable('cln_system_calendar', $table_descr, true);



// cln_task
$table_descr = array(
	'id'	=>	"IDENTITY",
	'creator'	=>	"INT NULL",
	'assigned_to'	=>	"INT NULL",
	'status'	=>	"INT NULL",
	'priority'	=>	"INT NULL",
	'start_date'	=>	"INT_DATE NULL",
	'end_date'	=>	"INT_DATE NULL",
	'title'	=>	"VARCHAR(500) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('cln_task', $table_descr, true);



// comments
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NULL",
	'date_created'	=>	"INT_DATE NULL",
	'object_id'	=>	"INT NULL",
	'aggregation'	=>	"INT NULL",
	'object_id2'	=>	"INT NULL",
	'url'	=>	"VARCHAR(1500) NULL",
	'comment_text'	=>	"CLOB NULL",
	'status'	=>	"INT NOT_NULL DEFAULT 1",
	'parent_id'	=>	"INT NOT_NULL DEFAULT 0",
	'reply_count'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('comments', $table_descr, true);
$db->CreateIndex('comments', 'comments_aggr_object_id', 'aggregation', 'object_id');



// compliances
$table_descr = array(
	'id'	=>	"IDENTITY",
	'type'	=>	"INT NOT_NULL DEFAULT 0",
	'status'	=>	"BOOL NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL",
	'doc_id'	=>	"INT NOT_NULL DEFAULT 0",
	'pub_id'	=>	"INT NOT_NULL DEFAULT 0",
	'url'	=>	"VARCHAR(255) NULL",
	'created'	=>	"INT NOT_NULL DEFAULT 0",
	'email_template'	=>	"CLOB NULL",
	'all_view_users'	=>	"BOOL NOT_NULL DEFAULT 0",
	'creator'	=>	"INT NULL DEFAULT 0",
);

$db->CreateTable('compliances', $table_descr, true);



// compliances_users
$table_descr = array(
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'compliance_id'	=>	"INT NOT_NULL DEFAULT 0",
	'time_read'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('compliances_users', $table_descr, true);
$db->CreatePrimaryKey('compliances_users', 'user_id', 'compliance_id');



// contacts
$table_descr = array(
	'id'	=>	"IDENTITY",
	'surname'	=>	"VARCHAR(255) NULL",
	'firstname'	=>	"VARCHAR(255) NULL",
	'company'	=>	"VARCHAR(255) NULL",
	'work_location'	=>	"VARCHAR(255) NULL",
	'city'	=>	"VARCHAR(120) NULL",
	'landline'	=>	"VARCHAR(100) NULL",
	'emailad'	=>	"VARCHAR(75) NULL",
	'country_mobile'	=>	"BOOL NULL DEFAULT 0",
	'mobile'	=>	"VARCHAR(25) NULL",
	'pref_contact'	=>	"VARCHAR(50) NULL",
	'usercomments'	=>	"VARCHAR_MAX NULL",
	'owner'	=>	"INT NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR(100) NULL",
	'company_id'	=>	"INT NOT_NULL DEFAULT 0",
	'role'	=>	"VARCHAR(255) NULL",
	'date1'	=>	"INT_DATE NULL",
	'contact_type'	=>	"INT NOT_NULL DEFAULT 0",
	'date_last_review'	=>	"INT_DATE NULL",
);

$db->CreateTable('contacts', $table_descr, true);
$db->CreateIndex('contacts', 'contacts_company_id', 'company_id');



// custom_code
$table_descr = array(
	'section_name'	=>	"VARCHAR(100) NULL",
	'value'	=>	"CLOB NULL",
);

$db->CreateTable('custom_code', $table_descr, true);



// diagram_dp_link
$table_descr = array(
	'd_id'	=>	"INT NULL",
	'dp_id'	=>	"INT NULL",
);

$db->CreateTable('diagram_dp_link', $table_descr, true);



// diagram_styles
$table_descr = array(
	'id'	=>	"IDENTITY",
	'd_id'	=>	"INT NOT_NULL DEFAULT 0",
	'diagram_level'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(255) NULL",
	'value'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('diagram_styles', $table_descr, true);



// diagrams
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'width'	=>	"INT NOT_NULL DEFAULT 1",
	'height'	=>	"INT NOT_NULL DEFAULT 1",
	'diff_styles'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('diagrams', $table_descr, true);



// discussion_attachments
$table_descr = array(
	'id'	=>	"IDENTITY",
	'discussion_id'	=>	"INT NOT_NULL DEFAULT 0",
	'doc_id'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(255) NULL",
	'extension'	=>	"VARCHAR(4) NULL",
	'path'	=>	"VARCHAR(255) NULL",
	'type'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('discussion_attachments', $table_descr, true);
$db->CreateIndex('discussion_attachments', 'aggr_discussion_id', 'discussion_id');



// discussions
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL",
	'object_id'	=>	"INT NOT_NULL",
	'ancillary'	=>	"INT NULL DEFAULT 0",
	'aggregation'	=>	"INT NOT_NULL",
	'parent_id'	=>	"INT NOT_NULL DEFAULT 0",
	'attachment_id'	=>	"INT NULL DEFAULT 0",
	'txt'	=>	"VARCHAR_MAX NULL",
	'timestamp'	=>	"INT_DATE NULL",
	'like_count'	=>	"INT NULL DEFAULT 0",
	'reply_count'	=>	"INT NULL DEFAULT 0",
	'acknowledgement'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('discussions', $table_descr, true);
$db->CreateIndex('discussions', 'discussion_aggr_object_id', 'aggregation', 'object_id');
$db->CreateIndex('discussions', 'idx_parent_id', 'parent_id');
$db->CreateIndex('discussions', 'idx_aggregation_object_id_parent_id', 'aggregation', 'object_id', 'parent_id');
$db->CreateIndex('discussions', 'idx_aggregation_parent_id_object_id_timestamp', 'aggregation', 'parent_id', 'object_id', 'timestamp');



// discussions_acknowledgements
$table_descr = array(
	'id'	=>	"IDENTITY",
	'discussion_id'	=>	"INT NOT_NULL",
	'user_id'	=>	"INT NOT_NULL",
	'timestamp'	=>	"INT_DATE NULL",
);

$db->CreateTable('discussions_acknowledgements', $table_descr, true);
$db->CreateIndex('discussions_acknowledgements', 'discussions_acknowledgements_discussion_user_id', 'discussion_id', 'user_id');



// document_notifications
$table_descr = array(
	'doc_id'	=>	"INT NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'one_version'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('document_notifications', $table_descr, true);



// download_cart
$table_descr = array(
	'id'	=>	"IDENTITY",
	'item_id'	=>	"INT NULL",
	'item_parent_id'	=>	"INT NULL",
	'user_id'	=>	"INT NULL",
	'download_status'	=>	"VARCHAR(1) NULL",
);

$db->CreateTable('download_cart', $table_descr, true);



// dp_styles
$table_descr = array(
	'id'	=>	"IDENTITY",
	'd_id'	=>	"INT NOT_NULL DEFAULT 0",
	'dp_id'	=>	"INT NOT_NULL DEFAULT 0",
	'dp_level'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(255) NULL",
	'value'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('dp_styles', $table_descr, true);



// empty_search
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL",
	'date_created'	=>	"INT_DATE NOT_NULL",
	'keywords'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('empty_search', $table_descr, true);



// endorsements
$table_descr = array(
	'endorser_id'	=>	"INT NOT_NULL DEFAULT 0",
	'endorsee_id'	=>	"INT NOT_NULL DEFAULT 0",
	'skillid'	=>	"INT NOT_NULL DEFAULT 0",
	'id'	=>	"IDENTITY",
);

$db->CreateTable('endorsements', $table_descr, true);



// event_facility
$table_descr = array(
	'event_id'	=>	"INT NOT_NULL DEFAULT 0",
	'facility_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('event_facility', $table_descr, true);



// event_notifications
$table_descr = array(
	'event_id'	=>	"INT NOT_NULL DEFAULT 0",
	'recepient_id'	=>	"INT NOT_NULL DEFAULT 0",
	'notification_type'	=>	"INT NOT_NULL DEFAULT 0",
	'notification_time'	=>	"INT NULL",
);

$db->CreateTable('event_notifications', $table_descr, true);



// extranet_areas
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR(255) NULL",
	'admin_id'	=>	"INT NULL",
	'primary_area'	=>	"BOOL NULL DEFAULT 0",
	'logo_file'	=>	"VARCHAR(50) NULL",
	'default_skin'	=>	"INT NOT_NULL DEFAULT 0",
	'readonly'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('extranet_areas', $table_descr, true);



// facilities
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('facilities', $table_descr, true);



// fb_category
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'perm_id'	=>	"INT NULL",
);

$db->CreateTable('fb_category', $table_descr, true);



// fb_def_stylesheet
$table_descr = array(
	'stylesheet'	=>	"CLOB NULL",
);

$db->CreateTable('fb_def_stylesheet', $table_descr, true);



// fb_field
$table_descr = array(
	'id'	=>	"IDENTITY",
	'form_id'	=>	"INT NOT_NULL DEFAULT 0",
	'type'	=>	"INT NULL",
	'position'	=>	"INT NULL",
	'style'	=>	"VARCHAR(100) NULL",
	'required'	=>	"INT NULL",
	'disabled'	=>	"INT NULL",
	'string_format'	=>	"INT NULL",
	'label'	=>	"VARCHAR(255) NULL",
	'items'	=>	"CLOB NULL",
	'constraint_reg_exp'	=>	"VARCHAR(255) NULL",
	'constraint_more_than'	=>	"INT_DATE NULL",
	'constraint_less_than'	=>	"INT_DATE NULL",
	'constraint_size_bigger_than'	=>	"INT NULL",
	'constraint_size_smaller_than'	=>	"INT NULL",
	'group_cells'	=>	"INT NULL",
	'two_cells'	=>	"INT NULL",
	'title_size'	=>	"INT NULL",
	'field_size'	=>	"INT NULL",
	'sym_name'	=>	"VARCHAR(80) NULL",
	'dynamic'	=>	"INT NOT_NULL DEFAULT 0",
	'style2'	=>	"VARCHAR(100) NULL",
	'picklist'	=>	"INT NOT_NULL DEFAULT 0",
	'on_top'	=>	"INT NOT_NULL DEFAULT 0",
	'description'	=>	"VARCHAR_MAX NULL",
	'default_value'	=>	"CLOB NULL",
	'inline_layout'	=>	"INT NOT_NULL DEFAULT 0",
	'is_calculated'	=>	"BOOL NULL DEFAULT 0",
);

$db->CreateTable('fb_field', $table_descr, true);
$db->CreateIndex('fb_field', 'fb_field_form_id', 'form_id');
$db->CreateIndex('fb_field', 'fb_field_sym_name', 'sym_name');



// fb_field_data
$table_descr = array(
	'form_data_id'	=>	"INT NOT_NULL DEFAULT 0",
	'value'	=>	"VARCHAR_MAX NULL",
	'value_text'	=>	"CLOB NULL",
	'field_sym_name'	=>	"VARCHAR(80) NULL",
	'value_int'	=>	"INT_DATE NULL DEFAULT 0",
);

$db->CreateTable('fb_field_data', $table_descr, true);
$db->CreateUniqueIndex('fb_field_data', 'fb_field_data_idx1', 'form_data_id', 'field_sym_name');



// fb_form
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'created'	=>	"INT_DATE NULL",
	'owner'	=>	"INT NULL",
	'last_modified'	=>	"INT_DATE NULL",
	'last_modified_by'	=>	"INT NULL",
	'version_comment'	=>	"VARCHAR(1000) NULL",
	'primary_version_id'	=>	"INT NULL",
	'version'	=>	"INT NOT_NULL DEFAULT 1",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'perm_id'	=>	"INT NULL",
	'category_id'	=>	"INT NULL",
	'stylesheet'	=>	"CLOB NULL",
	'app_id'	=>	"INT NOT_NULL DEFAULT 0",
	'sym_name'	=>	"VARCHAR(80) NULL",
	'send_fields'	=>	"VARCHAR_MAX NULL",
	'css_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('fb_form', $table_descr, true);



// fb_form_css
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(244) NULL",
	'style'	=>	"CLOB NULL",
	'is_default'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('fb_form_css', $table_descr, true);



// fb_form_data
$table_descr = array(
	'id'	=>	"IDENTITY",
	'form_id'	=>	"INT NOT_NULL DEFAULT 0",
	'date_filled'	=>	"INT_DATE NULL",
	'filled_by'	=>	"INT NULL",
);

$db->CreateTable('fb_form_data', $table_descr, true);
$db->CreateIndex('fb_form_data', 'fb_form_data_form_id', 'form_id');



// fb_section
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'position'	=>	"INT NULL",
	'is_visible'	=>	"INT NULL",
	'form_id'	=>	"INT NULL",
	'style'	=>	"VARCHAR(100) NULL",
	'sym_name'	=>	"VARCHAR(80) NULL",
	'new_tab'	=>	"INT NOT_NULL DEFAULT 0",
	'description'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('fb_section', $table_descr, true);



// filter_options
$table_descr = array(
	'filter_id'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(255) NULL",
	'value'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('filter_options', $table_descr, true);



// filters
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NULL DEFAULT 0",
	'type'	=>	"INT NULL DEFAULT 0",
	'name'	=>	"VARCHAR(128) NULL",
);

$db->CreateTable('filters', $table_descr, true);



// forum_attachment
$table_descr = array(
	'id'	=>	"IDENTITY",
	'message_id'	=>	"INT NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('forum_attachment', $table_descr, true);



// forum_boards
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'display_order'	=>	"INT NULL",
	'codename'	=>	"VARCHAR(255) NULL",
	'exp_type'	=>	"INT NULL DEFAULT 0",
	'exp_value'	=>	"INT NULL DEFAULT 0",
	'visible'	=>	"INT NOT_NULL DEFAULT 0",
	'perm_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('forum_boards', $table_descr, true);



// forum_category
$table_descr = array(
	'id'	=>	"IDENTITY",
	'board_id'	=>	"INT NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'exp_type'	=>	"INT NULL DEFAULT 0",
	'exp_value'	=>	"INT NULL DEFAULT 0",
	'perm_id'	=>	"INT NOT_NULL DEFAULT 0",
	'moder_policy'	=>	"INT NOT_NULL DEFAULT 0",
	'display_order'	=>	"INT NULL",
	'is_rateable'	=>	"INT NOT_NULL DEFAULT 0",
	'rate_first_only'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('forum_category', $table_descr, true);
$db->CreateIndex('forum_category', 'forum_category_idx1', 'id', 'board_id');



// forum_message_rating
$table_descr = array(
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'message_id'	=>	"INT NOT_NULL DEFAULT 0",
	'rate'	=>	"INT NULL",
);

$db->CreateTable('forum_message_rating', $table_descr, true);



// forum_messages
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NULL",
	'category_id'	=>	"INT NULL",
	'topic_id'	=>	"INT NULL",
	'subject'	=>	"VARCHAR(255) NULL",
	'message'	=>	"CLOB NULL",
	'parent_id'	=>	"INT NULL",
	'editor_id'	=>	"INT NULL",
	'username'	=>	"VARCHAR(255) NULL",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'original_id'	=>	"INT NOT_NULL DEFAULT 0",
	'create_date'	=>	"INT_DATE NULL",
	'edit_date'	=>	"INT_DATE NULL",
	'average_rate'	=>	"FLOAT NULL",
	'rate_votes_count'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('forum_messages', $table_descr, true);
$db->CreateIndex('forum_messages', 'forum_messages_parent', 'parent_id');
$db->CreateIndex('forum_messages', 'forum_messages_user_id', 'user_id');
$db->CreateIndex('forum_messages', 'forum_messages_category_id', 'category_id');
$db->CreateIndex('forum_messages', 'forum_messages_topic_id', 'topic_id');



// forum_notification
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NULL",
	'category_id'	=>	"INT NULL",
	'topic_id'	=>	"INT NULL",
	'message_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('forum_notification', $table_descr, true);



// forum_read_messages
$table_descr = array(
	'user_id'	=>	"INT NULL",
	'message_id'	=>	"INT NULL",
	'topic_id'	=>	"INT NULL",
);

$db->CreateTable('forum_read_messages', $table_descr, true);



// forum_topic
$table_descr = array(
	'id'	=>	"IDENTITY",
	'category_id'	=>	"INT NOT_NULL DEFAULT 0",
	'closed'	=>	"INT NOT_NULL DEFAULT 0",
	'create_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'messages_count'	=>	"INT NOT_NULL DEFAULT 0",
	'important'	=>	"INT NOT_NULL DEFAULT 0",
	'subject'	=>	"VARCHAR(255) NULL",
	'user_id'	=>	"INT NULL",
	'username'	=>	"VARCHAR(255) NULL",
	'latest_post_time'	=>	"INT_DATE NULL",
	'latest_user_id'	=>	"INT NULL",
	'latest_message_id'	=>	"INT NULL",
	'expiration'	=>	"INT_DATE NULL",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'moved_topic_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('forum_topic', $table_descr, true);



// fuu_main
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'upload_date'	=>	"INT NOT_NULL DEFAULT 0",
	'filename'	=>	"VARCHAR(255) NULL",
	'filesize_total'	=>	"INT NOT_NULL DEFAULT 0",
	'filesize_transferred'	=>	"INT NOT_NULL DEFAULT 0",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'file_key'	=>	"VARCHAR(100) NULL",
);

$db->CreateTable('fuu_main', $table_descr, true);



// groups
$table_descr = array(
	'groupid'	=>	"IDENTITY",
	'groupname'	=>	"VARCHAR(255) NULL",
	'default_skin'	=>	"INT NOT_NULL DEFAULT 0",
	'inactive'	=>	"BOOL NOT_NULL DEFAULT 0",
	'parent_id'	=>	"INT NOT_NULL DEFAULT 0",
	'crm_manager'	=>	"INT NULL",
	'crm_manager2'	=>	"INT NULL",
	'owner'	=>	"INT NOT_NULL DEFAULT 0",
	'description'	=>	"VARCHAR_MAX NULL",
	'date_created'	=>	"INT_DATE NULL",
	'ex_area_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('groups', $table_descr, true);



// hd_bbcode_attachment
$table_descr = array(
	'id'	=>	"IDENTITY",
	'metadatafile_id'	=>	"INT NOT_NULL",
	'refcount'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_bbcode_attachment', $table_descr, true);



// hd_fields_group
$table_descr = array(
	'id'	=>	"IDENTITY",
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(100) NULL",
);

$db->CreateTable('hd_fields_group', $table_descr, true);



// hd_fields_group_content
$table_descr = array(
	'group_id'	=>	"INT NOT_NULL DEFAULT 0",
	'field_sym_name'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('hd_fields_group_content', $table_descr, true);



// hd_fields_rights
$table_descr = array(
	'rule_id'	=>	"INT NOT_NULL DEFAULT 0",
	'group_id'	=>	"INT NOT_NULL DEFAULT 0",
	'pos'	=>	"INT NOT_NULL DEFAULT 0",
	'view_allow_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'view_deny_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'edit_allow_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'edit_deny_rights'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_fields_rights', $table_descr, true);
$db->CreateIndex('hd_fields_rights', 'hd_fields_rights_group_rule', 'group_id', 'rule_id');



// hd_fields_rule
$table_descr = array(
	'id'	=>	"IDENTITY",
	'pos'	=>	"INT NOT_NULL DEFAULT 0",
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(255) NULL",
	'for_fields_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'for_workflow'	=>	"INT NOT_NULL DEFAULT 0",
	'for_sla'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_fields_rule', $table_descr, true);



// hd_fields_rule_field
$table_descr = array(
	'rule_id'	=>	"INT NOT_NULL DEFAULT 0",
	'field_symname'	=>	"VARCHAR(60) NULL",
	'value'	=>	"VARCHAR_MAX NULL",
	'predicat'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_fields_rule_field', $table_descr, true);



// hd_issue
$table_descr = array(
	'id'	=>	"IDENTITY",
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'form_data_id'	=>	"INT NOT_NULL DEFAULT 0",
	'id_in_project'	=>	"INT NOT_NULL DEFAULT 0",
	'reporter'	=>	"INT NOT_NULL DEFAULT 0",
	'created'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'last_modified'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'status'	=>	"VARCHAR(100) NULL DEFAULT NULL",
	'assigned'	=>	"INT NOT_NULL DEFAULT 0",
	'archived'	=>	"INT NOT_NULL DEFAULT 0",
	'crm_opp_id'	=>	"INT NOT_NULL DEFAULT 0",
	'crm_contact_id'	=>	"INT NOT_NULL DEFAULT 0",
	'crm_company_id'	=>	"INT NOT_NULL DEFAULT 0",
	'traffic_light'	=>	"INT NOT_NULL DEFAULT 0",
	'search_data'	=>	"CLOB NULL",
	'like_count'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_issue', $table_descr, true);
$db->CreateIndex('hd_issue', 'hd_issue_project_id', 'project_id', 'archived');
$db->CreateIndex('hd_issue', 'idx_status_form_data_project_id', 'status', 'form_data_id', 'project_id');
$db->CreateIndex('hd_issue', 'idx_project_id_in_project', 'project_id', 'id_in_project');
$db->CreateIndex('hd_issue', 'idx_assigned_status_project_id', 'assigned', 'status', 'project_id');



// hd_issue_draft
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NULL",
	'project_id'	=>	"INT NOT_NULL",
	'date_created'	=>	"INT_DATE NULL",
	'status'	=>	"INT NULL",
	'data'	=>	"CLOB NULL",
);

$db->CreateTable('hd_issue_draft', $table_descr, true);



// hd_issue_file
$table_descr = array(
	'id'	=>	"IDENTITY",
	'issue_id'	=>	"INT NOT_NULL DEFAULT 0",
	'date1'	=>	"INT_DATE NULL",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'filename'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR(255) NULL",
	'is_private'	=>	"BOOL NOT_NULL DEFAULT 0",
	'note_id'	=>	"INT NULL",
);

$db->CreateTable('hd_issue_file', $table_descr, true);
$db->CreateIndex('hd_issue_file', 'hd_issue_file_issue_id', 'issue_id');



// hd_issue_history
$table_descr = array(
	'id'	=>	"IDENTITY",
	'issue_id'	=>	"INT NOT_NULL DEFAULT 0",
	'date1'	=>	"INT_DATE NULL",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'field'	=>	"VARCHAR(255) NULL",
	'field_symname'	=>	"VARCHAR(255) NULL",
	'changes'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('hd_issue_history', $table_descr, true);
$db->CreateIndex('hd_issue_history', 'hd_issue_history_issue_id', 'issue_id');



// hd_issue_import_log
$table_descr = array(
	'id'	=>	"IDENTITY",
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'import_key'	=>	"INT NOT_NULL DEFAULT 0",
	'content'	=>	"VARCHAR_MAX NULL",
	'import_sequence'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_issue_import_log', $table_descr, true);



// hd_issue_note
$table_descr = array(
	'id'	=>	"IDENTITY",
	'issue_id'	=>	"INT NOT_NULL DEFAULT 0",
	'date1'	=>	"INT_DATE NULL",
	'owner'	=>	"INT NOT_NULL DEFAULT 0",
	'note'	=>	"CLOB NULL",
	'private_note'	=>	"BOOL NULL DEFAULT 0",
);

$db->CreateTable('hd_issue_note', $table_descr, true);
$db->CreateIndex('hd_issue_note', 'hd_issue_note_issue_id', 'issue_id');



// hd_issue_sla_timers
$table_descr = array(
	'issue_id'	=>	"INT NOT_NULL DEFAULT 0",
	'default_timer'	=>	"INT NOT_NULL DEFAULT 0",
	'status_change_timer'	=>	"INT NOT_NULL DEFAULT 0",
	'timers_last_updated'	=>	"INT_DATE NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_issue_sla_timers', $table_descr, true);
$db->CreateIndex('hd_issue_sla_timers', 'hd_issue_sla_timers_issue_id', 'issue_id');



// hd_issue_sla_update
$table_descr = array(
	'issue_id'	=>	"INT NOT_NULL DEFAULT 0",
	'update_time'	=>	"INT_DATE NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_issue_sla_update', $table_descr, true);
$db->CreateIndex('hd_issue_sla_update', 'hd_issue_sla_update_issue_id', 'issue_id');



// hd_issue_status_approved
$table_descr = array(
	'issue_id'	=>	"INT NOT_NULL DEFAULT 0",
	'status_value'	=>	"VARCHAR(255) NULL",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'date_approved'	=>	"INT_DATE NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_issue_status_approved', $table_descr, true);
$db->CreateIndex('hd_issue_status_approved', 'hd_issue_status_appr_issue_id', 'issue_id');



// hd_issue_status_change
$table_descr = array(
	'issue_id'	=>	"INT NULL",
	'date_changed'	=>	"INT_DATE NULL",
	'status_old'	=>	"VARCHAR(100) NULL",
	'status_new'	=>	"VARCHAR(100) NULL",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_issue_status_change', $table_descr, true);



// hd_issue_status_history
$table_descr = array(
	'issue_id'	=>	"INT NULL",
	'status'	=>	"VARCHAR(100) NULL",
	'date_start'	=>	"INT_DATE NULL",
	'date_end'	=>	"INT_DATE NULL",
);

$db->CreateTable('hd_issue_status_history', $table_descr, true);



// hd_issue_status_statistic
$table_descr = array(
	'date_day'	=>	"INT NOT_NULL",
	'project_id'	=>	"INT NOT_NULL",
	'status'	=>	"VARCHAR(255) NULL",
	'total'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_issue_status_statistic', $table_descr, true);



// hd_issue_timers
$table_descr = array(
	'id'	=>	"IDENTITY",
	'issue_id'	=>	"INT NULL",
	'timer_id'	=>	"INT NULL",
	'flag_value'	=>	"BOOL NOT_NULL",
	'threshold'	=>	"INT_DATE NULL",
);

$db->CreateTable('hd_issue_timers', $table_descr, true);



// hd_issue_user
$table_descr = array(
	'id'	=>	"IDENTITY",
	'issue_id'	=>	"INT NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'date1'	=>	"INT_DATE NULL",
);

$db->CreateTable('hd_issue_user', $table_descr, true);
$db->CreateUniqueIndex('hd_issue_user', 'hd_issue_user_unique_followers', 'issue_id', 'user_id');



// hd_processed_messages
$table_descr = array(
	'project_id'	=>	"INT NULL",
	'msg_id'	=>	"INT NULL",
);

$db->CreateTable('hd_processed_messages', $table_descr, true);



// hd_project
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(160) NULL",
	'description'	=>	"VARCHAR(255) NULL",
	'status'	=>	"INT NULL",
	'list_form_fields'	=>	"CLOB NULL",
	'send_form_fields'	=>	"CLOB NULL",
	'issues_colors'	=>	"CLOB NULL",
	'default_filter'	=>	"CLOB NULL",
	'issues_on_page'	=>	"INT NULL",
	'app_id'	=>	"INT NOT_NULL DEFAULT 0",
	'issue_age'	=>	"INT NOT_NULL DEFAULT 0",
	'mail_account_id'	=>	"INT NULL DEFAULT 0",
	'from_field_save'	=>	"VARCHAR(80) NULL",
	'subject_field_save'	=>	"VARCHAR(80) NULL",
	'body_field_save'	=>	"VARCHAR(80) NULL",
	'process_mail_attachments'	=>	"BOOL NULL DEFAULT 0",
	'view_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'update_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'report_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'handle_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'update_status_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'assign_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'notes_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'files_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'manage_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'statistic_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'view_notes_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'view_files_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'view_history_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'private_notes_rights'	=>	"INT NULL DEFAULT 0",
	'def_sort_field'	=>	"VARCHAR(80) NULL",
	'def_sort_dir'	=>	"INT NOT_NULL DEFAULT 0",
	'reply_to_email'	=>	"BOOL NOT_NULL DEFAULT 0",
	'reply_subject'	=>	"VARCHAR(255) NULL",
	'reply_text'	=>	"CLOB NULL",
	'notif_subject_field'	=>	"VARCHAR(80) NULL",
	'is_status_field'	=>	"BOOL NOT_NULL DEFAULT 0",
	'is_assigned_field'	=>	"BOOL NOT_NULL DEFAULT 0",
	'issues_id_counter'	=>	"INT NOT_NULL DEFAULT 0",
	'issues_id_prefix'	=>	"VARCHAR(20) NULL",
	'rss_item_title'	=>	"VARCHAR(80) NULL",
	'rss_item_desc'	=>	"VARCHAR(80) NULL",
	'rss_count'	=>	"INT NOT_NULL DEFAULT 20",
	'codename'	=>	"VARCHAR(30) NULL",
	'plugin_name'	=>	"VARCHAR(255) NULL",
	'description_simple'	=>	"CLOB NULL",
	'description_rich'	=>	"CLOB NULL",
	'search_form_fields'	=>	"CLOB NULL",
	'search_columns'	=>	"INT NULL DEFAULT 2",
	'def_notifications'	=>	"INT NOT_NULL DEFAULT 0",
	'issues_primary_field'	=>	"VARCHAR(80) NULL DEFAULT NULL",
	'project_icon'	=>	"VARCHAR(40) NULL DEFAULT NULL",
	'project_icon_color'	=>	"VARCHAR(7) NULL DEFAULT NULL",
	'thankyou_page_display_condition'	=>	"INT NOT_NULL DEFAULT 0",
	'thankyou_page_type'	=>	"INT NOT_NULL DEFAULT 1",
	'thankyou_page_content'	=>	"CLOB NULL",
	'private_notes'	=>	"BOOL NULL DEFAULT 0",
	'from_address'	=>	"VARCHAR(255) NULL",
	'use_mail_service'	=>	"INT NULL DEFAULT 0",
	'mailgun_recipient_address'	=>	"VARCHAR(255) NULL DEFAULT NULL",
	'mailgun_use_html_field'	=>	"BOOL NOT_NULL DEFAULT 0",
	'handle_incoming_mail'	=>	"INT NULL DEFAULT 0",
	'view_stats_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'external_submission'	=>	"BOOL NULL DEFAULT 0",
	'is_likes_enabled'	=>	"INT NOT_NULL DEFAULT 0",
	'is_public_rss_feed'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_project', $table_descr, true);



// hd_project_assigning
$table_descr = array(
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'field_symname'	=>	"VARCHAR(60) NULL",
	'rule_id'	=>	"INT NOT_NULL DEFAULT 0",
	'pos'	=>	"INT NOT_NULL DEFAULT 0",
	'new_value'	=>	"CLOB NULL",
);

$db->CreateTable('hd_project_assigning', $table_descr, true);
$db->CreateIndex('hd_project_assigning', 'hd_project_assign_project_id', 'project_id');



// hd_project_localization
$table_descr = array(
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'local_key'	=>	"VARCHAR(255) NULL",
	'custom_message'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('hd_project_localization', $table_descr, true);



// hd_project_notif_settings
$table_descr = array(
	'id'	=>	"IDENTITY",
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'pos'	=>	"INT NOT_NULL DEFAULT 0",
	'template_id'	=>	"INT NOT_NULL DEFAULT 0",
	'rule_id'	=>	"INT NOT_NULL DEFAULT 0",
	'rule_was_false'	=>	"INT NOT_NULL DEFAULT 0",
	'rights'	=>	"INT NOT_NULL DEFAULT 0",
	'form_field'	=>	"VARCHAR(80) NULL",
	'email_addr'	=>	"VARCHAR(512) NULL",
);

$db->CreateTable('hd_project_notif_settings', $table_descr, true);
$db->CreateIndex('hd_project_notif_settings', 'hd_proj_notif_set_project_id', 'project_id');



// hd_project_notif_template
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'is_html'	=>	"INT NOT_NULL DEFAULT 0",
	'body'	=>	"CLOB NULL",
	'subject'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('hd_project_notif_template', $table_descr, true);
$db->CreateIndex('hd_project_notif_template', 'hd_proj_notif_templ_project_id', 'project_id');



// hd_project_sla_light
$table_descr = array(
	'id'	=>	"IDENTITY",
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'light_label'	=>	"VARCHAR(255) NULL",
	'light_color'	=>	"VARCHAR(20) NULL",
	'position'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_project_sla_light', $table_descr, true);



// hd_project_sla_rule
$table_descr = array(
	'id'	=>	"IDENTITY",
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'light_id'	=>	"INT NOT_NULL DEFAULT 0",
	'time_interval'	=>	"INT NOT_NULL DEFAULT 0",
	'time_from'	=>	"INT NOT_NULL DEFAULT 0",
	'rule_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_project_sla_rule', $table_descr, true);



// hd_project_sla_status
$table_descr = array(
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'status_value'	=>	"VARCHAR(255) NULL",
	'status_type'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_project_sla_status', $table_descr, true);



// hd_project_sla_time_zone
$table_descr = array(
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'time_zone_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_project_sla_time_zone', $table_descr, true);



// hd_project_sla_worktime
$table_descr = array(
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'weekday'	=>	"INT NOT_NULL DEFAULT 0",
	'start_hour'	=>	"INT NOT_NULL DEFAULT 0",
	'start_min'	=>	"INT NOT_NULL DEFAULT 0",
	'end_hour'	=>	"INT NOT_NULL DEFAULT 0",
	'end_min'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_project_sla_worktime', $table_descr, true);
$db->CreateIndex('hd_project_sla_worktime', 'hd_project_sla_work_project_id', 'project_id');



// hd_project_statuses
$table_descr = array(
	'project_id'	=>	"INT NOT_NULL",
	'code'	=>	"VARCHAR(100) NOT_NULL DEFAULT '_'",
	'title'	=>	"VARCHAR(100) NULL",
	'order_no'	=>	"INT NULL",
	'color'	=>	"VARCHAR(10) NULL",
	'description'	=>	"CLOB NULL",
	'is_archived'	=>	"BOOL NOT_NULL DEFAULT 0",
	'archive_idle_time'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_project_statuses', $table_descr, true);
$db->CreatePrimaryKey('hd_project_statuses', 'project_id', 'code');



// hd_project_workflow
$table_descr = array(
	'id'	=>	"IDENTITY",
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'field_symname'	=>	"VARCHAR(60) NULL",
	'rule_id'	=>	"INT NOT_NULL DEFAULT 0",
	'pos'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_project_workflow', $table_descr, true);
$db->CreateIndex('hd_project_workflow', 'hd_project_workflow_project_id', 'project_id');



// hd_project_workflow_item
$table_descr = array(
	'workflow_id'	=>	"INT NOT_NULL DEFAULT 0",
	'options'	=>	"VARCHAR_MAX NULL",
	'approve_options'	=>	"VARCHAR_MAX NULL",
	'role_bitmask'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_project_workflow_item', $table_descr, true);
$db->CreateIndex('hd_project_workflow_item', 'hd_project_workflow_item_idx1', 'workflow_id');



// hd_report
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'date_created'	=>	"INT_DATE NULL",
	'date_last_modified'	=>	"INT_DATE NULL",
	'date_last_accessed'	=>	"INT_DATE NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'hidden'	=>	"INT NOT_NULL DEFAULT 0",
	'is_custom'	=>	"INT NOT_NULL DEFAULT 0",
	'template_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_report', $table_descr, true);



// hd_report_custom_data
$table_descr = array(
	'id'	=>	"IDENTITY",
	'report_id'	=>	"INT NOT_NULL DEFAULT 0",
	'var'	=>	"VARCHAR(255) NULL",
	'is_user_parameter'	=>	"INT NOT_NULL DEFAULT 0",
	'value'	=>	"CLOB NULL",
);

$db->CreateTable('hd_report_custom_data', $table_descr, true);



// hd_report_data
$table_descr = array(
	'id'	=>	"IDENTITY",
	'report_id'	=>	"INT NOT_NULL DEFAULT 0",
	'step'	=>	"INT NOT_NULL",
	'var'	=>	"VARCHAR(255) NULL",
	'value'	=>	"CLOB NULL",
);

$db->CreateTable('hd_report_data', $table_descr, true);



// hd_report_template
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'class_name'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('hd_report_template', $table_descr, true);



// hd_role
$table_descr = array(
	'id'	=>	"IDENTITY",
	'pos'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(255) NULL",
	'bitmask'	=>	"INT NOT_NULL DEFAULT 0",
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_role', $table_descr, true);



// hd_status_group
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'state'	=>	"INT NOT_NULL DEFAULT 0",
	'project_id'	=>	"INT NOT_NULL",
);

$db->CreateTable('hd_status_group', $table_descr, true);



// hd_status_group_member
$table_descr = array(
	'status_code'	=>	"VARCHAR(100) NULL",
	'group_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_status_group_member', $table_descr, true);
$db->CreateIndex('hd_status_group_member', 'idx_group_id', 'group_id');



// hd_timers
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'project_id'	=>	"INT NOT_NULL",
	'field_name'	=>	"VARCHAR(80) NULL",
	'duration'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('hd_timers', $table_descr, true);



// hd_trigger
$table_descr = array(
	'id'	=>	"IDENTITY",
	'pos'	=>	"INT NOT_NULL DEFAULT 0",
	'project_id'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(255) NULL",
	'in_system'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_trigger', $table_descr, true);



// hd_trigger_rule
$table_descr = array(
	'trigger_id'	=>	"INT NOT_NULL DEFAULT 0",
	'rule_type'	=>	"INT NOT_NULL",
	'negative'	=>	"BOOL NOT_NULL DEFAULT 0",
	'field_symname'	=>	"VARCHAR(80) NULL",
	'value'	=>	"VARCHAR_MAX NULL",
	'predicat'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hd_trigger_rule', $table_descr, true);



// hd_user_settings
$table_descr = array(
	'user_id'	=>	"INT NULL",
	'project_id'	=>	"INT NULL",
	'reporter_option'	=>	"INT NULL",
	'handler_option'	=>	"INT NULL",
	'new_option'	=>	"INT NULL",
);

$db->CreateTable('hd_user_settings', $table_descr, true);



// hpl_config
$table_descr = array(
	'year_start'	=>	"BOOL NOT_NULL DEFAULT 0",
	'common_year'	=>	"INT NULL",
	'ical_notification'	=>	"INT NULL DEFAULT 0",
);

$db->CreateTable('hpl_config', $table_descr, true);



// hpl_days
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(30) NULL",
	'hpl_char'	=>	"VARCHAR(4) NULL",
	'can_decline'	=>	"BOOL NOT_NULL DEFAULT 0",
	'can_half_day'	=>	"BOOL NOT_NULL DEFAULT 0",
	'limit_action'	=>	"BOOL NOT_NULL DEFAULT 0",
	'notify_to'	=>	"BOOL NOT_NULL DEFAULT 0",
	'font_color'	=>	"VARCHAR(7) NULL",
	'bg_color'	=>	"VARCHAR(7) NULL",
	'stat'	=>	"BOOL NOT_NULL DEFAULT 0",
	'can_over_global'	=>	"INT NOT_NULL DEFAULT 0",
	'is_system_day'	=>	"BOOL NOT_NULL DEFAULT 0",
	'user_comment_mandatory'	=>	"BOOL NOT_NULL DEFAULT 1",
);

$db->CreateTable('hpl_days', $table_descr, true);
$db->CreateIndex('hpl_days', 'hpl_days_stat', 'stat');



// hpl_group_names
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('hpl_group_names', $table_descr, true);



// hpl_group_report_users
$table_descr = array(
	'groupid'	=>	"INT NULL",
	'userid'	=>	"INT NULL",
);

$db->CreateTable('hpl_group_report_users', $table_descr, true);



// hpl_group_users
$table_descr = array(
	'groupid'	=>	"INT NULL",
	'userid'	=>	"INT NULL",
);

$db->CreateTable('hpl_group_users', $table_descr, true);



// hpl_groups
$table_descr = array(
	'groupid'	=>	"INT NOT_NULL DEFAULT 0",
	'parent_id'	=>	"INT NOT_NULL DEFAULT 0",
	'man1_id'	=>	"INT NOT_NULL DEFAULT 0",
	'man2_id'	=>	"INT NOT_NULL DEFAULT 0",
	'state'	=>	"INT NULL",
	'pattern'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('hpl_groups', $table_descr, true);



// hpl_managers
$table_descr = array(
	'id'	=>	"IDENTITY",
	'obj_type'	=>	"INT NOT_NULL DEFAULT 0",
	'obj_id'	=>	"INT NOT_NULL DEFAULT 0",
	'manager_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hpl_managers', $table_descr, true);



// hpl_request
$table_descr = array(
	'id'	=>	"IDENTITY",
	'date_start'	=>	"INT NOT_NULL",
	'date_end'	=>	"INT NOT_NULL",
	'day_id'	=>	"INT NOT_NULL",
	'day_part'	=>	"INT NOT_NULL DEFAULT 1",
	'user_id'	=>	"INT NOT_NULL",
	'comment_text'	=>	"VARCHAR(512) NULL",
	'status'	=>	"INT NULL DEFAULT 2",
	'date_requested'	=>	"INT_DATE NULL",
	'requested_by'	=>	"INT NULL",
	'date_approved'	=>	"INT_DATE NULL",
	'approved_by'	=>	"INT NULL",
);

$db->CreateTable('hpl_request', $table_descr, true);
$db->CreateIndex('hpl_request', 'hpl_request_date_start', 'date_start');
$db->CreateIndex('hpl_request', 'hpl_request_date_end', 'date_end');
$db->CreateIndex('hpl_request', 'hpl_request_user_id', 'user_id');
$db->CreateIndex('hpl_request', 'hpl_request_status', 'status');
$db->CreateIndex('hpl_request', 'hpl_request_date_requested', 'date_requested');
$db->CreateIndex('hpl_request', 'hpl_request_user_id_status', 'user_id', 'status');
$db->CreateIndex('hpl_request', 'hpl_request_date_status', 'date_start', 'date_end', 'status');
$db->CreateIndex('hpl_request', 'hpl_request_cur_user_days', 'date_start', 'date_end', 'user_id', 'status');



// hpl_stat
$table_descr = array(
	'year'	=>	"INT NOT_NULL DEFAULT 0",
	'day_id'	=>	"INT NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'day_used'	=>	"FLOAT NULL",
	'day_req'	=>	"FLOAT NULL",
	'day_dec'	=>	"FLOAT NULL",
);

$db->CreateTable('hpl_stat', $table_descr, true);
$db->CreateIndex('hpl_stat', 'hpl_stat_day_id', 'day_id', 'user_id');
$db->CreateIndex('hpl_stat', 'hpl_stat_year', 'year');



// hpl_user_days
$table_descr = array(
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'day_id'	=>	"INT NOT_NULL DEFAULT 0",
	'status'	=>	"BOOL NOT_NULL DEFAULT 0",
	'prev_id'	=>	"INT NOT_NULL DEFAULT 0",
	'prev_part'	=>	"BOOL NOT_NULL DEFAULT 0",
	'half_day'	=>	"BOOL NOT_NULL DEFAULT 0",
	'year_num'	=>	"INT NOT_NULL DEFAULT 0",
	'month_num'	=>	"BOOL NOT_NULL DEFAULT 0",
	'day_num'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('hpl_user_days', $table_descr, true);
$db->CreateIndex('hpl_user_days', 'hpl_user_days_user_id', 'user_id', 'day_id', 'year_num', 'month_num', 'day_num');



// hpl_users
$table_descr = array(
	'id'	=>	"IDENTITY",
	'userid'	=>	"INT NOT_NULL DEFAULT 0",
	'year'	=>	"INT NOT_NULL DEFAULT 0",
	'hld_total'	=>	"FLOAT NOT_NULL DEFAULT 0",
	'hld_used'	=>	"FLOAT NULL",
	'hld_carried'	=>	"FLOAT NULL",
	'hld_carried_used'	=>	"FLOAT NULL",
	'is_year_closed'	=>	"BOOL NULL DEFAULT 0",
);

$db->CreateTable('hpl_users', $table_descr, true);
$db->CreateIndex('hpl_users', 'hpl_users_year_userid', 'year', 'userid');



// hpl_year_days
$table_descr = array(
	'zone_id'	=>	"INT NOT_NULL DEFAULT 0",
	'every_flag'	=>	"BOOL NOT_NULL DEFAULT 0",
	'year_num'	=>	"INT NOT_NULL DEFAULT 0",
	'month_num'	=>	"BOOL NOT_NULL DEFAULT 0",
	'day_num'	=>	"BOOL NOT_NULL DEFAULT 0",
	'day_id'	=>	"INT NOT_NULL DEFAULT 0",
	'tmp'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('hpl_year_days', $table_descr, true);
$db->CreateIndex('hpl_year_days', 'hpl_year_days_zone_id', 'zone_id', 'every_flag', 'day_id');
$db->CreateIndex('hpl_year_days', 'hpl_year_days_year', 'year_num');
$db->CreateIndex('hpl_year_days', 'hpl_year_days_month_num', 'month_num');



// hpl_zones_config
$table_descr = array(
	'zone_id'	=>	"INT NULL",
	'carry_limit'	=>	"INT NULL",
	'carry_ttl'	=>	"INT NULL",
	'year_start'	=>	"INT NOT_NULL DEFAULT 1",
);

$db->CreateTable('hpl_zones_config', $table_descr, true);



// im_conversations
$table_descr = array(
	'id'	=>	"IDENTITY",
);

$db->CreateTable('im_conversations', $table_descr, true);



// im_conversations_users
$table_descr = array(
	'conversation_id'	=>	"INT NOT_NULL",
	'user_id'	=>	"INT NOT_NULL",
);

$db->CreateTable('im_conversations_users', $table_descr, true);
$db->CreatePrimaryKey('im_conversations_users', 'conversation_id', 'user_id');
$db->CreateIndex('im_conversations_users', 'idx_conversation_id', 'conversation_id');
$db->CreateIndex('im_conversations_users', 'idx_user_id', 'user_id');



// im_digest_queue
$table_descr = array(
	'id'	=>	"IDENTITY",
	'im_msg_id'	=>	"INT NULL",
	'user_id'	=>	"INT NULL",
	'app_type'	=>	"VARCHAR(100) NULL",
);

$db->CreateTable('im_digest_queue', $table_descr, true);



// im_digest_schedule
$table_descr = array(
	'user_id'	=>	"INT NULL",
	'interval_type'	=>	"INT NULL",
	'last_sent'	=>	"INT NULL",
);

$db->CreateTable('im_digest_schedule', $table_descr, true);



// im_lifetime
$table_descr = array(
	'user_id'	=>	"INT NOT_NULL",
	'message_type'	=>	"INT NOT_NULL",
	'seconds'	=>	"INT NOT_NULL",
);

$db->CreateTable('im_lifetime', $table_descr, true);
$db->CreatePrimaryKey('im_lifetime', 'user_id', 'message_type');
$db->CreateIndex('im_lifetime', 'im_lifetime_user_id', 'user_id');
$db->CreateIndex('im_lifetime', 'im_lifetime_message_type', 'message_type');



// im_notification_methods
$table_descr = array(
	'user_id'	=>	"INT NOT_NULL",
	'app_type'	=>	"VARCHAR(100) NOT_NULL DEFAULT 'system'",
	'notification_method'	=>	"INT NOT_NULL",
);

$db->CreateTable('im_notification_methods', $table_descr, true);
$db->CreatePrimaryKey('im_notification_methods', 'user_id', 'app_type');
$db->CreateIndex('im_notification_methods', 'im_notif_methods_user_id', 'user_id');
$db->CreateIndex('im_notification_methods', 'im_notif_methods_u_app_type', 'user_id', 'app_type');
$db->CreateIndex('im_notification_methods', 'im_notif_methods_app_type', 'app_type');



// im_recipients
$table_descr = array(
	'imsg_id'	=>	"INT NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'read_yet'	=>	"BOOL NOT_NULL DEFAULT 0",
	'deleted'	=>	"BOOL NOT_NULL DEFAULT 0",
	'digest'	=>	"INT NULL DEFAULT 0",
);

$db->CreateTable('im_recipients', $table_descr, true);
$db->CreatePrimaryKey('im_recipients', 'imsg_id', 'user_id');
$db->CreateIndex('im_recipients', 'im_recipients_u_d_r', 'user_id', 'deleted', 'read_yet');



// image_albums
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'metadataset_id'	=>	"INT NOT_NULL DEFAULT 0",
	'date_created'	=>	"INT_DATE NULL",
	'list_columns'	=>	"VARCHAR_MAX NULL",
	'list_filter_tags'	=>	"VARCHAR_MAX NULL",
	'cover_image_id'	=>	"INT NOT_NULL DEFAULT 0",
	'publishable'	=>	"BOOL NULL",
	'comments_enabled'	=>	"BOOL NOT_NULL DEFAULT 1",
);

$db->CreateTable('image_albums', $table_descr, true);



// image_collections
$table_descr = array(
	'id'	=>	"IDENTITY",
	'album_id'	=>	"INT NOT_NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'date_created'	=>	"INT_DATE NULL",
);

$db->CreateTable('image_collections', $table_descr, true);



// image_collections_data
$table_descr = array(
	'collection_id'	=>	"INT NOT_NULL",
	'image_id'	=>	"INT NOT_NULL",
);

$db->CreateTable('image_collections_data', $table_descr, true);



// image_files
$table_descr = array(
	'id'	=>	"IDENTITY",
	'image_id'	=>	"INT NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL",
	'file_type'	=>	"INT NOT_NULL",
	'file_size'	=>	"INT NOT_NULL",
	'width'	=>	"INT NOT_NULL",
	'height'	=>	"INT NOT_NULL",
	'prefix'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('image_files', $table_descr, true);



// image_lightboxes
$table_descr = array(
	'id'	=>	"IDENTITY",
	'image_id'	=>	"INT NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('image_lightboxes', $table_descr, true);



// image_tags
$table_descr = array(
	'image_id'	=>	"INT NOT_NULL DEFAULT 0",
	'tag_id'	=>	"INT NOT_NULL DEFAULT 0",
	'tag_group_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('image_tags', $table_descr, true);



// images
$table_descr = array(
	'id'	=>	"IDENTITY",
	'album_id'	=>	"INT NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL",
	'owner'	=>	"INT NOT_NULL DEFAULT 0",
	'file_type'	=>	"INT NOT_NULL DEFAULT 0",
	'file_size'	=>	"INT NOT_NULL DEFAULT 0",
	'width'	=>	"INT NOT_NULL DEFAULT 0",
	'height'	=>	"INT NOT_NULL DEFAULT 0",
	'keywords'	=>	"VARCHAR_MAX NULL",
	'size_type'	=>	"INT NOT_NULL DEFAULT 0",
	'date_created'	=>	"INT_DATE NULL",
);

$db->CreateTable('images', $table_descr, true);



// imessages
$table_descr = array(
	'id'	=>	"IDENTITY",
	'from_id'	=>	"INT NOT_NULL DEFAULT 0",
	'message_text'	=>	"CLOB NULL",
	'sent'	=>	"BOOL NOT_NULL DEFAULT 0",
	'deleted'	=>	"BOOL NOT_NULL DEFAULT 0",
	'date_sent'	=>	"INT NULL",
	'subject'	=>	"VARCHAR_MAX NULL",
	'message_type'	=>	"INT NULL",
	'object_id'	=>	"INT NULL",
	'aggregation_id'	=>	"INT NULL",
	'is_sticky'	=>	"INT NOT_NULL DEFAULT 0",
	'conversation_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('imessages', $table_descr, true);
$db->CreateIndex('imessages', 'imessages_message_type', 'message_type');
$db->CreateIndex('imessages', 'imessages_is_sticky', 'is_sticky');
$db->CreateIndex('imessages', 'imessages_from_id', 'from_id');
$db->CreateIndex('imessages', 'idx_conversation_id', 'conversation_id');



// imessages_archive
$table_descr = array(
	'id'	=>	"IDENTITY",
	'fromid'	=>	"INT NOT_NULL DEFAULT 0",
	'toid'	=>	"INT NOT_NULL DEFAULT 0",
	'timesent'	=>	"VARCHAR(10) NULL",
	'messagetext'	=>	"CLOB NULL",
	'readyet'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('imessages_archive', $table_descr, true);
$db->CreateIndex('imessages_archive', 'imessages_archive_toid', 'toid');
$db->CreateIndex('imessages_archive', 'imessages_archive_fromid', 'fromid');



// indexing_file_content_cache
$table_descr = array(
	'type'	=>	"VARCHAR(50) NULL",
	'file_hash'	=>	"VARCHAR(8) NULL",
	'file_size'	=>	"INT NOT_NULL DEFAULT 0",
	'content'	=>	"CLOB NULL",
	'content_size'	=>	"INT NOT_NULL DEFAULT 0",
	'date_accessed'	=>	"INT_DATE NOT_NULL DEFAULT 0",
);

$db->CreateTable('indexing_file_content_cache', $table_descr, true);
$db->CreateIndex('indexing_file_content_cache', 'indexing_file_content_cache_file_hash_file_size_index', 'file_hash', 'file_size');
$db->CreateIndex('indexing_file_content_cache', 'indexing_file_content_cache_type_date_accessed', 'type', 'date_accessed');
$db->CreateIndex('indexing_file_content_cache', 'indexing_file_content_cache_date_accessed', 'date_accessed');



// indexing_queue
$table_descr = array(
	'object_type'	=>	"VARCHAR(64) NULL",
	'object_id'	=>	"VARCHAR(255) NULL",
	'sub_id'	=>	"INT NOT_NULL DEFAULT 0",
	'action'	=>	"INT NOT_NULL DEFAULT 0",
	'time_added'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'extra'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('indexing_queue', $table_descr, true);
$db->CreateIndex('indexing_queue', 'idx_time_added', 'time_added');
$db->CreateIndex('indexing_queue', 'idx_object', 'object_type(50)', 'object_id(50)', 'sub_id');



// infobar_menu_item
$table_descr = array(
	'id'	=>	"IDENTITY",
	'menu_type'	=>	"INT NULL DEFAULT 0",
	'item_type'	=>	"INT NULL DEFAULT 0",
	'user_id'	=>	"INT NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL",
	'url'	=>	"VARCHAR(1024) NULL",
	'display_order'	=>	"INT NULL",
	'new_window'	=>	"INT NULL",
	'is_visible'	=>	"BOOL NULL DEFAULT 0",
	'css_class'	=>	"VARCHAR(100) NULL DEFAULT NULL",
);

$db->CreateTable('infobar_menu_item', $table_descr, true);



// infobar_menu_personal
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL",
	'link'	=>	"VARCHAR(1024) NULL",
	'display_order'	=>	"INT NULL",
	'new_window'	=>	"INT NULL",
);

$db->CreateTable('infobar_menu_personal', $table_descr, true);
$db->CreateIndex('infobar_menu_personal', 'infobar_menu_personal_user_id', 'user_id');



// integration
$table_descr = array(
	'api_name'	=>	"VARCHAR(32) NULL",
	'api_description'	=>	"VARCHAR(128) NOT_NULL DEFAULT 'Enter description'",
	'api_help'	=>	"VARCHAR(512) NULL",
	'json_value'	=>	"VARCHAR(1500) NOT_NULL DEFAULT '{}'",
);

$db->CreateTable('integration', $table_descr, true);
$db->CreatePrimaryKey('integration', 'api_name');



// ip_ranges
$table_descr = array(
	'security_level'	=>	"INT NOT_NULL DEFAULT 0",
	'ipv4_start'	=>	"INT NOT_NULL",
	'ipv4_end'	=>	"INT NOT_NULL",
	'description'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('ip_ranges', $table_descr, true);



// likes
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL",
	'object_id'	=>	"INT NOT_NULL",
	'aggregation'	=>	"INT NOT_NULL",
	'timestamp'	=>	"INT_DATE NULL",
);

$db->CreateTable('likes', $table_descr, true);
$db->CreateIndex('likes', 'likes_aggr_object_id', 'aggregation', 'object_id');



// mail_accounts
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'inbox_id'	=>	"INT NOT_NULL DEFAULT 0",
	'host'	=>	"VARCHAR(255) NULL",
	'port'	=>	"INT NOT_NULL DEFAULT 110",
	'login'	=>	"VARCHAR(255) NULL",
	'pass'	=>	"VARCHAR(255) NULL",
	'use_apop'	=>	"BOOL NOT_NULL DEFAULT 0",
	'del_msgs'	=>	"BOOL NOT_NULL DEFAULT 0",
	'recheck_period'	=>	"INT NOT_NULL DEFAULT 0",
	'from_address'	=>	"VARCHAR(255) NULL",
	'is_default'	=>	"BOOL NOT_NULL DEFAULT 0",
	'wipe_deleted_msgs'	=>	"INT NOT_NULL DEFAULT 0",
	'last_check_time'	=>	"INT NOT_NULL DEFAULT 0",
	'fetch_protocol'	=>	"INT NULL DEFAULT 0",
	'special_type'	=>	"INT NULL DEFAULT 0",
	'auto_confirm_receipt'	=>	"BOOL NULL DEFAULT 0",
	'auto_confirm_reading'	=>	"BOOL NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL",
	'use_ssl'	=>	"BOOL NULL DEFAULT 0",
	'ssl_novalidate_cert'	=>	"BOOL NULL DEFAULT 0",
);

$db->CreateTable('mail_accounts', $table_descr, true);



// mail_fetched_messages
$table_descr = array(
	'account_id'	=>	"INT NULL DEFAULT 0",
	'message_id'	=>	"INT NULL",
	'message_uid'	=>	"VARCHAR(255) NULL DEFAULT '0'",
	'is_deleted'	=>	"INT NULL DEFAULT 0",
);

$db->CreateTable('mail_fetched_messages', $table_descr, true);



// mail_messages
$table_descr = array(
	'id'	=>	"IDENTITY",
	'msgid'	=>	"VARCHAR(255) NULL",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'folder_id'	=>	"INT NOT_NULL DEFAULT 0",
	'unread'	=>	"INT NOT_NULL DEFAULT 1",
	'replied'	=>	"INT NOT_NULL DEFAULT 0",
	'forwarded'	=>	"INT NOT_NULL DEFAULT 0",
	'priority'	=>	"INT NOT_NULL DEFAULT 0",
	'from_field'	=>	"VARCHAR(255) NULL",
	'subject_field'	=>	"VARCHAR(255) NULL",
	'received_date'	=>	"INT NOT_NULL DEFAULT 0",
	'sent_date'	=>	"INT NOT_NULL DEFAULT 0",
	'length'	=>	"BIGINT NOT_NULL DEFAULT 0",
	'preview_text'	=>	"VARCHAR(255) NULL",
	'charset'	=>	"VARCHAR(20) NULL",
	'to_field'	=>	"VARCHAR(1000) NULL",
	'account_id'	=>	"INT NULL DEFAULT 0",
	'attachment'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('mail_messages', $table_descr, true);
$db->CreateIndex('mail_messages', 'mail_messages_folder', 'folder_id');



// mail_queue
$table_descr = array(
	'id'	=>	"IDENTITY",
	'create_time'	=>	"INT NOT_NULL DEFAULT 0",
	'sent_time'	=>	"INT NOT_NULL DEFAULT 0",
	'ip'	=>	"VARCHAR(255) NULL",
	'sender'	=>	"VARCHAR(255) NULL",
	'recipient'	=>	"VARCHAR_MAX NULL",
	'headers'	=>	"CLOB NULL",
	'body'	=>	"CLOB NULL",
	'try_sent'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('mail_queue', $table_descr, true);



// mailservice_domain
$table_descr = array(
	'id'	=>	"IDENTITY",
	'domain'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('mailservice_domain', $table_descr, true);



// metadata
$table_descr = array(
	'id'	=>	"IDENTITY",
	'oid'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(128) NULL",
	'value'	=>	"VARCHAR_MAX NULL",
	'type'	=>	"INT NULL",
);

$db->CreateTable('metadata', $table_descr, true);
$db->CreateIndex('metadata', 'metadata_oid', 'oid');



// metadata_files
$table_descr = array(
	'id'	=>	"IDENTITY",
	'date_added'	=>	"INT_DATE NOT_NULL",
	'secret'	=>	"VARCHAR(40) NULL",
	'realname'	=>	"VARCHAR(512) NULL",
);

$db->CreateTable('metadata_files', $table_descr, true);



// metadata_set
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'set_type'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('metadata_set', $table_descr, true);
$db->CreateIndex('metadata_set', 'metadata_set_type', 'set_type');



// metadata_set_fields
$table_descr = array(
	'set_id'	=>	"INT NOT_NULL DEFAULT 0",
	'field_id'	=>	"INT NOT_NULL DEFAULT 0",
	'display_order'	=>	"INT NULL",
);

$db->CreateTable('metadata_set_fields', $table_descr, true);
$db->CreatePrimaryKey('metadata_set_fields', 'set_id', 'field_id');



// metadata_simple
$table_descr = array(
	'id'	=>	"IDENTITY",
	'aggregation'	=>	"INT NOT_NULL DEFAULT 0",
	'object_id'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(100) NULL",
	'type'	=>	"INT NOT_NULL DEFAULT 0",
	'intval'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'txtval'	=>	"VARCHAR_MAX NULL",
	'clobval'	=>	"CLOB NULL",
	'to_index'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('metadata_simple', $table_descr, true);
$db->CreateIndex('metadata_simple', 'metadata_simple_index_1', 'aggregation', 'object_id', 'name');



// news
$table_descr = array(
	'id'	=>	"IDENTITY",
	'ownerid'	=>	"INT NOT_NULL DEFAULT 0",
	'headline'	=>	"BOOL NULL DEFAULT 0",
	'link'	=>	"VARCHAR(1024) NULL",
	'pub_page_id'	=>	"INT NOT_NULL DEFAULT 0",
	'news_channel_id'	=>	"INT NOT_NULL DEFAULT 0",
	'date_start'	=>	"INT_DATE NULL",
	'date_end'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'news_full_text_type'	=>	"VARCHAR(10) NULL",
	'is_draft'	=>	"BOOL NOT_NULL DEFAULT 0",
	'is_sticky'	=>	"BOOL NOT_NULL DEFAULT 0",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'comments_mode'	=>	"INT NOT_NULL DEFAULT 0",
	'deleted'	=>	"INT NULL DEFAULT 0",
	'date_delete'	=>	"INT_DATE NULL",
	'def_language'	=>	"VARCHAR(5) NULL",
	'notify_readers'	=>	"INT NULL",
	'subscribers_notified'	=>	"BOOL NULL DEFAULT 0",
	'hide_author'	=>	"BOOL NULL DEFAULT 0",
);

$db->CreateTable('news', $table_descr, true);
$db->CreateIndex('news', 'ownerid', 'ownerid');
$db->CreateIndex('news', 'date_start', 'date_start');
$db->CreateIndex('news', 'is_draft', 'is_draft');
$db->CreateIndex('news', 'headline', 'headline');
$db->CreateIndex('news', 'status', 'status');
$db->CreateIndex('news', 'is_sticky', 'is_sticky');



// news_channel
$table_descr = array(
	'id'	=>	"IDENTITY",
	'channel_name'	=>	"VARCHAR(255) NULL",
	'is_default'	=>	"INT NOT_NULL DEFAULT 0",
	'template'	=>	"CLOB NULL",
	'owner'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('news_channel', $table_descr, true);
$db->CreateIndex('news_channel', 'is_default', 'is_default');



// news_channel_users
$table_descr = array(
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'news_channel_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('news_channel_users', $table_descr, true);
$db->CreatePrimaryKey('news_channel_users', 'user_id', 'news_channel_id');
$db->CreateIndex('news_channel_users', 'user_id', 'user_id');
$db->CreateIndex('news_channel_users', 'news_channel_id', 'news_channel_id');



// news_feeds
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'channels'	=>	"VARCHAR_MAX NULL",
	'feed_key'	=>	"VARCHAR(20) NULL",
	'date_created'	=>	"INT_DATE NULL",
	'creator'	=>	"INT NULL",
);

$db->CreateTable('news_feeds', $table_descr, true);
$db->CreateIndex('news_feeds', 'news_feeds_key_index', 'feed_key');



// news_translations
$table_descr = array(
	'id'	=>	"IDENTITY",
	'language'	=>	"VARCHAR(5) NULL",
	'news_id'	=>	"INT NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL",
	'newstext'	=>	"VARCHAR_MAX NULL",
	'news_full_text'	=>	"CLOB NULL",
);

$db->CreateTable('news_translations', $table_descr, true);
$db->CreateIndex('news_translations', 'news_translations_news_id_lang', 'news_id', 'language');



// notification_subscriptions
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL",
	'aggregation'	=>	"INT NOT_NULL",
	'object_id'	=>	"INT NOT_NULL",
	'event'	=>	"INT NOT_NULL",
	'once'	=>	"INT NOT_NULL",
	'date_created'	=>	"INT_DATE NULL",
);

$db->CreateTable('notification_subscriptions', $table_descr, true);



// oauth_access_token_scopes
$table_descr = array(
	'id'	=>	"IDENTITY",
	'access_token'	=>	"VARCHAR(150) NULL",
	'scope'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_access_token_scopes', $table_descr, true);
$db->CreateIndex('oauth_access_token_scopes', 'oauth_access_token_scopes_access_token_foreign', 'access_token');
$db->CreateIndex('oauth_access_token_scopes', 'oauth_access_token_scopes_scope_foreign', 'scope');



// oauth_access_tokens
$table_descr = array(
	'access_token'	=>	"VARCHAR(150) NOT_NULL DEFAULT ' '",
	'expire_time'	=>	"INT NOT_NULL",
);

$db->CreateTable('oauth_access_tokens', $table_descr, true);
$db->CreatePrimaryKey('oauth_access_tokens', 'access_token');



// oauth_auth_codes
$table_descr = array(
	'auth_code'	=>	"VARCHAR(150) NOT_NULL DEFAULT ' '",
	'expire_time'	=>	"INT NOT_NULL",
	'client_redirect_uri'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_auth_codes', $table_descr, true);
$db->CreatePrimaryKey('oauth_auth_codes', 'auth_code');



// oauth_client_redirect_uris
$table_descr = array(
	'client_id'	=>	"VARCHAR(150) NULL",
	'redirect_uri'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_client_redirect_uris', $table_descr, true);



// oauth_clients
$table_descr = array(
	'id'	=>	"VARCHAR(150) NOT_NULL DEFAULT ' '",
	'secret'	=>	"VARCHAR(150) NULL",
	'name'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_clients', $table_descr, true);
$db->CreatePrimaryKey('oauth_clients', 'id');



// oauth_refresh_tokens
$table_descr = array(
	'refresh_token'	=>	"VARCHAR(150) NOT_NULL DEFAULT ' '",
	'expire_time'	=>	"INT NOT_NULL",
	'access_token'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_refresh_tokens', $table_descr, true);
$db->CreatePrimaryKey('oauth_refresh_tokens', 'refresh_token');
$db->CreateIndex('oauth_refresh_tokens', 'oauth_refresh_tokens_access_token_foreign', 'access_token');



// oauth_scopes
$table_descr = array(
	'id'	=>	"VARCHAR(150) NOT_NULL DEFAULT ' '",
	'description'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_scopes', $table_descr, true);
$db->CreatePrimaryKey('oauth_scopes', 'id');



// onesignal_users
$table_descr = array(
	'user_id'	=>	"INT NOT_NULL",
	'player_id'	=>	"VARCHAR(40) NULL",
	'id'	=>	"IDENTITY",
	'user_agent'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('onesignal_users', $table_descr, true);
$db->CreateIndex('onesignal_users', 'user_id_index', 'user_id');



// org_chart
$table_descr = array(
	'id'	=>	"INT NOT_NULL DEFAULT 0",
	'boss_id'	=>	"INT NOT_NULL DEFAULT 0",
	'is_primary'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('org_chart', $table_descr, true);



// org_chart_department
$table_descr = array(
	'id'	=>	"IDENTITY",
	'head_id'	=>	"INT NOT_NULL",
	'title'	=>	"VARCHAR(255) NOT_NULL DEFAULT ' '",
	'slug'	=>	"VARCHAR(255) NOT_NULL DEFAULT ' '",
	'depth'	=>	"INT NOT_NULL",
	'show_above'	=>	"INT NOT_NULL DEFAULT 0",
	'show_disabled_users'	=>	"INT NOT_NULL DEFAULT 1",
);

$db->CreateTable('org_chart_department', $table_descr, true);



// org_chart_exclusions
$table_descr = array(
	'department_id'	=>	"INT NOT_NULL",
	'user_id'	=>	"INT NOT_NULL",
);

$db->CreateTable('org_chart_exclusions', $table_descr, true);



// panels
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(100) NULL",
	'filename'	=>	"VARCHAR(100) NULL",
	'admin_name'	=>	"VARCHAR(100) NULL",
	'symname'	=>	"VARCHAR(20) NULL",
	'css_class'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('panels', $table_descr, true);



// password_recovery
$table_descr = array(
	'id'	=>	"IDENTITY",
	'email_address'	=>	"VARCHAR(200) NULL",
	'expiry'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'recovery_key'	=>	"VARCHAR(32) NULL",
);

$db->CreateTable('password_recovery', $table_descr, true);



// perm_objects
$table_descr = array(
	'id'	=>	"IDENTITY",
	'dummy'	=>	"INT NULL",
);

$db->CreateTable('perm_objects', $table_descr, true);



// permissions
$table_descr = array(
	'class_id'	=>	"INT NOT_NULL DEFAULT 0",
	'object_id'	=>	"INT NOT_NULL DEFAULT 0",
	'perm_owner_class_id'	=>	"INT NOT_NULL DEFAULT 0",
	'perm_owner_id'	=>	"INT NOT_NULL DEFAULT 0",
	'rights'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('permissions', $table_descr, true);
$db->CreateIndex('permissions', 'permissions_rights', 'rights');
$db->CreateIndex('permissions', 'permissions_perm_oclass_id', 'perm_owner_class_id', 'perm_owner_id');
$db->CreateIndex('permissions', 'permissions_object_id', 'object_id');
$db->CreateIndex('permissions', 'permissions_class_id', 'class_id', 'object_id', 'perm_owner_class_id', 'perm_owner_id', 'rights');



// perms_cache
$table_descr = array(
	'class_id'	=>	"INT NOT_NULL",
	'object_id'	=>	"INT NOT_NULL",
	'user_id'	=>	"INT NOT_NULL",
	'rights'	=>	"INT NULL",
	'owner_rights'	=>	"INT NULL",
);

$db->CreateTable('perms_cache', $table_descr, true);
$db->CreateIndex('perms_cache', 'perms_cache_index_1', 'class_id', 'object_id', 'user_id');
$db->CreateIndex('perms_cache', 'perms_cache_index_2', 'user_id');



// project_templates
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(200) NULL",
	'root'	=>	"INT NULL",
	'CRM_related'	=>	"BOOL NULL",
	'forum_board'	=>	"INT NULL",
);

$db->CreateTable('project_templates', $table_descr, true);



// pub_category
$table_descr = array(
	'id'	=>	"IDENTITY",
	'parent'	=>	"INT NOT_NULL DEFAULT 0",
	'owner'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'perm_id'	=>	"INT NOT_NULL DEFAULT 0",
	'deleted'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('pub_category', $table_descr, true);
$db->CreateIndex('pub_category', 'pub_category_del_parent_name', 'deleted', 'parent', 'name(100)');



// pub_element
$table_descr = array(
	'id'	=>	"IDENTITY",
	'page_id'	=>	"INT NOT_NULL DEFAULT 0",
	'type'	=>	"VARCHAR(50) NULL",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'language'	=>	"VARCHAR(10) NULL",
	'body'	=>	"CLOB NULL",
);

$db->CreateTable('pub_element', $table_descr, true);
$db->CreateIndex('pub_element', 'pub_element_page_id', 'page_id');



// pub_element_property
$table_descr = array(
	'id'	=>	"IDENTITY",
	'content_id'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(255) NULL",
	'value'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('pub_element_property', $table_descr, true);
$db->CreateIndex('pub_element_property', 'pub_element_property_content_id', 'content_id');



// pub_page
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'page_comment'	=>	"VARCHAR_MAX NULL",
	'template_id'	=>	"INT NOT_NULL DEFAULT 0",
	'owner'	=>	"INT NOT_NULL DEFAULT 0",
	'cat_id'	=>	"INT NOT_NULL DEFAULT 0",
	'approved'	=>	"INT NOT_NULL DEFAULT 0",
	'status'	=>	"INT NULL DEFAULT 0",
	'primary_page_id'	=>	"INT NULL",
	'area_mask'	=>	"INT NOT_NULL DEFAULT 15",
	'chars_num'	=>	"INT NOT_NULL DEFAULT 0",
	'version'	=>	"INT NOT_NULL DEFAULT 1",
	'last_modified_by'	=>	"INT NULL",
	'perm_id'	=>	"INT NOT_NULL DEFAULT 0",
	'start_publish'	=>	"INT NULL",
	'end_publish'	=>	"INT NULL",
	'is_system'	=>	"INT NOT_NULL DEFAULT 0",
	'date_created'	=>	"INT NULL",
	'date_last_modified'	=>	"INT NULL",
	'deleted'	=>	"BOOL NOT_NULL DEFAULT 0",
	'languages'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('pub_page', $table_descr, true);
$db->CreateIndex('pub_page', 'pub_page_deleted_version', 'deleted', 'version');
$db->CreateIndex('pub_page', 'pub_page_del_parent_title', 'deleted', 'cat_id', 'title(100)');



// pub_template
$table_descr = array(
	'id'	=>	"IDENTITY",
	'screenshot'	=>	"VARCHAR(255) NULL",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'cat_id'	=>	"INT NOT_NULL DEFAULT 0",
	'group_name'	=>	"VARCHAR(128) NULL DEFAULT 'Default group'",
	'languages'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('pub_template', $table_descr, true);



// pub_template_group
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(128) NULL",
);

$db->CreateTable('pub_template_group', $table_descr, true);



// pub_template_property
$table_descr = array(
	'id'	=>	"IDENTITY",
	'template_id'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'type'	=>	"INT NOT_NULL DEFAULT 0",
	'default_value'	=>	"VARCHAR_MAX NULL",
	'editable'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('pub_template_property', $table_descr, true);
$db->CreateIndex('pub_template_property', 'pub_template_property_tmpl_id', 'template_id');



// publish_menu
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'type'	=>	"INT NOT_NULL DEFAULT 0",
	'style'	=>	"VARCHAR(255) NULL",
	'date_created'	=>	"INT NULL",
	'menu_comment'	=>	"VARCHAR(255) NULL",
	'folder_id'	=>	"INT NULL",
	'menu_page_id'	=>	"INT NULL",
	'menu_folder_id'	=>	"INT NULL",
	'menu_trail_page_id'	=>	"INT NULL",
	'menu_trail_sep'	=>	"VARCHAR(255) NULL DEFAULT '>'",
	'menu_trail_show_home'	=>	"BOOL NOT_NULL DEFAULT 0",
	'menu_trail_home_txt'	=>	"VARCHAR(255) NULL",
	'menu_trail_home_url'	=>	"VARCHAR(255) NULL",
	'sync_visib_mode'	=>	"INT NOT_NULL DEFAULT 1",
	'menu_sitemap_page_id'	=>	"INT NULL",
	'sitemap_flag'	=>	"INT NULL",
	'location'	=>	"INT NOT_NULL DEFAULT 1",
	'depth_limit'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('publish_menu', $table_descr, true);



// publish_menunode
$table_descr = array(
	'id'	=>	"IDENTITY",
	'menu_id'	=>	"INT NOT_NULL DEFAULT 0",
	'parent_id'	=>	"INT NULL",
	'order_index'	=>	"INT NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'url'	=>	"VARCHAR(1024) NULL",
	'visible'	=>	"BOOL NULL",
	'page_id'	=>	"INT NULL",
	'type'	=>	"INT NULL",
	'new_window'	=>	"INT NOT_NULL DEFAULT 0",
	'perm_id'	=>	"INT NOT_NULL DEFAULT 0",
	'description'	=>	"VARCHAR(512) NULL",
	'css_class'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('publish_menunode', $table_descr, true);
$db->CreateIndex('publish_menunode', 'publish_menunode_mid_pid_vis', 'menu_id', 'parent_id');



// publish_notifications
$table_descr = array(
	'user_id'	=>	"INT NULL",
	'page_id'	=>	"INT NULL",
	'once'	=>	"INT NULL",
);

$db->CreateTable('publish_notifications', $table_descr, true);



// quotas
$table_descr = array(
	'id'	=>	"IDENTITY",
	'use_default'	=>	"INT NULL",
	'quota_type'	=>	"INT NULL",
	'userid'	=>	"INT NULL",
	'softlimit'	=>	"INT NOT_NULL DEFAULT -1",
	'hardlimit'	=>	"INT NOT_NULL DEFAULT -1",
	'grace'	=>	"INT NULL DEFAULT -1",
	'overquota'	=>	"INT NULL",
	'last_warning'	=>	"INT NULL",
);

$db->CreateTable('quotas', $table_descr, true);



// ranks
$table_descr = array(
	'id'	=>	"IDENTITY",
	'value'	=>	"INT NULL",
	'name'	=>	"VARCHAR(128) NULL",
);

$db->CreateTable('ranks', $table_descr, true);



// rb_confirm
$table_descr = array(
	'book_id'	=>	"INT NULL",
	'user_id'	=>	"INT NULL",
	'type'	=>	"INT NULL",
	'obj_id'	=>	"INT NULL",
	'stat'	=>	"INT NULL",
);

$db->CreateTable('rb_confirm', $table_descr, true);



// rb_events
$table_descr = array(
	'id'	=>	"IDENTITY",
	'pid'	=>	"INT NOT_NULL DEFAULT -1",
	'name'	=>	"VARCHAR_MAX NULL",
	'descr'	=>	"VARCHAR_MAX NULL",
	'tmp_start'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'tmp_end'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'stat'	=>	"BOOL NOT_NULL DEFAULT 0",
	'event_link'	=>	"INT NOT_NULL DEFAULT -1",
	'full_event'	=>	"VARCHAR(200) NULL",
	'room_id'	=>	"INT NOT_NULL DEFAULT 0",
	'full_day'	=>	"INT NULL DEFAULT 0",
	'type'	=>	"VARCHAR(25) NOT_NULL DEFAULT 'room'",
	'is_edited'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('rb_events', $table_descr, true);
$db->CreateIndex('rb_events', 'rb_events_pid', 'pid', 'tmp_start', 'tmp_end');



// rb_links
$table_descr = array(
	'obj_id'	=>	"INT NOT_NULL DEFAULT 0",
	'type'	=>	"VARCHAR(10) NULL",
	'val'	=>	"INT NOT_NULL DEFAULT -1",
	'booking'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('rb_links', $table_descr, true);
$db->CreateIndex('rb_links', 'rb_links_obj_id', 'obj_id', 'type');



// rb_obj
$table_descr = array(
	'id'	=>	"IDENTITY",
	'pid'	=>	"INT NOT_NULL DEFAULT -1",
	'name'	=>	"VARCHAR(100) NULL DEFAULT 'empty name'",
	'type'	=>	"VARCHAR(10) NULL DEFAULT 'room10'",
	'count'	=>	"INT NOT_NULL DEFAULT 0",
	'description'	=>	"VARCHAR_MAX NULL",
	'facilities'	=>	"VARCHAR_MAX NULL",
	'note'	=>	"VARCHAR_MAX NULL",
	'is_approval'	=>	"BOOL NOT_NULL DEFAULT 0",
	'is_portable'	=>	"BOOL NOT_NULL DEFAULT 0",
	'is_suspended'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('rb_obj', $table_descr, true);
$db->CreateIndex('rb_obj', 'rb_obj_pid', 'pid', 'type');



// roles
$table_descr = array(
	'roleid'	=>	"IDENTITY",
	'rolename'	=>	"VARCHAR(255) NULL",
	'default_skin'	=>	"INT NOT_NULL DEFAULT 0",
	'inactive'	=>	"BOOL NOT_NULL DEFAULT 0",
	'owner'	=>	"INT NOT_NULL DEFAULT 0",
	'description'	=>	"VARCHAR_MAX NULL",
	'date_created'	=>	"INT_DATE NULL",
	'ex_area_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('roles', $table_descr, true);



// rooms
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'responsible'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('rooms', $table_descr, true);



// search_query_params
$table_descr = array(
	'last_used'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'params'	=>	"CLOB NULL",
	'hash'	=>	"VARCHAR(64) NULL",
	'searchtime'	=>	"FLOAT NULL",
);

$db->CreateTable('search_query_params', $table_descr, true);
$db->CreateIndex('search_query_params', 'search_query_params_last_used', 'last_used');



// search_query_params_cache
$table_descr = array(
	'search_id'	=>	"INT NOT_NULL DEFAULT 0",
	'last_used'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'params'	=>	"CLOB NULL",
	'hash'	=>	"VARCHAR(32) NULL",
	'searchtime'	=>	"FLOAT NULL",
);

$db->CreateTable('search_query_params_cache', $table_descr, true);
$db->CreatePrimaryKey('search_query_params_cache', 'search_id');



// search_suggestions_best_bet
$table_descr = array(
	'id'	=>	"IDENTITY",
	'group_id'	=>	"INT NOT_NULL",
	'context'	=>	"VARCHAR(100) NULL",
	'application'	=>	"VARCHAR(100) NULL",
	'name'	=>	"VARCHAR(500) NULL",
	'description'	=>	"VARCHAR(1000) NULL",
	'url'	=>	"VARCHAR(500) NULL",
	'position'	=>	"INT NULL",
	'created'	=>	"INT_DATE NULL",
	'updated'	=>	"INT_DATE NULL",
);

$db->CreateTable('search_suggestions_best_bet', $table_descr, true);



// search_suggestions_group
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(100) NULL",
	'created'	=>	"INT_DATE NULL",
	'updated'	=>	"INT_DATE NULL",
);

$db->CreateTable('search_suggestions_group', $table_descr, true);



// search_suggestions_request
$table_descr = array(
	'id'	=>	"IDENTITY",
	'term'	=>	"VARCHAR(500) NULL",
	'description'	=>	"VARCHAR(500) NULL",
	'creator'	=>	"INT NULL",
	'created'	=>	"INT_DATE NULL",
	'updated'	=>	"INT_DATE NULL",
);

$db->CreateTable('search_suggestions_request', $table_descr, true);



// search_suggestions_suggestion
$table_descr = array(
	'id'	=>	"IDENTITY",
	'group_id'	=>	"INT NOT_NULL",
	'value'	=>	"VARCHAR(500) NULL",
	'created'	=>	"INT_DATE NULL",
	'updated'	=>	"INT_DATE NULL",
);

$db->CreateTable('search_suggestions_suggestion', $table_descr, true);



// search_suggestions_term
$table_descr = array(
	'id'	=>	"IDENTITY",
	'group_id'	=>	"INT NOT_NULL",
	'value'	=>	"VARCHAR(500) NULL",
	'created'	=>	"INT_DATE NULL",
	'updated'	=>	"INT_DATE NULL",
);

$db->CreateTable('search_suggestions_term', $table_descr, true);



// searchquery_objects
$table_descr = array(
	'id'	=>	"IDENTITY",
	'dummy'	=>	"INT NULL",
);

$db->CreateTable('searchquery_objects', $table_descr, true);



// simple_acl
$table_descr = array(
	'object_code'	=>	"VARCHAR(100) NULL",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'rights'	=>	"INT NOT_NULL DEFAULT 1",
);

$db->CreateTable('simple_acl', $table_descr, true);
$db->CreateIndex('simple_acl', 'simple_acl_object_code', 'object_code');
$db->CreateIndex('simple_acl', 'simple_acl_user_object', 'user_id', 'object_code');



// skillsdesc
$table_descr = array(
	'skillid'	=>	"IDENTITY",
	'skill'	=>	"VARCHAR(50) NULL",
);

$db->CreateTable('skillsdesc', $table_descr, true);



// skin_permissions
$table_descr = array(
	'id'	=>	"IDENTITY",
	'obj_type'	=>	"VARCHAR(10) NULL",
	'obj_id'	=>	"INT NOT_NULL DEFAULT 0",
	'skin_id'	=>	"INT NOT_NULL DEFAULT 0",
	'available'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('skin_permissions', $table_descr, true);
$db->CreateIndex('skin_permissions', 'skin_permissions_sid_otype_oid', 'skin_id', 'obj_type', 'obj_id');



// skins
$table_descr = array(
	'skin_id'	=>	"IDENTITY",
	'skin_name'	=>	"VARCHAR(25) NULL",
);

$db->CreateTable('skins', $table_descr, true);



// stat_updates
$table_descr = array(
	'date_time'	=>	"INT_DATE NOT_NULL",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'object_id'	=>	"INT NOT_NULL DEFAULT 0",
	'aggregation'	=>	"INT NOT_NULL",
	'description'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('stat_updates', $table_descr, true);
$db->CreateIndex('stat_updates', 'idx_aggregation_date_time', 'aggregation', 'date_time');



// stat_views
$table_descr = array(
	'date_time'	=>	"INT_DATE NOT_NULL",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'object_id'	=>	"INT NOT_NULL DEFAULT 0",
	'aggregation'	=>	"INT NOT_NULL",
	'description'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('stat_views', $table_descr, true);
$db->CreateIndex('stat_views', 'stat_views_id_aggregation', 'object_id', 'aggregation');
$db->CreateIndex('stat_views', 'stat_views_date_time', 'date_time');
$db->CreateIndex('stat_views', 'stat_views_id_aggregation_date_time', 'object_id', 'aggregation', 'date_time');
$db->CreateIndex('stat_views', 'stat_views_id_aggregation_date_time_user_id', 'object_id', 'aggregation', 'date_time', 'user_id');
$db->CreateIndex('stat_views', 'idx_aggregation_date_time', 'aggregation', 'date_time');



// stat_visits
$table_descr = array(
	'date_time_start'	=>	"INT_DATE NOT_NULL",
	'duration'	=>	"INT NOT_NULL DEFAULT 0",
	'pages_visited'	=>	"INT NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'session_key'	=>	"VARCHAR(100) NULL",
	'day_group'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('stat_visits', $table_descr, true);
$db->CreateIndex('stat_visits', 'idx_session_key_date_time_start', 'session_key', 'date_time_start');
$db->CreateIndex('stat_visits', 'idx_date_time_start', 'date_time_start');
$db->CreateIndex('stat_visits', 'idx_date_time_start_session', 'date_time_start', 'session_key');
$db->CreateIndex('stat_visits', 'idx_day_group', 'day_group');



// stat_visits_raw
$table_descr = array(
	'date_time'	=>	"INT_DATE NOT_NULL",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'session_key'	=>	"VARCHAR(100) NULL",
);

$db->CreateTable('stat_visits_raw', $table_descr, true);



// stat_visits_sum
$table_descr = array(
	'date_time'	=>	"INT_DATE NOT_NULL",
	'v_year'	=>	"INT NOT_NULL",
	'v_month'	=>	"INT NOT_NULL",
	'v_day'	=>	"INT NOT_NULL",
	'v_hour'	=>	"INT NOT_NULL",
	'v_dow'	=>	"INT NOT_NULL",
	'pages_visited'	=>	"INT NOT_NULL",
	'user_id'	=>	"INT NOT_NULL",
);

$db->CreateTable('stat_visits_sum', $table_descr, true);
$db->CreateIndex('stat_visits_sum', 'idx_date_time_user_id', 'date_time', 'user_id');
$db->CreateIndex('stat_visits_sum', 'idx_date_time_pages_visited', 'date_time', 'pages_visited');



// survey_votes
$table_descr = array(
	'question_id'	=>	"INT NOT_NULL DEFAULT 0",
	'option_id'	=>	"INT NOT_NULL DEFAULT 0",
	'voter_id'	=>	"INT NOT_NULL DEFAULT 0",
	'id'	=>	"IDENTITY",
);

$db->CreateTable('survey_votes', $table_descr, true);



// tags
$table_descr = array(
	'aggregation'	=>	"INT NOT_NULL DEFAULT 0",
	'object_id'	=>	"INT NOT_NULL DEFAULT 0",
	'tag'	=>	"VARCHAR(100) NULL",
);

$db->CreateTable('tags', $table_descr, true);
$db->CreateIndex('tags', 'tags_tag_index', 'tag');
$db->CreateIndex('tags', 'tags_aggr_obj_index', 'aggregation', 'object_id');



// tags_translation
$table_descr = array(
	'tag'	=>	"VARCHAR(100) NULL",
	'language'	=>	"VARCHAR(10) NULL",
	'title'	=>	"VARCHAR(100) NULL",
);

$db->CreateTable('tags_translation', $table_descr, true);
$db->CreateIndex('tags_translation', 'tags_transl_tag', 'tag', 'language');
$db->CreateIndex('tags_translation', 'tags_transl_title', 'title');



// talents
$table_descr = array(
	'talentid'	=>	"IDENTITY",
	'userid'	=>	"INT NOT_NULL DEFAULT 0",
	'skillid'	=>	"INT NOT_NULL DEFAULT 0",
	'mytalent'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('talents', $table_descr, true);
$db->CreateIndex('talents', 'talents_uid', 'userid');



// telemetry_payloads
$table_descr = array(
	'id'	=>	"IDENTITY",
	'created'	=>	"INT_DATE NULL",
	'payload'	=>	"CLOB NULL",
	'is_sent'	=>	"BOOL NULL",
);

$db->CreateTable('telemetry_payloads', $table_descr, true);



// theme
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'priority'	=>	"INT NOT_NULL",
	'base_vi'	=>	"VARCHAR(128) NULL",
	'style'	=>	"CLOB NULL",
	'code'	=>	"VARCHAR(128) NULL",
	'pages_url_id'	=>	"INT NULL",
);

$db->CreateTable('theme', $table_descr, true);



// theme_style
$table_descr = array(
	'id'	=>	"IDENTITY",
	'style'	=>	"CLOB NULL",
);

$db->CreateTable('theme_style', $table_descr, true);



// timezone
$table_descr = array(
	'id'	=>	"IDENTITY",
	'display_name'	=>	"VARCHAR(100) NULL",
	'value'	=>	"VARCHAR(100) NULL",
	'offset_sign'	=>	"VARCHAR(1) NULL",
	'offset_hour'	=>	"INT NOT_NULL DEFAULT 0",
	'offset_min'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('timezone', $table_descr, true);



// timezones_locations
$table_descr = array(
	'id'	=>	"IDENTITY",
	'location'	=>	"VARCHAR(255) NULL",
	'timezone'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('timezones_locations', $table_descr, true);



// trash_can
$table_descr = array(
	'id'	=>	"IDENTITY",
	'obj_id'	=>	"INT NULL",
	'aggregation'	=>	"INT NOT_NULL",
	'user_id'	=>	"INT NOT_NULL",
	'deletion_date'	=>	"INT NOT_NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'orig_location'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('trash_can', $table_descr, true);
$db->CreateIndex('trash_can', 'idx_aggregation_obj_id', 'aggregation', 'obj_id');
$db->CreateIndex('trash_can', 'idx_deletion_date', 'deletion_date');



// user_groups
$table_descr = array(
	'groupid'	=>	"INT NOT_NULL DEFAULT 0",
	'userid'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('user_groups', $table_descr, true);
$db->CreatePrimaryKey('user_groups', 'groupid', 'userid');
$db->CreateIndex('user_groups', 'user_groups_userid', 'userid');



// user_roles
$table_descr = array(
	'roleid'	=>	"INT NOT_NULL DEFAULT 0",
	'userid'	=>	"INT NOT_NULL DEFAULT 0",
	'primary_role'	=>	"VARCHAR(1) NULL DEFAULT 'Y'",
);

$db->CreateTable('user_roles', $table_descr, true);
$db->CreatePrimaryKey('user_roles', 'roleid', 'userid');
$db->CreateIndex('user_roles', 'user_roles_userid', 'userid');



// user_timestamps
$table_descr = array(
	'user_id'	=>	"INT NOT_NULL",
	'group_time'	=>	"INT_DATE NULL",
	'grouptree_time'	=>	"INT_DATE NULL",
	'role_time'	=>	"INT_DATE NULL",
);

$db->CreateTable('user_timestamps', $table_descr, true);
$db->CreatePrimaryKey('user_timestamps', 'user_id');



// users
$table_descr = array(
	'id'	=>	"IDENTITY",
	'intranetuser'	=>	"VARCHAR(3) NULL DEFAULT 'no'",
	'username'	=>	"VARCHAR(100) NULL",
	'password'	=>	"VARCHAR(200) NULL",
	'a1_hash'	=>	"VARCHAR(255) NULL",
	'firstname'	=>	"VARCHAR(200) NULL",
	'surname'	=>	"VARCHAR(200) NULL",
	'company'	=>	"VARCHAR(200) NULL",
	'emailad'	=>	"VARCHAR(200) NULL",
	'ex_area_id'	=>	"INT NULL DEFAULT 0",
	'job_title'	=>	"VARCHAR(200) NULL",
	'last_time_login'	=>	"INT NULL",
	'last_time_used'	=>	"INT NULL",
	'user_code'	=>	"VARCHAR(200) NULL",
	'notify_on_checkin'	=>	"BOOL NULL DEFAULT 0",
	'notification_method'	=>	"INT NULL DEFAULT 2",
	'language'	=>	"VARCHAR(3) NULL DEFAULT 'en'",
	'easy_find_num'	=>	"INT NULL DEFAULT 10",
	'skin'	=>	"VARCHAR(30) NULL DEFAULT 'default'",
	'default_skin'	=>	"INT NOT_NULL DEFAULT 0",
	'password_policy'	=>	"VARCHAR(20) NULL DEFAULT '0_0_30_5'",
	'pp_change_next_time'	=>	"BOOL NOT_NULL DEFAULT 0",
	'pp_default'	=>	"BOOL NOT_NULL DEFAULT 1",
	'password_last_change'	=>	"INT NOT_NULL DEFAULT 0",
	'ldap_guid'	=>	"VARCHAR(255) NULL",
	'login_frozen_time'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'login_attempts'	=>	"INT NOT_NULL DEFAULT 0",
	'login_frozen_until'	=>	"INT NOT_NULL DEFAULT 0",
	'whats_new_list'	=>	"VARCHAR(1000) NULL DEFAULT NULL",
	'ext_type'	=>	"VARCHAR(20) NULL",
	'ext_id'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('users', $table_descr, true);
$db->CreateIndex('users', 'users_state', 'intranetuser');
$db->CreateIndex('users', 'users_username', 'username');
$db->CreateIndex('users', 'users_extranet_index', 'ex_area_id');
$db->CreateIndex('users', 'users_online', 'intranetuser', 'last_time_used');



// users_fields
$table_descr = array(
	'id'	=>	"IDENTITY",
	'field_name'	=>	"VARCHAR(255) NULL",
	'is_metadata'	=>	"BOOL NOT_NULL DEFAULT 0",
	'view_profile_order'	=>	"INT NULL DEFAULT -1",
	'my_profile_order'	=>	"INT NULL DEFAULT -1",
	'my_profile_editable'	=>	"BOOL NULL DEFAULT 0",
	'admin_profile_order'	=>	"INT NULL DEFAULT -1",
	'admin_profile_editable'	=>	"BOOL NULL DEFAULT 0",
	'users_list_order'	=>	"INT NULL DEFAULT -1",
	'admin_list_order'	=>	"INT NULL DEFAULT -1",
	'advanced_search_order'	=>	"INT NULL DEFAULT -1",
	'show_padlock'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('users_fields', $table_descr, true);
$db->CreateIndex('users_fields', 'users_fields_list_order', 'users_list_order');
$db->CreateIndex('users_fields', 'users_fields_search_order', 'advanced_search_order');



// users_fields_perms
$table_descr = array(
	'id'	=>	"IDENTITY",
	'field_name'	=>	"VARCHAR(255) NULL",
	'is_metadata'	=>	"BOOL NOT_NULL DEFAULT 0",
	'is_edit_perm'	=>	"BOOL NOT_NULL DEFAULT 0",
	'perm_who'	=>	"BOOL NOT_NULL DEFAULT 0",
	'perm_target'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('users_fields_perms', $table_descr, true);



// variables
$table_descr = array(
	'var_name'	=>	"VARCHAR(100) NOT_NULL DEFAULT ' '",
	'var_value'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('variables', $table_descr, true);
$db->CreatePrimaryKey('variables', 'var_name');



// wf_action_records
$table_descr = array(
	'id'	=>	"IDENTITY",
	'state_record_id'	=>	"INT NOT_NULL",
	'doc_id'	=>	"INT NOT_NULL",
	'sender_id'	=>	"INT NOT_NULL",
	'event_type'	=>	"INT NOT_NULL",
	'event_data'	=>	"CLOB NULL",
	'event_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL",
	'commentary'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('wf_action_records', $table_descr, true);



// wf_actions
$table_descr = array(
	'id'	=>	"IDENTITY",
	'wf_id'	=>	"INT NOT_NULL",
	'state_id'	=>	"INT NOT_NULL",
	'action_type'	=>	"INT NOT_NULL",
	'action_data'	=>	"CLOB NULL",
);

$db->CreateTable('wf_actions', $table_descr, true);



// wf_category
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'perm_id'	=>	"INT NULL",
);

$db->CreateTable('wf_category', $table_descr, true);



// wf_stat
$table_descr = array(
	'wf_id'	=>	"INT NOT_NULL DEFAULT 0",
	'doc_id'	=>	"INT NOT_NULL DEFAULT 0",
	'actor'	=>	"INT NOT_NULL DEFAULT 0",
	'wf_stat_from'	=>	"INT NOT_NULL DEFAULT 0",
	'wf_stat_to'	=>	"INT NOT_NULL DEFAULT 0",
	'stat_date'	=>	"INT_DATE NULL",
	'commentary'	=>	"VARCHAR(255) NULL",
	'stat'	=>	"INT NOT_NULL DEFAULT 0",
	'id'	=>	"IDENTITY",
	'transition_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('wf_stat', $table_descr, true);



// wf_states
$table_descr = array(
	'id'	=>	"IDENTITY",
	'wf_id'	=>	"INT NOT_NULL DEFAULT 0",
	'name'	=>	"VARCHAR(255) NULL",
	'st_mode'	=>	"INT NOT_NULL DEFAULT 0",
	'location'	=>	"INT NOT_NULL DEFAULT 0",
	'readonly'	=>	"INT NOT_NULL DEFAULT 0",
	'resp_notify'	=>	"INT NULL",
	'position'	=>	"INT NOT_NULL DEFAULT 0",
	'color'	=>	"VARCHAR(7) NULL",
	'description'	=>	"VARCHAR(244) NULL",
	'owner_notify'	=>	"INT NULL",
);

$db->CreateTable('wf_states', $table_descr, true);



// wf_transition_confirm
$table_descr = array(
	'object_id'	=>	"INT NOT_NULL DEFAULT 0",
	'object_type'	=>	"INT NOT_NULL DEFAULT 0",
	'tr_id'	=>	"INT NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'confirmed'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('wf_transition_confirm', $table_descr, true);



// wf_transition_records
$table_descr = array(
	'id'	=>	"IDENTITY",
	'state_record_id'	=>	"INT NOT_NULL",
	'doc_id'	=>	"INT NOT_NULL",
	'sender_id'	=>	"INT NOT_NULL",
	'event_type'	=>	"INT NOT_NULL",
	'event_data'	=>	"CLOB NULL",
	'event_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL",
	'commentary'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('wf_transition_records', $table_descr, true);



// wf_transitions
$table_descr = array(
	'id'	=>	"IDENTITY",
	'wf_id'	=>	"INT NOT_NULL DEFAULT 0",
	'from_status'	=>	"INT NOT_NULL DEFAULT 0",
	'to_status'	=>	"INT NOT_NULL DEFAULT 0",
	'cond_type'	=>	"INT NOT_NULL DEFAULT 0",
	'cond_data1'	=>	"INT NOT_NULL DEFAULT 0",
	'cond_data2'	=>	"INT NOT_NULL DEFAULT 0",
	'confirm_all'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('wf_transitions', $table_descr, true);
$db->CreateIndex('wf_transitions', 'wf_transitions_wf_id', 'wf_id');



// wf_workflows
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(255) NULL",
	'first_state'	=>	"INT NOT_NULL DEFAULT 0",
	'category'	=>	"INT NOT_NULL DEFAULT 0",
	'owner'	=>	"INT NOT_NULL DEFAULT 0",
	'description'	=>	"VARCHAR(244) NULL",
	'descrition'	=>	"VARCHAR_MAX NULL",
	'perm_id'	=>	"INT NULL",
);

$db->CreateTable('wf_workflows', $table_descr, true);





//===========================================================================================
$migrations->SetVersion('41.08');
