/**
 * Base class
 */
var TabsViewBase = Backbone.View.extend({
	setVisible : function(visible) {
		if(visible)
			this.render();
		else
			this.hide();
	},
	hide : function() {
		this.$el.hide();
	},
	render : function() {
		this.$el.show();
	}
});
/**
 * View for Document Details > Preview
 */
var TabOverviewView = TabsViewBase.extend({
	el : '#overview_tab',
	events : {
		'click #btnBookmarkToggle' : 'bookmarkToggle'
	},
	bookmarkToggle : function(el) {
		el.preventDefault();
	}
});

/**
 * View for Document Details > Properties
 */
var TabMetaView = TabsViewBase.extend({
	el : '#meta_tab'
});

/**
 * View for Document Details > Properties
 */
var TabCommentView = TabsViewBase.extend({
	el : '#comment_tab',
	initialize : function() {
		_.bindAll(this, 'render');
	},
	render : function() {
		this.$el.show();
	}
});
