define([
    'jquery',
    'underscore'
], function ($, _) {
    var AiICSummary = function () {
        var self = this;

        this.$ai_infocapture_trigger = null;
        this.$ai_infocapture = null;
        this.$loader = null;
        this.$content = null;

        this.object_id = null;
        this.project_id = null;

        this.loading = false;

        this.initialize = function (config) {
            self.$ai_infocapture_trigger = $('.js-infocapture-summary-trigger')
            self.$ai_infocapture = $('#ai-infocapture-summary');
            self.$loader = self.$ai_infocapture.find('.js-ai-skeleton');
            self.$content = self.$ai_infocapture.find('.js-ai-content');

            self.object_id = config.object_id;
            self.project_id = config.project_id;

            self.setup();
            self.events();
        };

        this.events = function () {
            self.$ai_infocapture_trigger.on('click', function() {
                if (self.loading) {
                    return;
                }

                self.$ai_infocapture.removeClass('d-none');

                var target_height = self.$ai_infocapture.css('height', 'auto').height();

                self.$ai_infocapture.height(0);

                self.$ai_infocapture.animate({
                    height: target_height
                }, 600, function() {
                    $(this).css("height", "auto"); 
                });

                self.submit();
            });
        };

        this.submit = function () {
            self.showLoading(true);

            $.post('/api/ai/generate-text', {
                module: 'infocapture',
                metadata: {
                    object_id: self.object_id,
                    project_id: self.project_id
                }
            })
                .done(function (response) {
                    var data = response.text;

                    self.drawOverview(data)
                })
                .fail(function (xhr, status, error) {
                    // Draw an empty overview - the method handles empty overviews
                    self.drawOverview('')
                })
                .always(function () {
                    self.showLoading(false);
                });
        };

        this.setup = function () {
            var $infocapture_tabs = $('.js-infocapture-tabs');

            if (!$infocapture_tabs.length) {
                return;
            }

            $infocapture_tabs.prepend(self.$ai_infocapture.detach());
        }

        this.showLoading = function (loading) {
            this.loading = loading;

            if (loading) {
                self.$content.addClass('d-none');
                self.$loader.remove('d-none');
            } else {
                self.$content.removeClass('d-none');
                self.$loader.addClass('d-none');
            }
        };

        this.drawOverview = function (overview) {
            if ($.trim(overview) == "") {
                self.$ai_infocapture.hide();
                return;
            }

            // Code below creates a smooth transition of the height instead of snapping
            // to the new content size

            var currentHeight = self.$ai_infocapture.outerHeight();
            
            self.$content.css('opacity', 0).html(overview);

            self.showLoading(false);

            self.$ai_infocapture.css('height', 'auto');
            var targetHeight = self.$ai_infocapture.outerHeight();
            
            self.$ai_infocapture.height(currentHeight);

            self.$ai_infocapture.stop().animate({
                height: targetHeight
            }, 600, function() {
                $(this).css('height', 'auto'); 
            });

            self.$content.animate({ opacity: 1 }, 400);

            self.$ai_infocapture_trigger.prop('disabled', true);
        };
    };

    return new AiICSummary();
});
