<?php
namespace Claromentis\Core\Ai\Adapters\Vertex;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"] = (@$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"] ?: array()) + array("_b673c9549489ba1916c266f60dc" . "846a8" => base64_decode("cHJlZGlj" . "dA=="), "_63a6ec2f20440285232bed" . "955be33266" => base64_decode("c3RyZWFtR2VuZXJhdGVDb25" . "0ZW50"), "_6ee75f9f44b14f240fc54f3e19e7" . "084a" => base64_decode("UmVjZWl2ZWQgYW4gdW5le" . "HBlY3RlZCBlcnJvciBmcm" . "9tIHRoZSBzZXJ2ZXI="), "_86e718deafc5b7c86aa6" . "3799a9e024d0" => base64_decode("aHR0cHM6L" . "y8="), "_7215c11" . "8ad86983" . "602db0b4" . "31cb9a1e" . "9" => base64_decode("Z2VuZXJhd" . "GVDb250ZW" . "50"), "_3e258c4e6163007d8094c3964760" . "2e7a" => base64_decode("aGV" . "hZG" . "Vyc" . "w=="), "_29225c3f2cb4b5bb" . "8cdfecad11c6f491" => base64_decode("Og" . "=="), "_e2cad529b5b2b6610323420" . "10c496554" => base64_decode("L2xvY2F0aW9ucy8" . "="), "_043583fc6e" . "4063be6ec4a" . "31bf951616c" => base64_decode("L3Byb2plY3R" . "zLw=="), "_7681c2a2b7e1bdf69c23" . "c6cd64114ad3" => base64_decode("anNvb" . "l9kZW" . "NvZGU" . "="), "_67a3498b1e8fe53ddf3" . "9e400a59bc91f" => base64_decode("cmVnaW9uX25hb" . "WU="), "_f24852a7b2e8c18" . "0d1f7ab216c8e822" . "2" => base64_decode("QmV" . "hcm" . "VyI" . "A=="), "_7c819f403b31525f384" . "e33c0142be9f4" => base64_decode("L3B1Ymxpc2hlcnMvZ29vZ2xlL21vZGVsc" . "y8="), "_0cb031e3cd6ff0075d3bccfcfd" . "b999a6" => base64_decode("LCBj" . "b250" . "ZW50" . "OiA="), "_db618ca8e79f97b4dff753ec837942c" . "f" => base64_decode("cHJvamVjdF9p" . "ZA=="), "_bef1236f88db6b34bcb8" . "78fe48142cb6" => base64_decode("aHR0cF9lcnJv" . "cnM="), "_1cc5aa2f679b575f82786" . "a73f0da28f8" => base64_decode("c3RyZ" . "WFt"), "_8ec8f26c742278f90615f50d682" . "eea79" => base64_decode("UE9" . "TVA" . "=="), "_e9181de682eebf636bae05126" . "95b2a95" => base64_decode("QXV0aG9yaXphdGlvb" . "g=="), "_47ee521cf79c60b9" . "7cda9ecd9c595c95" => base64_decode("U2VydmVyIHJldHVybmVkIGFuIHVuZXhwZWN0ZWQgc" . "mVzcG9uc2UuIEhUVFAgY29kZTog"), "_38021ae3" . "8952751ba" . "ca9f63ac2" . "bf723b" => base64_decode("LWFpcGxhdGZvcm0uZ29vZ2xlYXBpc" . "y5jb20vdjE="));
use Claromentis\Core\Ai\Adapters\Vertex\Requests\Image\VertexAiImageRequest;
use Claromentis\Core\Ai\Adapters\Vertex\Requests\Text\VertexAiTextRequest;
use Claromentis\Core\Ai\Adapters\Vertex\Requests\VertexAiClientAuthentication;
use Claromentis\Core\Ai\Adapters\Vertex\Responses\Image\VertexAiGenerateImageResponse;
use Claromentis\Core\Ai\Adapters\Vertex\Responses\Text\VertexAiGenerateTextResponse;
use Claromentis\Core\Ai\Exceptions\AiException;
use Claromentis\Core\Ai\Exceptions\AiInvalidRequestException;
use Claromentis\Core\Ai\Exceptions\AiServerResponseException;
use Claromentis\Core\Ai\Exceptions\VertexAiPromptException;
use Claromentis\Core\Ai\JsonParser;
use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Stream\StreamInterface;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;
use Symfony\Component\HttpFoundation\Response;






class VertexAiClient implements LoggerAwareInterface
{
    use LoggerAwareTrait;
    
    
    
    
    
    
    
    
    
    public const ERROR_INVALID_ARGUMENT = Response::HTTP_BAD_REQUEST;
    public const ERROR_UNAUTHENTICATED = Response::HTTP_UNAUTHORIZED;
    public const ERROR_PERMISSION_DENIED = Response::HTTP_FORBIDDEN;
    public const ERROR_NOT_FOUND = Response::HTTP_NOT_FOUND;
    public const ERROR_RESOURCE_EXHAUSTED = Response::HTTP_TOO_MANY_REQUESTS;
    public const ERROR_CANCELLED = 499;
    
    
    public const ERROR_INTERNAL_ERROR = Response::HTTP_INTERNAL_SERVER_ERROR;
    public const ERROR_UNAVAILABLE = Response::HTTP_SERVICE_UNAVAILABLE;
    public const ERROR_DEADLINE_EXCEEDED = Response::HTTP_GATEWAY_TIMEOUT;
    
    
    
    
    private string $projectId;
    
    
    
    
    private string $regionName;
    
    
    
    
    private string $modelName;
    
    
    
    
    private VertexAiClientAuthentication $authentication;
    
    
    
    
    private ClientInterface $client;
    
    
    
    
    
    
    
    
    
    public function __construct(VertexAiClientAuthentication $_961ccc1b377e30c70011809b405b9c07, array $config, LoggerInterface $logger = null, ClientInterface $_2f664bcc4a0a32ffda2885fb12940265 = null)
    {
        $this->projectId = $config[$GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_db618ca8e79f97b4dff753ec8379" . "42cf"]];
        $this->regionName = $config[$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_67a3498b1e" . "8fe53ddf39e" . "400a59bc91f"]];
        $this->authentication = $_961ccc1b377e30c70011809b405b9c07;
        $this->logger = $logger ?? new NullLogger();
        $this->client = $_2f664bcc4a0a32ffda2885fb12940265 ?? new Client();
    }
    
    
    
    
    
    
    
    
    
    
    public function handleGenerateTextRequest(VertexAiTextRequest $request, callable $_5c51b0e4b7267b43adabf8015a8e1cf8 = null)
    {
        
        
        $this->modelName = $request->getModelName();
        $_f4bd77b9d7574792bd46db73586ce19d = $request->serialize();
        if ($request->isStreaming()) {
            $this->generateTextStream($_f4bd77b9d7574792bd46db73586ce19d, $_5c51b0e4b7267b43adabf8015a8e1cf8);
            return;
        }
        return $this->generateText($_f4bd77b9d7574792bd46db73586ce19d);
    }
    
    
    
    
    
    
    
    
    
    public function handleGenerateImageRequest(VertexAiImageRequest $request)
    {
        
        
        
        $this->modelName = $request->getModelName();
        $_f4bd77b9d7574792bd46db73586ce19d = $request->serialize();
        return $this->generateImages($_f4bd77b9d7574792bd46db73586ce19d);
    }
    
    
    
    
    
    
    
    private function generateText(array $data) : VertexAiGenerateTextResponse
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_7215c118ad86983602db0b431c" . "b9a1e9"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        return VertexAiGenerateTextResponse::fromArray($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_7681c2a2b7e1bdf69c23c6cd" . "64114ad3"]($this->send($_c927258f5322288a992c77be40ae0b53, $data), true), $this->modelName);
    }
    
    
    
    
    
    
    
    private function generateImages(array $data) : VertexAiGenerateImageResponse
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_b673c9549489ba1916c266f60dc846" . "a8"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        return VertexAiGenerateImageResponse::fromArray($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_7681c2a2b7e1bdf69c" . "23c6cd64114ad3"]($this->send($_c927258f5322288a992c77be40ae0b53, $data), true));
    }
    
    
    
    
    
    
    
    public function buildURL(string $_3bf6f785d3520dfd17a871d18d745880) : string
    {
        return $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_86e718deafc5b7c8" . "6aa63799a9e024d0"] . $this->regionName . $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_38021ae38952751baca9f63a" . "c2bf723b"] . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_043583fc6e4063" . "be6ec4a31bf9516" . "16c"] . $this->projectId . $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_e2cad529b5b2b6610323" . "42010c496554"] . $this->regionName . $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_7c819f403b31525f38" . "4e33c0142be9f4"] . $this->modelName . ($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_29225c3f2cb4b5bb8cdfecad11c6f" . "491"] . $_3bf6f785d3520dfd17a871d18d745880);
    }
    
    
    
    
    
    
    
    
    
    
    
    private function send(string $_c927258f5322288a992c77be40ae0b53, array $data, bool $_1cc5aa2f679b575f82786a73f0da28f8 = false)
    {
        $_fd5a3a643834299cbdadfc3540ba0bcb = $this->client->request($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_8ec8f26c74" . "2278f90615f" . "50d682eea79"], $_c927258f5322288a992c77be40ae0b53, [RequestOptions::JSON => $data, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_1cc5aa2f679b575f82786a73f0" . "da28f8"] => $_1cc5aa2f679b575f82786a73f0da28f8, $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_bef1236f88db6b34bcb878fe48142" . "cb6"] => false, $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_3e258c4e6163007d8094c" . "39647602e7a"] => [$GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_e9181de682eebf636bae0512695b2" . "a95"] => $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_f24852a" . "7b2e8c18" . "0d1f7ab2" . "16c8e822" . "2"] . $this->authentication->getAccessToken()]]);
        $this->checkResponse($_fd5a3a643834299cbdadfc3540ba0bcb);
        return $_fd5a3a643834299cbdadfc3540ba0bcb->getBody();
    }
    
    
    
    
    
    
    
    
    private function generateTextStream(array $data, callable $_5c51b0e4b7267b43adabf8015a8e1cf8) : void
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_63a6ec2f20440285232bed95" . "5be33266"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        $_1cc5aa2f679b575f82786a73f0da28f8 = $this->send($_c927258f5322288a992c77be40ae0b53, $data, true);
        $_c37f5d387ecde7a206c24852e173b2fe = new JsonParser(function (array $_fd62bc4eaaf7d58dea9bada3e30443b9) use($_5c51b0e4b7267b43adabf8015a8e1cf8) {
            $_5c51b0e4b7267b43adabf8015a8e1cf8(VertexAiGenerateTextResponse::fromArray($_fd62bc4eaaf7d58dea9bada3e30443b9, $this->modelName));
        });
        while (!$_1cc5aa2f679b575f82786a73f0da28f8->eof()) {
            $_c37f5d387ecde7a206c24852e173b2fe->consume($_1cc5aa2f679b575f82786a73f0da28f8->Read(1024));
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    private function checkResponse(\Psr\Http\Message\ResponseInterface $_fd5a3a643834299cbdadfc3540ba0bcb)
    {
        switch ($_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode()) {
            
            
            
            case self::ERROR_UNAUTHENTICATED:
            case self::ERROR_PERMISSION_DENIED:
                throw AiException::invalidCredentials();
            case self::ERROR_INVALID_ARGUMENT:
                throw new AiInvalidRequestException();
            case self::ERROR_NOT_FOUND:
            case self::ERROR_RESOURCE_EXHAUSTED:
            case self::ERROR_CANCELLED:
            case self::ERROR_DEADLINE_EXCEEDED:
            case self::ERROR_INTERNAL_ERROR:
            case self::ERROR_UNAVAILABLE:
                $this->logger->error($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_47ee521cf79c60b" . "97cda9ecd9c595c9" . "5"] . $_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode() . $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_0cb031e3cd6ff0075d3b" . "ccfcfdb999a6"] . $_fd5a3a643834299cbdadfc3540ba0bcb->getBody());
                throw new AiServerResponseException($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_6ee75f9f44b14f240fc54f3e19e7" . "084a"], $_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode());
        }
    }
}