<?php
namespace Claromentis\Core\Filesystem;

$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"] = (@$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"] ?: array()) + array("_f2646618c9d" . "cad156a41241" . "eacc4c3f7" => base64_decode("Z2V0X3Jlc291" . "cmNlX3R5cGU="), "_18c93a32ba5f" . "af9509389a947" . "87e6798" => base64_decode("bW9kaW" . "ZpZWQ="), "_01713acbc1c314b61bfbd8dc1" . "0a810bd" => base64_decode("RXJyb3Igd3JpdGluZyBmaW" . "xl"), "_32b8fa1ca3" . "30a0685321a" . "379e5b9687d" => base64_decode("YmFzZW5h" . "bWU="), "_1f7075c649da93591ca" . "e2f4eb31f83fe" => base64_decode("RXJyb3Igd3JpdGluZyBmaWxlIGZyb20g" . "c3RyZWFt"), "_e46a1b6a2fd927d616377ae" . "17620d766" => base64_decode("dmlzaWJpb" . "Gl0eQ=="), "pat" . "h" => base64_decode("cGF0aA=" . "="), "_6ae3783b9ad544a6c31a979683fed8" . "70" => base64_decode("ZmlsZ" . "Q=="), "_e134836f636940" . "9efa4f2cad26136" . "5c8" => base64_decode("RXJyb3IgdXB" . "kYXRpbmcgZm" . "lsZSBmcm9tI" . "HN0cmVhbQ=="), "_1cc5aa2" . "f679b575" . "f82786a7" . "3f0da28f" . "8" => base64_decode("c3" . "Ry" . "ZW" . "Ft"), "_6108a04b8350bfd2b7f" . "2b2365703eaec" => base64_decode("Zm9" . "wZW" . "4="), "_c4f3321d131869e51a" . "8844b6bcd8fb86" => base64_decode("ZG" . "ly"), "t" . "y" . "p" . "e" => base64_decode("dHlwZQ" . "=="), "_c91b0ff19f81a" . "8873a4593a2371" . "9472c" => base64_decode("cnRyaW" . "0="), "_9905761f4393d10" . "5cadfe7282a8c518" . "d" => base64_decode("bWltZXR5" . "cGU="), "_554a9169138240019acbd" . "1502642f16a" => base64_decode("ZGlyb" . "mFtZQ" . "=="), "_179055b98e140c4d4" . "18bcd5a903c7b7c" => base64_decode("RXJyb3IgdX" . "BkYXRpbmcg" . "ZmlsZQ=="), "_a606a2dcd236a549db05" . "74a9c1675927" => base64_decode("cg" . "=="), "_87daa84e346f6420a3f3426" . "e05d16a7b" => base64_decode("L" . "w" . "=" . "="), "_a67b2f1eec9b2bac901" . "12c5d6723ab41" => base64_decode("JHN0cmVhbSBtdXN0IGJlIGEgcm" . "Vzb3VyY2U="), "_563b15b92a77c86" . "9e85edf9569b4d02" . "5" => base64_decode("ZmNsb3N" . "l"), "_8aa39710a39f226efce78e97c" . "7bcd786" => base64_decode("XC" . "8="), "_5febae03aa5407c291b5c61a872cc" . "1fd" => base64_decode("aXNf" . "cmVz" . "b3Vy" . "Y2U="), "si" . "ze" => base64_decode("c2l" . "6ZQ" . "=="), "_9463ea5f1a4c73607" . "f2c69eeee2b6ede" => base64_decode("RXJyb3IgZGVsZX" . "RpbmcgZmlsZQ=="));
use BadMethodCallException;
use Claromentis\Core\Filesystem\Exception\FileExistsException;
use Claromentis\Core\Filesystem\Exception\FileNotFoundException;
use Claromentis\Core\Filesystem\Exception\FilesystemException;
use Exception;
use InvalidArgumentException;
use League\Flysystem;




class Filesystem implements FilesystemInterface
{
    
    
    
    
    
    
    protected Flysystem\FilesystemInterface $flysystem;
    
    
    
    
    
    
    protected string $charset;
    
    
    
    
    
    
    
    public function __construct(Flysystem\FilesystemInterface $_f623c94181cfb84b7b1ab3b650f57e44, string $_1ecc621b9902a7c9b8f2055fad2a3ead = 'UTF-8')
    {
        $this->flysystem = $_f623c94181cfb84b7b1ab3b650f57e44;
        $this->charset = $_1ecc621b9902a7c9b8f2055fad2a3ead;
    }
    
    
    
    
    public function Read(string $path) : string
    {
        try {
            return $this->flysystem->read($path);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetStream(string $path)
    {
        try {
            return $this->flysystem->readStream($path);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function WriteFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        $_1cc5aa2f679b575f82786a73f0da28f8 = $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_6108a04b8350b" . "fd2b7f2b236570" . "3eaec"]($_9211dd0bbcae0c7133030df599ff9ef5, $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_a606a2dcd2" . "36a549db057" . "4a9c1675927"]);
        try {
            $this->WriteFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } finally {
            $this->CloseStream($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
    
    
    
    
    public function WriteFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        if (!$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_5febae03aa5407c291b5c61a87" . "2cc1fd"]($_1cc5aa2f679b575f82786a73f0da28f8)) {
            throw new InvalidArgumentException($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_a67b2f1eec" . "9b2bac90112" . "c5d6723ab41"]);
        }
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->writeStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_1f7075c649da9" . "3591cae2f4eb31" . "f83fe"]);
        }
    }
    
    
    
    
    public function Write(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->write($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_01713acbc1c314b61bfbd8dc10" . "a810bd"]);
        }
    }
    
    
    
    
    public function UpdateFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        $_1cc5aa2f679b575f82786a73f0da28f8 = $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_6108a04b8" . "350bfd2b7f" . "2b2365703e" . "aec"]($_9211dd0bbcae0c7133030df599ff9ef5, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_a606a2dcd236a549db0574a9c1675" . "927"]);
        try {
            $this->UpdateFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } finally {
            $this->CloseStream($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
    
    
    
    
    public function UpdateFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        if (!$GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_5febae03aa5407c291" . "b5c61a872cc1fd"]($_1cc5aa2f679b575f82786a73f0da28f8)) {
            throw new InvalidArgumentException($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_a67b2f1eec9b2bac90112" . "c5d6723ab41"]);
        }
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->updateStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_e134836f6369409efa4f2" . "cad261365c8"]);
        }
    }
    
    
    
    
    public function Update(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->update($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_179055b98e140c4" . "d418bcd5a903c7b7" . "c"]);
        }
    }
    
    
    
    
    public function PutFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        try {
            if ($this->flysystem->has($path)) {
                $this->UpdateFromFile($path, $_9211dd0bbcae0c7133030df599ff9ef5, $config);
            } else {
                $this->WriteFromFile($path, $_9211dd0bbcae0c7133030df599ff9ef5, $config);
            }
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function PutFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        try {
            if ($this->flysystem->has($path)) {
                $this->UpdateFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
            } else {
                $this->WriteFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
            }
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    public function Put(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->put($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_01713acbc1c314b61bf" . "bd8dc10a810bd"]);
        }
    }
    
    
    
    
    public function Copy(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        try {
            $this->flysystem->copy($path, $_d074d7b344040d95fcad55b4694d9fec);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function Rename(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        if ($this->IsDir($path)) {
            $this->RenameDir($path, $_d074d7b344040d95fcad55b4694d9fec);
        } else {
            $this->RenameFile($path, $_d074d7b344040d95fcad55b4694d9fec);
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    public function RenameFile(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        try {
            $this->flysystem->rename($path, $_d074d7b344040d95fcad55b4694d9fec);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function RenameDir(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        $path = $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_c91b0ff19f81a8873a4593a23719472" . "c"]($path, $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_8aa39710a39f226efce78" . "e97c7bcd786"]);
        $_d074d7b344040d95fcad55b4694d9fec = $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_c91b0ff19f81a8873a4593a2371" . "9472c"]($_d074d7b344040d95fcad55b4694d9fec, $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_8aa39710a39f226efce78e97" . "c7bcd786"]);
        $_414bd78c344503f4d9a81c17a1e0b473 = $this->ListDirs($path);
        $_00f2055c7cbd408ef56949f35c62b721 = $this->ListFiles($path);
        foreach ($_414bd78c344503f4d9a81c17a1e0b473 as $_c4f3321d131869e51a8844b6bcd8fb86) {
            $this->RenameDir($path . $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_87daa84e346f6" . "420a3f3426e05d" . "16a7b"] . $_c4f3321d131869e51a8844b6bcd8fb86, $_d074d7b344040d95fcad55b4694d9fec . $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_87daa84e3" . "46f6420a3f" . "3426e05d16" . "a7b"] . $_c4f3321d131869e51a8844b6bcd8fb86);
        }
        foreach ($_00f2055c7cbd408ef56949f35c62b721 as $_6ae3783b9ad544a6c31a979683fed870) {
            $this->RenameFile($path . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_87daa84e346f6420a3f3426e05d" . "16a7b"] . $_6ae3783b9ad544a6c31a979683fed870, $_d074d7b344040d95fcad55b4694d9fec . $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_87daa84e346f6420a3f34" . "26e05d16a7b"] . $_6ae3783b9ad544a6c31a979683fed870);
        }
        
        
        $this->Delete($path);
    }
    
    
    
    
    public function Delete(string $path) : void
    {
        try {
            $_fd5a3a643834299cbdadfc3540ba0bcb = true;
            if ($this->IsDir($path)) {
                $_fd5a3a643834299cbdadfc3540ba0bcb = $this->flysystem->deleteDir($path);
            } else {
                $_fd5a3a643834299cbdadfc3540ba0bcb = $this->flysystem->delete($path);
            }
        } catch (Flysystem\FileNotFoundException|Flysystem\RootViolationException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            
            
            
        }
        if ($_fd5a3a643834299cbdadfc3540ba0bcb === false) {
            throw new FilesystemException($GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_9463ea5f1a4c736" . "07f2c69eeee2b6ed" . "e"]);
        }
    }
    
    
    
    
    
    
    
    
    protected function ListContentsOfType(string $type, string $path)
    {
        $_d34599daeb8cca374d3adb38b245839c = $this->flysystem->listContents($path, false);
        $_c00c0eb73f04b4a4ca0678ce86138b81 = [];
        foreach ($_d34599daeb8cca374d3adb38b245839c as $_6aead4bff5639b251aebcf8a630e43a7) {
            if ($_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["t" . "y" . "p" . "e"]] === $type) {
                $_c00c0eb73f04b4a4ca0678ce86138b81[] = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_32b8fa1ca33" . "0a0685321a37" . "9e5b9687d"]];
            }
        }
        return $_c00c0eb73f04b4a4ca0678ce86138b81;
    }
    
    
    
    
    public function ListContents(string $path) : array
    {
        $_d34599daeb8cca374d3adb38b245839c = $this->flysystem->listContents($path, false);
        $_c00c0eb73f04b4a4ca0678ce86138b81 = [];
        foreach ($_d34599daeb8cca374d3adb38b245839c as $_6aead4bff5639b251aebcf8a630e43a7) {
            $_c00c0eb73f04b4a4ca0678ce86138b81[] = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_32b8fa1ca" . "330a068532" . "1a379e5b96" . "87d"]];
        }
        return $_c00c0eb73f04b4a4ca0678ce86138b81;
    }
    public function ListContentsInfo(string $path) : array
    {
        $_6aead4bff5639b251aebcf8a630e43a7 = $this->flysystem->listContents($path, false);
        foreach ($_6aead4bff5639b251aebcf8a630e43a7 as &$_8043af106ba13a0ca9b53aa5c2df0e85) {
            unset($_8043af106ba13a0ca9b53aa5c2df0e85[$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_554a9169138240019acbd150264" . "2f16a"]]);
            unset($_8043af106ba13a0ca9b53aa5c2df0e85[$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["p" . "a" . "t" . "h"]]);
        }
        return $_6aead4bff5639b251aebcf8a630e43a7;
    }
    
    
    
    
    public function ListContentsRecursive(string $path) : array
    {
        return $this->flysystem->listContents($path, true);
    }
    
    
    
    
    public function ListFiles(string $path) : array
    {
        return $this->ListContentsOfType($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_6ae3783b9ad544" . "a6c31a979683fed" . "870"], $path);
    }
    
    
    
    
    public function ListDirs(string $path) : array
    {
        return $this->ListContentsOfType($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_c4f3321d131869e51a8844b6bc" . "d8fb86"], $path);
    }
    
    
    
    
    public function GetMetadata(string $path) : array
    {
        try {
            $_97ea09a7faf27c52c6eff69773df1d8a = $this->flysystem->getTimestamp($path);
            $size = $this->flysystem->getSize($path);
            $_9905761f4393d105cadfe7282a8c518d = $this->flysystem->getMimetype($path);
            $_e46a1b6a2fd927d616377ae17620d766 = $this->flysystem->getVisibility($path);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        return [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["si" . "ze"] => $size, $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_9905761f4393d105cadfe7" . "282a8c518d"] => $_9905761f4393d105cadfe7282a8c518d, $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_18c93a32ba5faf9509389a94787e67" . "98"] => $_97ea09a7faf27c52c6eff69773df1d8a, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_e46a1b6a2fd927d616" . "377ae17620d766"] => $_e46a1b6a2fd927d616377ae17620d766];
    }
    
    
    
    
    public function Exists(string $path) : bool
    {
        return $this->flysystem->has($path) && !$this->IsDir($path);
    }
    
    
    
    
    public function IsDir(string $path) : bool
    {
        if (!$this->flysystem->has($path)) {
            return false;
        }
        try {
            $metadata = $this->flysystem->getMetadata($path);
            $type = $metadata[$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["t" . "y" . "p" . "e"]] ?? null;
            return $type === $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_c4f3321d131869e51a8844b6b" . "cd8fb86"];
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            return false;
        }
    }
    
    
    
    
    public function GetLocalPath(string $path) : string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getLocalPath($path);
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetUrl(string $path) : ?string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getUrl($path);
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetUsedSpace() : string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getUsedSpace();
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    public function addPlugin(Flysystem\PluginInterface $_38198dbb7190fed0f875632ecef1ac6f)
    {
        $this->flysystem->addPlugin($_38198dbb7190fed0f875632ecef1ac6f);
    }
    
    
    
    
    public function RegisterProtocol(string $_21f5dd11309da4af2e51660e6f110a91) : void
    {
        StreamWrapper::register($_21f5dd11309da4af2e51660e6f110a91, $this->flysystem);
    }
    
    
    
    
    public function SetVisibility(string $path, string $_e46a1b6a2fd927d616377ae17620d766) : void
    {
        try {
            $this->flysystem->setVisibility($path, $_e46a1b6a2fd927d616377ae17620d766);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    
    
    protected function CloseStream($_1cc5aa2f679b575f82786a73f0da28f8) : void
    {
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_5febae03aa5407c291" . "b5c61a872cc1fd"]($_1cc5aa2f679b575f82786a73f0da28f8) && $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_f2646618c9dcad156a41241eacc" . "4c3f7"]($_1cc5aa2f679b575f82786a73f0da28f8) === $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_1cc5aa2f679b575f82" . "786a73f0da28f8"]) {
            $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_563b15b92a" . "77c869e85ed" . "f9569b4d025"]($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
}