var angular = require('cla_angular');

/**
 * Datatables table info control
 *
 *
 */
(function () {
	'use strict';

	var moduleName = 'cla.core.datatable'; var module;
	try { module = angular.module(moduleName); }
	catch(err) { module = angular.module(moduleName, []); }

	// dependencies
	module.directive('claDtPaging', Paging);
	Paging.$inject = ['dtService'];

	/**
	 *
	 * @param dtService
	 * @constructor
	 */
	function Paging(dtService) {
		var directive = {
			controller: controller,
			controllerAs: 'controller',
			replace: true,
			restrict: 'E',
			scope: {
				table: '@'
			},
			templateUrl: '/interface_default/common/datatable/control/paging.html'
		};
		directive.controller.$inject = ['$scope'];

		return directive;
		//////////////////


		/** directive controller */
		function controller($scope) {
			var ctl = this;

            this.$onInit = function() {
                ctl.myService = dtService.get($scope.table);
            };

			var min, max, visible_count = 5, offset = 1, current = 1;

			ctl.list = list;
			ctl.update = update;
			ctl.next = next;
			ctl.prev = prev;
			ctl.active = active;

			ctl.ldisabled = false;
			ctl.rdisabled = false;


			/**
			 * determines how many page numbers to list
			 */
			function list() {
				if (!ctl.myService.datatable)
					return;

				refresh(ctl.myService.info.page + 1);

				// default values
				min = (offset * visible_count) - (visible_count - 1);
				max = (ctl.myService.info.pages > visible_count) ? visible_count : ctl.myService.info.pages;

				// offset the max value && constrain
				max *= offset;
				if (max > ctl.myService.info.pages)
				{
					max = ctl.myService.info.pages;
					min = (max - visible_count) + 1;
				}

				return array(min, max);
			}

			/**
			 * updates the current page
			 * @param num
			 */
			function update(num) {
				if (!ctl.myService.datatable)
					return;

				refresh(num);
				ctl.myService.paginate(num - 1);
			}

			/**
			 * page next (forward 1)
			 */
			function next() {
				// data-tables handles keyword next
				ctl.myService.paginate('next');

				if (current + 1 <= ctl.myService.info.pages)
					refresh(current + 1);
			}

			/**
			 * page prev (prev 1)
			 */
			function prev() {
				// data-tables handles keyword previous
				ctl.myService.paginate('previous');

				if (current - 1 > 0)
					refresh(current - 1);
			}

			/**
			 * is the given page the active page
			 * @param num
			 */
			function active(num) {
				if (!ctl.myService.datatable)
					return;

				return ((ctl.myService.info.page + 1) == num);
			}

			/**
			 * updates paging variables
			 * @param num
			 */
			function refresh(num) {
				current = num;
				offset = Math.floor((current - 1) / visible_count) + 1;

				ctl.ldisabled = (current == 1);
				ctl.rdisabled = (current == ctl.myService.info.pages);
			}

			/**
			 * create an array of values within given range
			 * @param int min
			 * @param int max
			 */
			function array(min, max) {
				var out = [];
				for (var i = min; i <= max; i ++) {
					out.push(i);
				}
				return out;
			}
		}
	}
}());
