<?php
namespace Claromentis\Core\User\Directory\Ldap;

$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"] ?: array()) + array("_094a90ab5fdb" . "a7fad8a6b3c2c" . "7287bbf" => base64_decode("bnQ0X2RvbWFpbg" . "=="), "_ca5863bab59cc6be" . "b91e24291044d42a" => base64_decode("bWVtYmVyb2" . "Y="), "_70979d287fa2c98d21aa0783" . "4c259a52" => base64_decode("c3RydG9sb3d" . "lcg=="), "_178966c8ede126c06bf5e5c" . "c26ef9bb3" => base64_decode("Tm90IGFuIExEQ" . "VAgdXNlcg=="), "_4592b1201713114a11390e0bb87e68" . "0d" => base64_decode("ZG" . "4="), "_53e519c06eb01660" . "e367876cdd8385f2" => base64_decode("ZXh0" . "X2lk"), "_a591754a8ddcdbda9c80f" . "1db4d911e14" => base64_decode("aXNfbn" . "VsbA=="), "_d155d43a" . "39de93f85" . "8123c6b6c" . "e31d8a" => base64_decode("cHJlZ19" . "tYXRjaA" . "=="), "_4278f6e" . "1f1e27cc" . "1e96763e" . "4620a4ff" . "5" => base64_decode("Y21fZ" . "Gll"), "_f73dab606630b388645c4f7d3fb" . "b13bb" => base64_decode("YXJyYX" . "lfbWVy" . "Z2U="), "_64f204efc0caf630ef68bc" . "a568adbb53" => base64_decode("ZXh0" . "X3R5" . "cGU="), "_ef19287a2ea5e1fa7552d9" . "42c14752f9" => base64_decode("eC1kb" . "g=="), "_12223d821ca3" . "3ae8d28c4447e" . "3eaf058" => base64_decode("Tm8gdXN" . "lcm5hbW" . "UgZ2l2Z" . "W4="), "_ef0abf4494e1bd" . "7519b5603ea9e24" . "1fc" => base64_decode("RmFpbGVkIHRvIGxvZ2luIHRvIExE" . "QVAgc2VydmVyOiA="), "_a9148efa986a9a8d8f1f5281c6e" . "df49e" => base64_decode("VXNlciBhY2NvdW50IGlzIGRpc2FibGVkIGluIEx" . "EQVA="), "_7a6839269cdf25d875660c6a857" . "fbf8d" => base64_decode("L1tcZFx3XS" . "s9W1xkXHdd" . "KyQv"), "_c96c5a266f91484f929b433309" . "3dcede" => base64_decode("RW1wdHkgd" . "XNlcm5hbW" . "Uh"), "_9d799ff313bcf1dd5c17f004da" . "40f231" => base64_decode("VXNl" . "ciA="), "_aed8da0f1909121" . "4b78f80351048517" . "c" => base64_decode("c3Ryb" . "GVu"), "_4e306db4c4be96ad112eb80084bb" . "9348" => base64_decode("VGhpcyBhY2NvdW50IGRvZXMgbm90IGJlbG9uZyB0by" . "BhIHVzZXI="), "_5ff1b1d66ba406be918cf9d21d95d" . "870" => base64_decode("TERBUCBlc" . "nJvcjog"), "_8f65c3c384b75d89f9c" . "7783d4ebd4f32" => base64_decode("bGRhcF9leHBs" . "b2RlX2Ru"), "_c230c83684d3ea5d367c6d86c16c0" . "431" => base64_decode("eC11c2Vyb" . "mFtZQ=="), "_28c85ce81fee6532980262893b6f" . "2425" => base64_decode("dXNlcm5" . "hbWU="), "_c906bc81dd9c0320e" . "de9a60004ee65af" => base64_decode("d2luMjA" . "wMF9kb2" . "1haW4="), "_cdcf6e94ffc095d29538c4" . "824c1dba56" => base64_decode("Z" . "G" . "U" . "="), "_8ff0e2c6dc53989c37139" . "dd673c9ef80" => base64_decode("XA" . "=="), "_e4cff6b52204dc59b3dc7f" . "210b3150d3" => base64_decode("IGlzIG5vdCBhIG1lbWJlciBvZiBhb" . "Gxvd2VkIExEQVAgZ3JvdXAocykgYW" . "5kIE9Vcw=="), "_9777893780444e799e6e71df93" . "1556d0" => base64_decode("R2V0VXNlckROIHV" . "zZXJuYW1lOiA="), "_e608e5b5c4c34a67ba97ef84c1e1" . "6199" => base64_decode("Jw=" . "="), "_f9544f667576ee583b" . "77d09215297691" => base64_decode("c3RyaX" . "Bvcw=="), "_4d707fab93bebb" . "00bbe69e8159697" . "c90" => base64_decode(""), "_7957e500bc50a" . "c1b8f4c21b31f1" . "4575c" => base64_decode("QmluZFVzZXI6IGJpbmRpbmcg" . "dG8gZGlyZWN0b3J5IGNvbm5l" . "Y3Rpb24gYXMg"), "_af50df82a057" . "b10a621d476dc" . "fd58b99" => base64_decode("IWdyb3Vwc" . "w=="), "_4298577e4" . "1894bcce23" . "f896cd365a" . "ea4" => base64_decode("ZW" . "4="), "_1bee3d4d1d0df4" . "9e0fcf8b9ed2ecb" . "8fa" => base64_decode("ZXhwbG9kZ" . "Q=="), "_7f628626dd1d55c71b" . "1fc0932ffd1d2c" => base64_decode("aXNfYXJyYXk" . "="), "_d706c160e45bf7434ff" . "f82a5976f0e19" => base64_decode("YXJyYXlfa2V" . "5cw=="), "_81166ff3e9c179025b1" . "6a3404e7f7758" => base64_decode("RmFpbGVkIHRvIGdldCBzdGFuZGFyZCB1c2VybmFtZSBmcm9tIHByb3BlcnRpZX" . "MgJ3VzZXJwcmluY2lwYWxuYW1lJyBhbmQgJw=="), "_211bd0cc946472" . "1ec13058e6b5a9a" . "591" => base64_decode("dXNlcnBya" . "W5jaXBhbG" . "5hbWU="));
use Claromentis\Core\User\Directory\DirectorySettings;
use Claromentis\Core\User\Directory\Exception\LdapBindFailedException;
use Claromentis\Core\User\Directory\Exception\LdapLogicException;
use Claromentis\Core\User\Directory\Exception\LdapOperationException;
use Claromentis\Core\User\Directory\Exception\LdapUserNotAllowedException;
use Claromentis\Core\User\Directory\Exception\UnsupportedUserTypeException;
use Claromentis\Core\User\Directory\Exception\UsersDirectoryException;
use Claromentis\Core\User\Directory\ExternalUserInfo;
use Claromentis\Core\User\Directory\Ldap\Container\ContainerGroup;
use Claromentis\Core\User\Directory\Ldap\Container\ContainerOU;
use Claromentis\Core\User\Directory\Ldap\Container\ContainersCollection;
use Claromentis\Core\User\Directory\Ldap\Container\UsersContainerInterface;
use Claromentis\Core\User\Directory\UserDateProviderInterface;
use Claromentis\Core\User\Directory\UsersDirectoryInterface;
use CryptUtils;
use Exception;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;
use User;








class LdapDirectory implements UsersDirectoryInterface, UserDateProviderInterface, LoggerAwareInterface
{
    use LoggerAwareTrait;
    const DIRECTORY_TYPE = 'ldap';
    const DEFAULT_DATE_FORMAT = 'YmdHis.0\\Z';
    const DEFAULT_DATE_WITHOUT_YEAR_FORMAT = 'm-d';
    
    
    
    
    protected $data_parser;
    
    
    
    
    protected $config;
    
    
    
    
    protected $ldap_settings;
    
    
    
    
    protected $connection;
    
    
    
    
    protected $dir_key;
    protected static $groups_rid_cache = null;
    
    
    
    
    protected $name_translate = null;
    public function __construct(LdapSettings $_f56e92e2b328797520a80ee0c4fb95c5, string $_4cf5e7200d92ab57a631fec17739af9b, DataParserInterface $_a4b96b27e3b10c1a4523813f13b9343d, LoggerInterface $logger = null)
    {
        $this->ldap_settings = $_f56e92e2b328797520a80ee0c4fb95c5;
        $this->setLogger($logger ?? new NullLogger());
        $this->connection = new LdapDirectConnection($this->ldap_settings->server_url, [], $this->logger);
        $this->connection->SetServiceAccount($this->ldap_settings->user, $this->ldap_settings->password);
        $this->data_parser = $_a4b96b27e3b10c1a4523813f13b9343d;
        $this->dir_key = $_4cf5e7200d92ab57a631fec17739af9b;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function FetchExternalUserInfo(ExternalUserInfo $_b038d88c53d0ea3f6bc6c39a6fc77646)
    {
        $_c031077013afa9973ad3516e1ad65118 = $this->GetUserDn($_b038d88c53d0ea3f6bc6c39a6fc77646);
        $_ab45cd2ff0b3084c7533a223b3b093e1 = $this->GetLDAPUserInfo($_c031077013afa9973ad3516e1ad65118, true);
        $_c031077013afa9973ad3516e1ad65118 = $_ab45cd2ff0b3084c7533a223b3b093e1[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_ef19287a2e" . "a5e1fa7552d" . "942c14752f9"]];
        $this->EnsureUserAllowed($_c031077013afa9973ad3516e1ad65118);
        $_b038d88c53d0ea3f6bc6c39a6fc77646->ext_type = $this->GetDirKey();
        $_b038d88c53d0ea3f6bc6c39a6fc77646->ext_id = $_c031077013afa9973ad3516e1ad65118;
        $_b038d88c53d0ea3f6bc6c39a6fc77646->fields = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_f73dab606630b38" . "8645c4f7d3fbb13b" . "b"]($_b038d88c53d0ea3f6bc6c39a6fc77646->fields, $_ab45cd2ff0b3084c7533a223b3b093e1);
        $_b038d88c53d0ea3f6bc6c39a6fc77646->fields[$GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_64f204efc0caf6" . "30ef68bca568adb" . "b53"]] = [$_b038d88c53d0ea3f6bc6c39a6fc77646->ext_type];
        $_b038d88c53d0ea3f6bc6c39a6fc77646->fields[$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_53e519c06eb" . "01660e367876" . "cdd8385f2"]] = [$_b038d88c53d0ea3f6bc6c39a6fc77646->ext_id];
    }
    
    
    
    
    
    
    
    
    
    protected function GetUserDn(ExternalUserInfo $_b038d88c53d0ea3f6bc6c39a6fc77646) : string
    {
        $_4a033bdf0ce701c6255d5238633ab2d0 = $_b038d88c53d0ea3f6bc6c39a6fc77646->service_data;
        $this->logger->debug($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_9777893780444e799e6e71df93" . "1556d0"] . $_b038d88c53d0ea3f6bc6c39a6fc77646->fields[$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_28c85ce81fee6532980262893b6f24" . "25"]]);
        $_9961f986823b4be7f5c4cc8379c6b228 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_1bee3d4d1d0df49e0fcf8b9ed2" . "ecb8fa"]($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_8ff0e2c6dc" . "53989c37139" . "dd673c9ef80"], $_b038d88c53d0ea3f6bc6c39a6fc77646->fields[$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_28c85ce81fee6532980262893b6f24" . "25"]]);
        if ($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_70979d287fa" . "2c98d21aa078" . "34c259a52"]($this->ldap_settings->domain) !== $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_70979d287fa2c9" . "8d21aa07834c259" . "a52"]($_9961f986823b4be7f5c4cc8379c6b228[0])) {
            throw new UnsupportedUserTypeException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_178966c8ede126c06bf5e5cc26" . "ef9bb3"]);
        }
        if ($_b038d88c53d0ea3f6bc6c39a6fc77646->ext_type === $this->GetDirKey() && !empty($_b038d88c53d0ea3f6bc6c39a6fc77646->ext_id)) {
            $_c031077013afa9973ad3516e1ad65118 = $_b038d88c53d0ea3f6bc6c39a6fc77646->ext_id;
        } elseif ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_7f628626dd1d55c71b1fc0932ffd1" . "d2c"]($_4a033bdf0ce701c6255d5238633ab2d0) && isset($_4a033bdf0ce701c6255d5238633ab2d0[$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_ef19287a2ea5e1fa7552d942c14752" . "f9"]])) {
            $_c031077013afa9973ad3516e1ad65118 = $_4a033bdf0ce701c6255d5238633ab2d0[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_ef19287a2ea5e1fa7552d942c14752f" . "9"]];
        } else {
            $_c031077013afa9973ad3516e1ad65118 = $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_4d707fab93bebb00bbe69e815" . "9697c90"];
        }
        if ($this->IsDn($_c031077013afa9973ad3516e1ad65118)) {
            return $_c031077013afa9973ad3516e1ad65118;
        }
        if (!empty($_c031077013afa9973ad3516e1ad65118)) {
            $_28c85ce81fee6532980262893b6f2425 = $_c031077013afa9973ad3516e1ad65118;
        } else {
            $_28c85ce81fee6532980262893b6f2425 = $_b038d88c53d0ea3f6bc6c39a6fc77646->GetUsername();
        }
        if ($_28c85ce81fee6532980262893b6f2425 == $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_4d707fab93bebb00bbe69e8" . "159697c90"]) {
            throw new LdapLogicException($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_c96c5a266f91484f929b4333093dc" . "ede"]);
        }
        $_c031077013afa9973ad3516e1ad65118 = $this->GetNameTranslate()->GetUserDN($_28c85ce81fee6532980262893b6f2425);
        return $_c031077013afa9973ad3516e1ad65118;
    }
    
    
    
    
    
    
    
    
    protected function IsDn(string $_9a0b5569f06c8394f7fab90dbd9bc163) : bool
    {
        if ($_9a0b5569f06c8394f7fab90dbd9bc163 === $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_4d707fab93bebb00bbe69e8159697" . "c90"]) {
            return false;
        }
        return $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_8f65c3c38" . "4b75d89f9c" . "7783d4ebd4" . "f32"]($_9a0b5569f06c8394f7fab90dbd9bc163, false) !== false;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function CheckPassword($_28c85ce81fee6532980262893b6f2425, $_e0637eee905ebe3938c5da50e3db10d7)
    {
        if (!$this->IsDomainUser($_28c85ce81fee6532980262893b6f2425)) {
            throw new UnsupportedUserTypeException();
        }
        $this->BindUser($_28c85ce81fee6532980262893b6f2425, CryptUtils::RC4($_e0637eee905ebe3938c5da50e3db10d7, $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_4298577e418" . "94bcce23f896" . "cd365aea4"]));
    }
    protected function IsDomainUser($_28c85ce81fee6532980262893b6f2425)
    {
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_f9544f66757" . "6ee583b77d09" . "215297691"]($_28c85ce81fee6532980262893b6f2425, $this->ldap_settings->domain . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_8ff0e2c6d" . "c53989c371" . "39dd673c9e" . "f80"]) === 0) {
            return true;
        }
        return false;
    }
    
    
    
    
    
    
    
    
    
    public function GetReadonlyUserProfileFields(User $_24e0e36600d6af77406a44bb618a6253)
    {
        if (!$this->Enabled()) {
            return array();
        }
        $_122532f21c38b4934972bf1659a76920 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_d706c160e45bf74" . "34fff82a5976f0e1" . "9"]($this->ldap_settings->fields_map);
        $_122532f21c38b4934972bf1659a76920[] = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_28c85ce" . "81fee653" . "29802628" . "93b6f242" . "5"];
        return $_122532f21c38b4934972bf1659a76920;
    }
    
    
    
    
    
    
    public function Enabled()
    {
        return $this->ldap_settings->enabled;
    }
    
    
    
    
    
    
    
    
    
    
    
    protected function GetNameTranslate()
    {
        if ($this->name_translate == null) {
            $this->name_translate = new NameTranslate($this->connection, $this->ldap_settings, $this->logger);
        }
        return $this->name_translate;
    }
    
    
    
    
    
    
    
    
    protected function EnsureConnected()
    {
        
        
        
        $this->connection->Connect();
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function BindUser($_24e0e36600d6af77406a44bb618a6253 = null, $_c09fdb3aaf264bb220f143d800a9afd5 = '')
    {
        $this->connection->Connect();
        $this->logger->debug($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_7957e500bc50ac1b8" . "f4c21b31f14575c"] . $_24e0e36600d6af77406a44bb618a6253);
        $_fe0e8a022de5ead12d68c99e07c2847d = $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_a591754a8ddcdbda9c80f1d" . "b4d911e14"]($_24e0e36600d6af77406a44bb618a6253);
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_a591754a8ddcdbda9c80f1db4" . "d911e14"]($_24e0e36600d6af77406a44bb618a6253)) {
            $_24e0e36600d6af77406a44bb618a6253 = $this->ldap_settings->user;
            $_e0637eee905ebe3938c5da50e3db10d7 = $this->ldap_settings->password;
        } else {
            $_e0637eee905ebe3938c5da50e3db10d7 = CryptUtils::RC4($_c09fdb3aaf264bb220f143d800a9afd5, $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_cdcf6e94f" . "fc095d2953" . "8c4824c1db" . "a56"]);
        }
        if ($this->ldap_settings->bind_by_dn) {
            if ($_24e0e36600d6af77406a44bb618a6253 == $this->ldap_settings->user || $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_d155d43a39de9" . "3f858123c6b6ce" . "31d8a"]($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_7a6839269cdf" . "25d875660c6a8" . "57fbf8d"], $_24e0e36600d6af77406a44bb618a6253)) {
                
                
                $_39db25051c3981e849efcb9dffcfdcf6 = $_24e0e36600d6af77406a44bb618a6253;
            } else {
                $_39db25051c3981e849efcb9dffcfdcf6 = $this->GetNameTranslate()->GetUserDN($_24e0e36600d6af77406a44bb618a6253);
            }
        } else {
            $_cc7a304be0dc5735413298c4ee5847f6 = $this->ParseDomainUserName($_24e0e36600d6af77406a44bb618a6253);
            if ($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_aed8da0f19091214b" . "78f80351048517c"]($_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_094a90ab5fdba7fad8a6b3c2c7287b" . "bf"]]) > 0) {
                $_39db25051c3981e849efcb9dffcfdcf6 = $_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_094a90ab5" . "fdba7fad8a" . "6b3c2c7287" . "bbf"]] . $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_8ff0e2c6dc53989c37" . "139dd673c9ef80"] . $_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_28c85ce81fee6532980262893b6" . "f2425"]];
            } else {
                $_39db25051c3981e849efcb9dffcfdcf6 = $_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_28c85ce81fee65" . "32980262893b6f2" . "425"]] . $_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_c906bc81d" . "d9c0320ede" . "9a60004ee6" . "5af"]];
            }
        }
        if ($_fe0e8a022de5ead12d68c99e07c2847d) {
            $this->connection->SetServiceAccount($_39db25051c3981e849efcb9dffcfdcf6, $_e0637eee905ebe3938c5da50e3db10d7);
        } else {
            try {
                $this->connection->Bind($_39db25051c3981e849efcb9dffcfdcf6, $_e0637eee905ebe3938c5da50e3db10d7);
            } catch (LdapBindFailedException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
                throw new LdapBindFailedException($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_ef0abf4494e1bd7519" . "b5603ea9e241fc"] . $_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
            }
        }
        return true;
    }
    protected function EnsureConnectedBound()
    {
        $this->EnsureConnected();
    }
    
    
    
    
    protected function GetUsersContainer()
    {
        $_14e7d5dee412ccf516939d1e99c87733 = $this->ldap_settings->groups;
        $_2a2b1a41820d69b88d2dbb547389945d = $this->ldap_settings->ous;
        $_5e4594441b0e531bfd6f0011e0327611 = new ContainersCollection();
        if (!empty($_2a2b1a41820d69b88d2dbb547389945d)) {
            if ($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_7f628626dd1d5" . "5c71b1fc0932ff" . "d1d2c"]($_2a2b1a41820d69b88d2dbb547389945d)) {
                foreach ($_2a2b1a41820d69b88d2dbb547389945d as $_8fe302831dde8820e73faace6fd81b11) {
                    $_2db143885a946a181bb9cfa5c78146c3 = new ContainerOU($this->connection, $this->ldap_settings, $_8fe302831dde8820e73faace6fd81b11, $this->logger);
                    $_5e4594441b0e531bfd6f0011e0327611->AddContainer($_2db143885a946a181bb9cfa5c78146c3);
                }
            } else {
                $_2db143885a946a181bb9cfa5c78146c3 = new ContainerOU($this->connection, $this->ldap_settings, $_2a2b1a41820d69b88d2dbb547389945d, $this->logger);
                $_5e4594441b0e531bfd6f0011e0327611->AddContainer($_2db143885a946a181bb9cfa5c78146c3);
            }
        }
        if (!empty($_14e7d5dee412ccf516939d1e99c87733)) {
            if ($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_7f628626dd1d55c71b1fc0932f" . "fd1d2c"]($_14e7d5dee412ccf516939d1e99c87733)) {
                foreach ($_14e7d5dee412ccf516939d1e99c87733 as $_e9208e4fb555ac989f7519e19c1da810) {
                    $_29a0b3613c695dc583f9ee34f00d8187 = new ContainerGroup($this->connection, $this->ldap_settings, $_e9208e4fb555ac989f7519e19c1da810, $this->logger);
                    $_5e4594441b0e531bfd6f0011e0327611->AddContainer($_29a0b3613c695dc583f9ee34f00d8187);
                }
            } else {
                $_29a0b3613c695dc583f9ee34f00d8187 = new ContainerGroup($this->connection, $this->ldap_settings, $_14e7d5dee412ccf516939d1e99c87733, $this->logger);
                $_5e4594441b0e531bfd6f0011e0327611->AddContainer($_29a0b3613c695dc583f9ee34f00d8187);
            }
        }
        return $_5e4594441b0e531bfd6f0011e0327611;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    protected function EnsureUserAllowed($_c031077013afa9973ad3516e1ad65118)
    {
        $_e84a1b9eb8ec9d4f0cea0b9b922bdf62 = $this->GetUsersContainer();
        if (!$_e84a1b9eb8ec9d4f0cea0b9b922bdf62->IsMember($_c031077013afa9973ad3516e1ad65118)) {
            throw new LdapUserNotAllowedException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_9d799ff313bcf1dd5c17f004da40f" . "231"] . $_c031077013afa9973ad3516e1ad65118 . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_e4cff6b52204dc59b3" . "dc7f210b3150d3"]);
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    protected function GetLDAPUserInfo($_24e0e36600d6af77406a44bb618a6253, $_69faa59f62ba3f97a51512e4e7236db9 = false)
    {
        $_8e4f4231f852f06b05789873e3eb14eb = $this->GetRawUserInfo($_24e0e36600d6af77406a44bb618a6253, $_69faa59f62ba3f97a51512e4e7236db9);
        $_147aa65e6f86b03cd87a88a580320c7e = $this->GetUserInfoFromRaw($_8e4f4231f852f06b05789873e3eb14eb);
        if ($this->ldap_settings->map_groups !== null && $this->ldap_settings->map_groups != LdapSettings::GROUP_MAP_DISABLED) {
            $_147aa65e6f86b03cd87a88a580320c7e[$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_af50df82a057b10a621d47" . "6dcfd58b99"]] = $this->GetUserGroups($_8e4f4231f852f06b05789873e3eb14eb);
        }
        return $_147aa65e6f86b03cd87a88a580320c7e;
    }
    protected function GetUserGroups($_8e4f4231f852f06b05789873e3eb14eb)
    {
        $_8067f2d8e4fa1ba80f660e4b1abc5e3f = isset($_8e4f4231f852f06b05789873e3eb14eb[$GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_ca5863bab59cc6beb91e24" . "291044d42a"]]) ? $_8e4f4231f852f06b05789873e3eb14eb[$GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_ca5863bab59cc6beb" . "91e24291044d42a"]] : [];
        if (!$_8067f2d8e4fa1ba80f660e4b1abc5e3f) {
            return [];
        }
        $_1f24efd4735b7a11b391147435e7d35d = [];
        switch ($this->ldap_settings->map_groups) {
            case LdapSettings::GROUP_MAP_ENABLED:
                foreach ($_8067f2d8e4fa1ba80f660e4b1abc5e3f as $_74a34a7dc25078df9e146af189ce38fb) {
                    $_ce291a483bd670cf1511d10f93596bb6 = $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_8f65c3c38" . "4b75d89f9c" . "7783d4ebd4" . "f32"]($_74a34a7dc25078df9e146af189ce38fb, 1);
                    if (isset($_ce291a483bd670cf1511d10f93596bb6[0])) {
                        $_1f24efd4735b7a11b391147435e7d35d[] = $_ce291a483bd670cf1511d10f93596bb6[0];
                    }
                }
                break;
            case LdapSettings::GROUP_MAP_ENABLED_OU:
                $_8fe302831dde8820e73faace6fd81b11 = $this->ldap_settings->map_groups_expression;
                foreach ($_8067f2d8e4fa1ba80f660e4b1abc5e3f as $_74a34a7dc25078df9e146af189ce38fb) {
                    $_0c92cd3347f4e1cd8b2c48fbd1c2964d = $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_f9544f667576ee583b77d" . "09215297691"]($_74a34a7dc25078df9e146af189ce38fb, $_8fe302831dde8820e73faace6fd81b11);
                    if ($_0c92cd3347f4e1cd8b2c48fbd1c2964d === false || $_0c92cd3347f4e1cd8b2c48fbd1c2964d + $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_aed8da0f19091" . "214b78f8035104" . "8517c"]($_8fe302831dde8820e73faace6fd81b11) !== $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_aed8da0f19091214b78f" . "80351048517c"]($_74a34a7dc25078df9e146af189ce38fb)) {
                        continue;
                    }
                    $_ce291a483bd670cf1511d10f93596bb6 = $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_8f65c3c384b75d89f9c7" . "783d4ebd4f32"]($_74a34a7dc25078df9e146af189ce38fb, 1);
                    if (isset($_ce291a483bd670cf1511d10f93596bb6[0])) {
                        $_1f24efd4735b7a11b391147435e7d35d[] = $_ce291a483bd670cf1511d10f93596bb6[0];
                    }
                }
                break;
            case LdapSettings::GROUP_MAP_ENABLED_REGEX:
                $_ff52b0cc081aebf6724dddf29003ec05 = $this->ldap_settings->map_groups_expression;
                foreach ($_8067f2d8e4fa1ba80f660e4b1abc5e3f as $_74a34a7dc25078df9e146af189ce38fb) {
                    $_ce291a483bd670cf1511d10f93596bb6 = $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_8f65c3c384b75d89f9c7" . "783d4ebd4f32"]($_74a34a7dc25078df9e146af189ce38fb, 1);
                    if (!isset($_ce291a483bd670cf1511d10f93596bb6[0])) {
                        continue;
                    }
                    if ($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_d155d43a39de93f" . "858123c6b6ce31d8" . "a"]($_ff52b0cc081aebf6724dddf29003ec05, $_ce291a483bd670cf1511d10f93596bb6[0])) {
                        $_1f24efd4735b7a11b391147435e7d35d[] = $_ce291a483bd670cf1511d10f93596bb6[0];
                    }
                }
                break;
        }
        return $_1f24efd4735b7a11b391147435e7d35d;
    }
    
    
    
    
    
    
    
    protected function GetUserInfoFromRaw($_dbdfe9ef6c70506bf0730dfd58ea52a0)
    {
        try {
            return $this->data_parser->GetDataFromRaw($_dbdfe9ef6c70506bf0730dfd58ea52a0, $this->ldap_settings);
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_4278f6e1f1e27cc1e" . "96763e4620a4ff5"]($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage());
            return null;
            
            
        }
    }
    
    
    
    
    
    
    
    
    
    protected function GetPropertyValue($_ff02a3ae2d972df289e22f96c7b89ce4, $_dbdfe9ef6c70506bf0730dfd58ea52a0)
    {
        try {
            return $this->data_parser->GetValueByExpression($_dbdfe9ef6c70506bf0730dfd58ea52a0, $_ff02a3ae2d972df289e22f96c7b89ce4);
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_4278f6e1f1e27cc1e96" . "763e4620a4ff5"]($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage());
            return null;
            
            
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function GetRawUserInfo($_c060acb51130a54b61ab31ad8bbac121, $_69faa59f62ba3f97a51512e4e7236db9 = false)
    {
        static $last_found_user = null;
        static $last_found_dn = null;
        static $last_found_user_info = null;
        if ($_c060acb51130a54b61ab31ad8bbac121 == $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_4d707fab93b" . "ebb00bbe69e8" . "159697c90"]) {
            throw new LdapLogicException($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_12223d821ca33ae8d28c4447e3eaf0" . "58"], 24);
        }
        if ($last_found_user == $_c060acb51130a54b61ab31ad8bbac121 || $last_found_dn == $_c060acb51130a54b61ab31ad8bbac121) {
            return $last_found_user_info;
        }
        try {
            $this->EnsureConnectedBound();
            if (!$_69faa59f62ba3f97a51512e4e7236db9) {
                $_4592b1201713114a11390e0bb87e680d = $this->GetNameTranslate()->GetUserDN($_c060acb51130a54b61ab31ad8bbac121);
            } else {
                $_4592b1201713114a11390e0bb87e680d = $_c060acb51130a54b61ab31ad8bbac121;
            }
            $_6aead4bff5639b251aebcf8a630e43a7 = $this->connection->Read($_4592b1201713114a11390e0bb87e680d, $this->ldap_settings->user_type_filter);
            if (!$_6aead4bff5639b251aebcf8a630e43a7) {
                throw new LdapUserNotAllowedException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_4e306db" . "4c4be96a" . "d112eb80" . "084bb934" . "8"], 22);
            }
        } catch (LdapUserNotAllowedException $_445ae8a7d426a19b37bd4f87091b7f30) {
            throw $_445ae8a7d426a19b37bd4f87091b7f30;
        } catch (Exception $_445ae8a7d426a19b37bd4f87091b7f30) {
            throw new UsersDirectoryException($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_5ff1b1d" . "66ba406b" . "e918cf9d" . "21d95d87" . "0"] . $_445ae8a7d426a19b37bd4f87091b7f30->getMessage(), $_445ae8a7d426a19b37bd4f87091b7f30->getCode());
        }
        $_d895cb60bf79b51077a88f4cf5d0e6b5 = $this->ldap_settings->user_enabled_filter;
        if ($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_aed8da0f190912" . "14b78f803510485" . "17c"]($_d895cb60bf79b51077a88f4cf5d0e6b5) > 0) {
            $_371119a328eb895c2d8cf2d55855804e = $this->connection->Read($_4592b1201713114a11390e0bb87e680d, $_d895cb60bf79b51077a88f4cf5d0e6b5);
            if (!$_371119a328eb895c2d8cf2d55855804e) {
                throw new LdapUserNotAllowedException($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_a9148efa986a9a8d8f1f5281c6edf49" . "e"], 25);
            }
        }
        $_16c3b779dbe80d626e0d3710d09590fe = $this->ldap_settings->username_field;
        if (isset($_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_70979d287fa" . "2c98d21aa078" . "34c259a52"]($_16c3b779dbe80d626e0d3710d09590fe)])) {
            $_22b288e3b4e428769d167bb848c14cd0 = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_70979d287fa2c98d21aa07834c259a5" . "2"]($_16c3b779dbe80d626e0d3710d09590fe)][0];
        } elseif ($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_aed8da0" . "f1909121" . "4b78f803" . "51048517" . "c"]($_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_211bd0cc9464721ec130" . "58e6b5a9a591"]][0])) {
            $_22b288e3b4e428769d167bb848c14cd0 = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_211bd0cc9464721" . "ec13058e6b5a9a59" . "1"]][0];
        } else {
            $_22b288e3b4e428769d167bb848c14cd0 = $_6aead4bff5639b251aebcf8a630e43a7[$_16c3b779dbe80d626e0d3710d09590fe][0];
        }
        if ($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_aed8da0f19091214b78f80351048" . "517c"]($_22b288e3b4e428769d167bb848c14cd0) == 0) {
            throw new LdapOperationException($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_81166ff3e9c179025" . "b16a3404e7f7758"] . $_16c3b779dbe80d626e0d3710d09590fe . $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_e608e5b5c4c3" . "4a67ba97ef84c" . "1e16199"]);
        }
        $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_c230c83684d3e" . "a5d367c6d86c16" . "c0431"]] = $this->StandardizeUserName($_22b288e3b4e428769d167bb848c14cd0);
        if (!$_69faa59f62ba3f97a51512e4e7236db9) {
            $last_found_user = $_c060acb51130a54b61ab31ad8bbac121;
            $last_found_dn = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_4592b1201713114a11390e0b" . "b87e680d"]];
        } else {
            $last_found_user = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_c230c83684d3ea5d367c6d86c1" . "6c0431"]];
            $last_found_dn = $_c060acb51130a54b61ab31ad8bbac121;
        }
        $last_found_user_info = $_6aead4bff5639b251aebcf8a630e43a7;
        return $_6aead4bff5639b251aebcf8a630e43a7;
    }
    
    
    
    
    
    
    
    
    public function GetConnectionHandler()
    {
        $this->EnsureConnectedBound();
        return $this->connection;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function ParseDomainUserName($_28c85ce81fee6532980262893b6f2425)
    {
        return $this->GetNameTranslate()->ParseDomainUserName($_28c85ce81fee6532980262893b6f2425);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    protected function StandardizeUserName($_28c85ce81fee6532980262893b6f2425)
    {
        return $this->GetNameTranslate()->GetNT4Name($_28c85ce81fee6532980262893b6f2425);
    }
    
    
    
    
    
    
    
    public function GetUsersList()
    {
        $this->EnsureConnectedBound();
        $_5e4594441b0e531bfd6f0011e0327611 = $this->GetUsersContainer();
        $_b8f0500f7ec3de46e7358d52b895766a = $_5e4594441b0e531bfd6f0011e0327611->GetMembers();
        $_1519187376d66e1277bb574c97704a93 = [];
        foreach ($_b8f0500f7ec3de46e7358d52b895766a as $_28c85ce81fee6532980262893b6f2425 => $_c031077013afa9973ad3516e1ad65118) {
            $_e040648b744a44c96359dd803b6aa26a = $this->StandardizeUserName($_28c85ce81fee6532980262893b6f2425);
            $_d849cce608c34e14e0534b28c67a6b89 = new ExternalUserInfo($this->GetDirKey(), $_c031077013afa9973ad3516e1ad65118);
            $_d849cce608c34e14e0534b28c67a6b89->SetUsername($_e040648b744a44c96359dd803b6aa26a);
            $_1519187376d66e1277bb574c97704a93[] = $_d849cce608c34e14e0534b28c67a6b89;
        }
        return $_1519187376d66e1277bb574c97704a93;
    }
    
    
    
    
    
    
    
    
    public function UserBelongs(User $_24e0e36600d6af77406a44bb618a6253)
    {
        if (!$this->Enabled()) {
            return false;
        }
        return $_24e0e36600d6af77406a44bb618a6253->GetExtType() == $this->dir_key;
    }
    public function GetDirKey()
    {
        return $this->dir_key;
    }
    public function GetName()
    {
        return $this->ldap_settings->domain;
    }
    
    
    
    
    public function GetDirectorySettings()
    {
        return $this->ldap_settings;
    }
    public function GetDateFormat() : string
    {
        $_d3db06402a34baad2560c7da8a5f9fea = $this->ldap_settings->date_format;
        if (empty($_d3db06402a34baad2560c7da8a5f9fea)) {
            $_d3db06402a34baad2560c7da8a5f9fea = self::DEFAULT_DATE_FORMAT;
        }
        return $_d3db06402a34baad2560c7da8a5f9fea;
    }
    public function GetDateNoYearFormat() : string
    {
        $_256499a511fb5270d7961718f37cf545 = $this->ldap_settings->date_no_year_format;
        if (empty($_256499a511fb5270d7961718f37cf545)) {
            $_256499a511fb5270d7961718f37cf545 = self::DEFAULT_DATE_WITHOUT_YEAR_FORMAT;
        }
        return $_256499a511fb5270d7961718f37cf545;
    }
}