define(function () {
    class AiGenerativeDocsPlugin {
        constructor() {
            this.questions = '';
        }

        async install(host) {
            this.host = host;

            // Move the Ai action sheet to our target location
            const $teleport = $('.app-main-panel');

            $teleport.addClass('position-relative overflow-hidden');
            this.host.$action_sheet.appendTo($teleport);

            // Update the Input placeholder
            this.host.$text_prompt_area.attr('placeholder', lmsg('documents.ai.chat_generative_content.placeholder'));
        }

        onIntroductionTemplate() {
            const listItem = (question) => {
                const textLargerThanParent = this.host.isTextLargerThanParent(question)
                const displayClass = textLargerThanParent ? 'd-block' : 'd-inline';
                const textAlign = textLargerThanParent ? 'text-left' : 'text-right';

                return `
                    <li>
                        <div class="ai-question border p-1 rounded-lg ${displayClass} ${textAlign}" role="button">
                            ${question}
                        </div>
                    </li>
                `;
            };

            return $(`
                <div class="d-flex h-100 justify-content-between flex-column">
                    <div class="ai-introduction text-center pt-5">
                        <ion-icon name="information-circle-outline" class="rounded-circle p-3"></ion-icon>
                        <p class="pt-4">
                            ${lmsg('documents.ai.chat_generative_content.title')}
                        </p>
                    </div>
                    <div class="ai-questions">
                        <ul class="ai-questions-list text-right mb-2">
                            ${this.questions.map(listItem).join('')}
                        </ul>
                    </div>
                </div>
            `);
        }

        onIntroductionTemplateRendered() {
            const $questions = $('.ai-question');

            $questions.on('click', (e) => {
                this.host.SendMessage($(e.target).text());
            });
        }

        async onSetUp() {
            return this.host.Send((data) => {
                this.questions = this.extractQuestions(data.part.text);
            }, () => {
                this.host.AddConversation(lmsg('common.ai.chat.unsupported_type'), 'model', true);
                this.host.ShowLoading(false);
                this.host.DisableForm(true);
                this.host.ShowState('conversation');
            });
        }

        extractQuestions(htmlString) {
            const questions = [];
            const regex = /\[QUESTION\]([\s\S]*?)\[\/QUESTION\]/g;

            for (const match of htmlString.matchAll(regex)) {
                questions.push(match[1].trim());
            }

            return questions;
        }

    }

    return new AiGenerativeDocsPlugin();
});
