
$(document).ready(
    function(){
        $(".tile-absence-requests-component").each(
            function(){
                if($(this).find('div.requests-footer').length !== 0){
                    $(this).find('div.panel').addClass('has-footer');
                }
            }
        );
        //Must unbind first to allow two components to be on the same page. Otherwise there will be multiple click events assigned to all
        // the buttons and multiple success or fail modals will fire on each click
        if($('#js-awaiting-approval-list').children().length > 0){
            $(".js-youre-caught-up").hide();
        }
        $(".js-holiday-response-approve-button").unbind('click');
        $(".js-holiday-response-approve-button").click(
            function(){
                var toolTipId = $(this).attr('aria-describedby');
                console.log("toolTipId"+toolTipId);
                var requestObjectId = $(this).attr('request_id');
                var csrfNumber = document.csrf_token;
                $.ajax(
                    {
                        url:"/api/holidays/request/"+requestObjectId+"/approve",
                        data: {
                            csrf_token: csrfNumber
                        },
                        type: "POST",
                        success: function(result){
                            if(result.error){
                                cla.showMessage(result.message,"", result.error);
                                return
                            }
                            cla.showMessage(lmsg('holidays.requests.component.successfully_approved'),"", result.error);
                            $('#'+toolTipId).remove();
                            $('.holiday_request_container'+requestObjectId).each(function(){$(this).remove()});
                            if ( $('#js-awaiting-approval-list').children().length < 1 ) {
                                $('.js-awaiting-approval-title').each(function(){$(this).remove()});
                                $(".js-youre-caught-up").show();
                            }
                        }
                    }
                )
            }
        );
        //Must unbind first to allow two components to be on the same page. Otherwise there will be multiple click events assigned to all
        // the buttons and multiple success or fail modals will fire on each click
        $(".js-holiday-response-decline-button").unbind('click');
        $(".js-holiday-response-decline-button").click(
            function(){
                var toolTipId = $(this).attr('aria-describedby');
                var requestObjectId = $(this).attr('request_id');
                var csrfNumber = document.csrf_token;
                $.ajax(
                    {
                        url:"/api/holidays/request/"+requestObjectId+"/decline",
                        data: {
                            csrf_token: csrfNumber
                        },
                        type: "POST",
                        success: function(result){
                            if(result.error){
                                cla.showMessage(result.message,"", result.error);
                                return
                            }
                            cla.showMessage(lmsg('holidays.requests.component.successfully_declined'),"", result.error);
                            $('#'+toolTipId).remove();
                            $('.holiday_request_container'+requestObjectId).each(function(){$(this).remove()});
                            if ( $('#js-awaiting-approval-list').children().length < 1 ) {
                                $('.js-awaiting-approval-title').each(function(){$(this).remove()});
                                $(".js-youre-caught-up").show();
                            }
                        }
                    }
                )
            }
        );
    }
);
