<?php
/*
 * CKFinder
 * ========
 * http://ckfinder.com
 * Copyright (C) 2007-2012, CKSource - Frederico Knabben. All rights reserved.
 *
 * The software, this file and its contents are subject to the CKFinder
 * License. Please read the license.txt file before using, installing, copying,
 * modifying or distribute this file or part of its contents. The contents of
 * this file is part of the Source Code of CKFinder.
 */
if (!defined('IN_CKFINDER')) exit;

/**
 * @package CKFinder
 * @subpackage CommandHandlers
 * @copyright CKSource - Frederico Knabben
 */

/**
 * Include base XML command handler
 */
require_once CKFINDER_CONNECTOR_LIB_DIR . "/CommandHandler/XmlCommandHandlerBase.php";

/**
 * Handle GetFiles command
 *
 * @package CKFinder
 * @subpackage CommandHandlers
 * @copyright CKSource - Frederico Knabben
 */
class CKFinder_Connector_CommandHandler_GetFiles extends CKFinder_Connector_CommandHandler_XmlCommandHandlerBase
{
    /**
     * Command name
     *
     * @access private
     * @var string
     */
    private $command = "GetFiles";

    /**
     * handle request and build XML
     * @access protected
     *
     */
    protected function buildXml()
    {
        $_config =& CKFinder_Connector_Core_Factory::getInstance("Core_Config");
        if (!$this->_currentFolder->checkAcl(CKFINDER_CONNECTOR_ACL_FILE_VIEW)) {
            $this->_errorHandler->throwError(CKFINDER_CONNECTOR_ERROR_UNAUTHORIZED);
        }

		$vfs_handler = $this->getVFSHandler();

		// call Virtual File System handler to get files
		$files = $vfs_handler->GetFiles();

		// Create the "Files" node.
        $oFilesNode = new Ckfinder_Connector_Utils_XmlNode("Files");
        $this->_connectorNode->addChild($oFilesNode);

        if (sizeof($files)>0) {
	        $resourceTypeInfo = $this->_currentFolder->getResourceTypeConfig();
            $_thumbnailsConfig = $_config->getThumbnailsConfig();
            $_thumbServerPath = '';
            $_showThumbs = (!empty($_GET['showThumbs']) && $_GET['showThumbs'] == 1);
            if ($_thumbnailsConfig->getIsEnabled() && ($_thumbnailsConfig->getDirectAccess() || $_showThumbs)) {
                $_thumbServerPath = $this->_currentFolder->getThumbsServerPath();
            }

            //natcasesort($files);
            $i=0;
            foreach ($files as $file) {
				$filename = CKFinder_Connector_Utils_Misc::mbBasename($file['name']);
				if (!$resourceTypeInfo->checkExtension($filename, false)) {
					continue;
				}
				if ($resourceTypeInfo->checkIsHiddenFile($filename)) {
					continue;
				}
				$oFileNode[$i] = new Ckfinder_Connector_Utils_XmlNode("File");
				$oFilesNode->addChild($oFileNode[$i]);
				$oFileNode[$i]->addAttribute("name", $file['name_encoded']);
				$oFileNode[$i]->addAttribute("date", @date("YmdHi", $file['date']));

				if (!empty($file['thumb_url']))
				{
					$oFileNode[$i]->addAttribute("thumb_url", $file['thumb_url']);
				} else
				{
					if (!empty($_thumbServerPath) && preg_match(CKFINDER_REGEX_IMAGES_EXT, $filename)) {
						if (file_exists($_thumbServerPath . $filename)) {
							$oFileNode[$i]->addAttribute("thumb", $filename);
						}
						elseif ($_showThumbs) {
							$oFileNode[$i]->addAttribute("thumb", "?" . $filename);
						}
					}
				}

				if (!empty($file['url']))
				{
					$oFileNode[$i]->addAttribute("url", $file['url']);
				}

				$size = $file['size'];
				if ($size && $size<1024) {
					$size = 1;
				}
				else {
					$size = (int)round($size / 1024);
				}
				$oFileNode[$i]->addAttribute("size", $size);
				$i++;
            }
        }
    }
}
