define(['cla_angular', './breadcrumb.service', './breadcrumb.html'], function (angular, unused, template) {

    var moduleName = 'cla.core.breadcrumb';
    try {
        var module = angular.module(moduleName);
    } catch (err) {
        // named module does not exist, so create one
        module = angular.module(moduleName, []);
    }

    module.directive('claBreadcrumb', breadcrumb);
    breadcrumb.$inject = ['$rootScope', '$timeout', 'breadcrumb.service'];

    function breadcrumb($rootScope, $timeout, service) {
        var controller = function () {
            var ctrl = this;

            this.$onInit = function() {
                ctrl.crumbs = service.getCrumbs();

                service.registerCallback(ctrl.breadcrumbCallback);
            };

            ctrl.breadcrumbCallback = function () {
                ctrl.crumbs = service.getCrumbs();

                // Trigger a digest to update the view
                $timeout(function () {
                    $rootScope.$digest();
                }, 0);
            };

            ctrl.init = function (crumbs) {
                service.setCrumbs(crumbs);
            }
        };

        var link = function (scope, element, attrs, controller) {
            cla.ng = cla.ng || {};
            cla.ng.breadcrumbs =
                {
                    setCrumbs: function (data) {
                        service.setCrumbs(data);
                    }
                };

            var value = angular.element(element).data('init');
            if (typeof value !== 'undefined')
                controller.init(value);

	        var hybrid_data = angular.element(element).data('hybrid');
	        if (typeof hybrid_data !== 'undefined')
	        {
	        	scope.hybrid = true;
		        scope.h_data = hybrid_data;
	        }

        };

        return {
            restrict: 'E',
            //templateUrl: '/intranet/js/angular/cla/breadcrumb/breadcrumb.html',
            templateUrl: template,
            scope: {},
            controllerAs: 'breadcrumb',
            controller: controller,
            link: link
        };
    }

});
