define(['cla_angular', './datetime_picker.html', 'ng.cla.core.time_picker', 'ng.cla.core.date_picker'], function (angular, template) {
	var moduleName = 'cla.core.datetime_picker';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, ['cla.core.time_picker', 'cla.core.date_picker']);
	}

	module.directive('claDateTimePicker', datetimePicker);

	function datetimePicker() {
		return {
			restrict: 'E',
			require: '^ngModel',
			templateUrl: template,
			scope: {
				ngModel: '=',
				id: '@',
				timeFormat: '@'
			},
			controller: function () {
				var ctrl = this;
			},
			controllerAs: 'ctrl',
			bindToController: true
		};
	}

	return null;
});
