define(['cla_angular', './time_picker.html', 'jquery', '../../../../../web/intranet/js/timepicker/jquery.timepicker.min.js', '../../../../../web/intranet/js/timepicker/jquery.timepicker.css'], function (angular, template, $) {
	var moduleName = 'cla.core.time_picker';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	module.directive('claTimePicker', timePicker);

	timePicker.$inject = ['$timeout'];
	function timePicker($timeout) {
		return {
			restrict: 'E',
			require: '^ngModel',
			templateUrl: template,
			scope: {
				ngModel: '=',
				timeFormat: '@'
			},
			link: function(scope, iElement, iAttrs, ctrl)
			{
				scope.id = iAttrs.id;
				scope.name = iAttrs.name;

				scope.clickTime = function(event)
				{
					event.preventDefault();

					var picker = angular.element('#' + scope.id + '-inner');

					// Compatibility with Pages settings if needed
					if (window.cla.pagesEdit !== undefined)
					{
						window.cla.pagesEdit.popoverAutoClose = false;
						picker.off('hideTimepicker');
						picker.on('hideTimepicker', function(event)
						{
							$timeout(function()
							{
								window.cla.pagesEdit.popoverAutoClose = true;
							}, 0);
						});
					}

					if (scope.timeFormat === undefined)
						scope.timeFormat = '';

					var options =
					{
						scrollDefault: 'now',
						maxTime: '23:59',
						timeFormat: scope.timeFormat !== '' ? scope.timeFormat : 'H:i'
					};

					picker.data('time_picker_initialized', 1).timepicker(options).timepicker('show');
				};
			}
		};
	}

	return null;
});