var angular = require('cla_angular');

/**
 * Datatables table info control
 *
 *
 */
(function () {
	'use strict';

	var moduleName = 'cla.core.datatable'; var module;
	try { module = angular.module(moduleName); }
	catch(err) { module = angular.module(moduleName, []); }

	// dependencies
	module.directive('claDtInfo', Info);
	Info.$inject = ['dtService'];

	/**
	 *
	 * @param dtService
	 * @constructor
	 */
	function Info(dtService) {
		var directive = {
			controller: controller,
			controllerAs: 'controller',
			replace: true,
			restrict: 'E',
			scope: {
				table: '@'
			},
			templateUrl: '/interface_default/common/datatable/control/info.html'
		};

		directive.controller.$inject = ['$scope'];

		return directive;
		//////////////////


		/** directive controller */
		function controller($scope) {
			var ctl = this;

            this.$onInit = function() {
                ctl.myService = dtService.get($scope.table);
            };

			ctl.info = getInfo;

			/**
			 * datatable info
			 */
			function getInfo() {
				var info = ctl.myService.info;

				if (!info)
					return;

				var display = info.recordsDisplay;
				var total = info.recordsTotal;

				var plural = display === 1 ? lmsg('common.datatable.info.entry') : lmsg('common.datatable.info.entries');
				var start = display > 0 ? info.start + 1 : 0;
				var end = info.end;

				var output = [lmsg('common.datatable.info', start, end, display), ' ', plural];

				if (display < total) {
					output = output.concat([' (', lmsg('common.datatable.info.filtered', info.recordsTotal), ')']);
				}

				return output.join('');
			}
		}
	}
}());
