var angular = require('cla_angular');

/**
 * Datatables table info control
 *
 *
 */
(function () {
	'use strict';

	var moduleName = 'cla.core.datatable'; var module;
	try { module = angular.module(moduleName); }
	catch(err) { module = angular.module(moduleName, []); }

	// dependencies
	module.directive('claDtSearch', Search);
	Search.$inject = ['dtService'];

	/**
	 *
	 * @param dtService
	 * @constructor
	 */
	function Search(dtService) {
		var directive = {
			controller: controller,
			controllerAs: 'controller',
			replace: true,
			restrict: 'E',
			scope: {
				table: '@'
			},
			templateUrl: '/interface_default/common/datatable/control/search.html'
		};
		directive.controller.$inject = ['$scope'];

		return directive;
		//////////////////


		/** directive controller */
		function controller($scope) {
			var ctl = this;

            this.$onInit = function() {
                ctl.myService = dtService.get($scope.table);
            };

			ctl.keywords = '';
			ctl.search = search;

			function search() {
				ctl.myService.search(ctl.keywords);
			}
		}
	}
}());
