define(['./trigger.js'], function (Trigger) {

    /**
     * @class Triggers
     * @construtor
     * @property {Array} triggers - Array of Trigger objects
     */
    var Triggers = function () {
        this.collection = new Triggers.Collection(window.triggers);

        this.view = new Triggers.View();
        this.collection.setView(this.view);
        this.view.setCollection(this.collection);
    };

    Triggers.Collection = function (triggers) {
        this.view = null;
        /**
         * Array of Trigger objects
         * @private
         * @type {Array}
         */
        this.triggers = [];

        this.init(triggers);
    };

    Triggers.Collection.prototype = (function () {

        var setView = function (view) {
            this.view = view;
        };

        /**
         * @private
         * @memberOf Triggers
         * @param data
         */
        var setData = function (data) {
            var self = this;
            _.each(data, function (trigger) {
                var instance = new Trigger(trigger);
                self.triggers.push(instance);
            });
            return self;
        };

        /**
         * Get array of Trigger objects
         * @private
         * @memberOf Triggers
         */
        var getData = function () {
            if (_.isArray(this.triggers)) {
                return this.triggers;
            } else {
                return [];
            }
        };

        return {
            setView: setView,
            /**
             * @public
             * @memberOf Triggers
             */
            init: setData,

            /**
             * Get array of Trigger objects
             * @public
             * @memberOf Triggers
             */
            triggers: getData
        };

    })();

    Triggers.View = function () {
        this.collection = null;

        this.el = null;
    };

    Triggers.View.prototype = (function () {
        var setCollection = function (collection) {
            this.collection = collection;
        };

        /**
         * @public
         * @memberOf Triggers
         */
        var render = function () {
            $('#trigger-select').empty();
            _.each(this.collection.triggers, function (trigger) {
                trigger.view.render();
            });
        };

        return {
            setCollection: setCollection,
            /**
             * @public
             * @memberOf Triggers
             */
            render: render
        };
    })();

    return Triggers;
});