/**
 * LDAP Connection form section
 */
(function () {
	'use strict';

	angular.module('cla.ldap.connections')
		.directive('connection', connection);

	connection.$inject = ['connectionService'];

	/**
	 * @param connectionService service
	 */
	function connection (service) {
		return {
			controller: controller,
			controllerAs: 'connection',
			restrict: 'E',
			scope: { },
			templateUrl: '/interface_default/admin/system/templates/connection.directive.html'
		};

		function controller () {
			var conn = this;
			this.properties = service.properties;

			// function variables
			this.testConnection = testConnection;
			this.next = next;
			this.getBgHighlightClass = getBgHighlightClass;
			this.getTitleHighlightClass = getTitleHighlightClass;

			// form variables
			this.completed = false;
			this.connected = service.connected;
			this.statusMessage = '';
			this.is_windows = ldap_preload.is_windows;

			init();

			/**
			 * init directive
			 */
			function init() {
				service.preload(ldap_preload.form_data);
				if (ldap_preload.form_data && ldap_preload.form_data.id) {
					$('#service-account-password-masked').show();
					$('#service-account-password-reset-link').click(function(e){
						e.preventDefault();
						$('#service-account-password-masked').hide();
						$('#service-account-password').show();
					});
					$('#service-account-password').hide();

					conn.connected =
						service.connected =
							conn.completed = true;
					conn.statusMessage = lmsg("admin.ldap.text.test_status_ok");
				}
				else
				{
					$('#service-account-password-masked').hide();
				}
			}

			/**
			 * run connection test, return promise for chaining .then() if called elsewhere
			 */
			function testConnection() {
				$('#ldap_connection_test_message').show();
				conn.connected = null;
				return service.test().then(function (response) {
					$('#ldap_connection_test_message').hide();
					conn.connected = service.connected = response.success;
					conn.statusMessage = response.success ? lmsg("admin.ldap.text.test_status_ok") : response.message;
				}, function (response) {
					$('#ldap_connection_test_message').hide();
					conn.connected = service.connected = false;
					conn.statusMessage = response.data.message;
				});
			}

			/**
			 * continue button. moves to next step
			 */
			function next() {
				conn.testConnection().then(function () {
					if (conn.connected) {
						conn.completed = true;
						$('#collapse-connection').collapse('hide');
						$('#collapseTwo').collapse('show');
					}
				});
			}

			/**
             * gets the highlight class / text class for the section header
			 */
			function getBgHighlightClass() {
				if (!conn.completed)
					return '';
				else if (conn.connected && conn.completed)
					return 'bg-success';
				else
					return 'bg-danger';
			}

            function getTitleHighlightClass() {
                if (!conn.completed)
                    return '';
                else
                    return 'text-white';
            }
		}
	}
}());
