/**
 * User Groups form section
 */
(function () {
	'use strict';

	angular.module('cla.ldap.connections')
		.directive('status', status);

	status.$inject = ['statusService'];

	/**
	 * @param statusService service
	 */
	function status (service) {
		return {
			controller: controller,
			controllerAs: 'status',
			restrict: 'E',
			scope: { },
			templateUrl: '/interface_default/admin/system/templates/status.directive.html'
		};

		function controller () {
			var status = this;
			this.properties = service.properties;

			this.completed = false;

			init();

			function init() {
				service.preload(ldap_preload.form_data);
				if (ldap_preload.form_data && ldap_preload.form_data.id) {
					status.completed = true;
				}
			}
		}
	}
}());