/**
 * Holds data on user groups
 *
 */
(function () {
	'use strict';

	angular.module('cla.ldap.connections')
		.service('userGroupsService', userGroupsService);

	//userGroupsService.$inject = [];

	/**
	 *
	 */
	function userGroupsService() {
		var service = {
			properties: {
				mapGroupsToProfile: 0,
				limitByRegex: '',
				limitByOu: ''
			},

			mapNames: mapNames,
			preload: preload
		};

		return service;

		/**
		 * map js property names to expected url params
		 */
		function mapNames() {
			var object = {
				'map_groups': service.properties.mapGroupsToProfile
			}

			if (service.properties.limitByRegex.length > 0) {
				object.map_groups_expression = service.properties.limitByRegex;
			} else if (service.properties.limitByOu.length > 0) {
				object.map_groups_expression = service.properties.limitByOu;
			}

			return object;
		}

		/**
		 * preloads the object with the data passed to this function
		 */
		function preload(data) {
			if (data) {
				var object = {
					'mapGroupsToProfile': data.map_groups
				};

				if (data.map_groups == 2) {
					object.limitByRegex = data.map_groups_expression;
				} else if (data.map_groups == 3) {
					object.limitByOu = data.map_groups_expression;
				}

				angular.extend(service.properties, object);
			}
		}
	}
}());