define(['../add_language_app', '../html/language_list.html'], function (app, template) {
    listController.$inject = ['restCollection', '$timeout', '$element', 'growl.service'];

    /**
     * @param restCollection
     * @param $timeout
     * @param $element
     * @param growl
     */
    function listController(restCollection, $timeout, $element, growl) {
        var ctrl = this;

        ctrl.list = window.languages;

        $timeout(function () {
            angular.element("#language-modals").on("modal-add", function (e, data) {
                var code = data.code.toLowerCase();
                var matching = ctrl.list.filter(function(elem){return elem.code === code});
                if(matching.length > 0)
                {
                    $($element).trigger("language-failure", {errorText:lmsg('panels.i18n.lang_already_exists')});
                    return;
                }

                if(data.code.length !== 2)
                {
                    $($element).trigger("language-failure", {errorText:lmsg('panels.i18n.lang_code_bad')});
                    return;
                }

                if(data.title.length <= 0)
                {
                    $($element).trigger("language-failure", {errorText:lmsg('panels.i18n.no_lang_name')});
                    return;
                }

                restCollection.post({code: code, title: data.title, builtin: false});
                ctrl.list.push({code: code, title: data.title, builtin: false});

                $($element).trigger("language-success");
            });

            angular.element("#language-modals").on("modal-edit", function (e, data) {

                if(data.title.length <= 0)
                {
                    $($element).trigger("language-failure", {errorText:lmsg('panels.i18n.no_lang_name')});
                    return;
                }

                restCollection.post({code: data.code, title: data.title, builtin: false});
                ctrl.list[data.index].title = data.title;

                $($element).trigger("language-success");
            });
        }, 0);

        ctrl.deleteItem = function (event, index, code) {
            event.preventDefault();
            $(event.currentTarget).tooltip('hide');

            restCollection.delete(code);
            ctrl.list.splice(index, 1);

            growl.showSuccess(lmsg('panels.i18n.changes_ok'));
        };

        ctrl.editItem = function (event, index) {
            event.preventDefault();
            $($element).trigger("modal-set-mode", {mode:"edit", langObj:ctrl.list[index], index:index});
            $("#add-modal").modal();

        };

        ctrl.addLang = function () {
            $($element).trigger("modal-set-mode", {mode:"add", langObj:{code: '', title: ''}, index:0});
            $("#add-modal").modal();
        };
    }

    app.directive('languageList', function () {
        return {
            restrict: 'E',
            replace: true,
            bindToController: true,
            controllerAs: 'ctrl',
            templateUrl: template,
            controller: listController
        }
    });
});