require('script-loader!../../web/intranet/js/modernizr.2.8.3-custom.js');
require('script-loader!jquery/dist/jquery.min.js');

// jQuery Migrate.
// NPM copy for Production builds, in-repo development copy for development builds.
// Should be removed when all jQuery usages have been updated.
(function () {
    // IIFE monkeypatch below to suppress the initial console log from jQuery Migrate
    // TODO: Remove this when jQuery Migrate is removed
    var nativeConsoleLog = console.log;

    console.log = function (message) {
        if (arguments.length && arguments[0].indexOf('JQMIGRATE: Migrate is installed') > -1) {
            console.log = nativeConsoleLog;
            return;
        }

        nativeConsoleLog.apply(this, arguments);
    }
})();

// "PRODUCTION" is defined (replaced with `true` or `false`) using the DefinePlugin in webpack.config.js.
if (PRODUCTION) {
    require('script-loader!jquery-migrate/dist/jquery-migrate.min.js');
} else {
    require('script-loader!jquery-migrate/dist/jquery-migrate.js');
}

/**
 * Disables console warnings for jQuery Migrate.
 * Rewritten in `web/interface_default/common/core_head.html` according to Claromentis developer mode.
 */
jQuery.migrateMute = true;

// Disables console stack traces. Only required in jQuery Migrate development build.
jQuery.migrateTrace = false;

// Default XHR error handler that falls back to no-op
// https://api.jquery.com/jquery.ajaxsetup/
jQuery.ajaxSetup({
    error: function (jqXHR) {
        var logArguments = ["jQuery.ajax() error", "\njqXHR object:", jqXHR];
        var growlAvailable = cla && cla.showMessage && typeof cla.showMessage === 'function';
        var responseJson = null;

        try {
            responseJson = jQuery.parseJSON(jqXHR.responseText);
            logArguments.push("\nResponse JSON:", responseJson);
        } catch (e) {
            // No-op, we simply couldn't parse JSON
            logArguments.push("\nJSON parse error:", e);
        }

        if (growlAvailable && responseJson !== null && responseJson.message) {
            cla.showMessage(responseJson.message, null, true);
        }

        console.error.apply(null, logArguments);
    }
});

require('script-loader!../../web/intranet/js/json2.js');
require('script-loader!../../node_modules/jquery-ui/dist/jquery-ui.min.js');
require('script-loader!../../node_modules/jquery-ui-touch-punch/jquery.ui.touch-punch.min.js');
window._ = require("./underscore");

require('script-loader!../../node_modules/requirejs/require.js');

// these files potentially can to the async loading in page footer
require('script-loader!../../web/intranet/js/persist-min.js');
require('imports-loader?jQuery=jquery,$=jquery,this=>window,define=>false,exports=>false!../../node_modules/bootstrap/dist/js/bootstrap.bundle.js');
require('../../web/intranet/js/meow/jquery.meow.css');
require('script-loader!../../web/intranet/js/meow/jquery.meow.js');
