function check() {
  if (window.innerWidth < 768) {
    document.getElementById("remember_login").checked = true;
  }
}

check();

function focusOnInput() {
    document.getElementById("frmuser").focus();
}

window.addEventListener('load', function() {
    focusOnInput();
});

// Finds input and password toggle button
var passwordInput = document.getElementById('frmpass');

var showPasswordButtonId = 'show-password';
var hidePasswordButtonId = 'hide-password';

var passwordToggleButtons = document.getElementsByClassName('btn-login-password');
var showPasswordButton = document.getElementById(showPasswordButtonId);
var hidePasswordButton = document.getElementById(hidePasswordButtonId);

// Find show/hide buttons and returns the value of the one which is clicked to the function
for (let i = 0; i < passwordToggleButtons.length; i++) {
  passwordToggleButtons[i].addEventListener('click', event => {
    passwordToggle(event);
  });

  // Applies blur to buttons so the tooltip disappears automatically
  passwordToggleButtons[i].addEventListener('mouseout', event => {
    passwordToggleButtons[i].blur();
  });

}

function passwordToggle(e) {
    var eventTarget = e.target;
    var targetSibling;

    // Finds id of targeted button and applies input type and sets sibling button
    if (eventTarget.id === showPasswordButtonId) {
        targetSibling = hidePasswordButton;
        passwordInput.setAttribute('type', 'text');
    } else {
        targetSibling = showPasswordButton;
        passwordInput.setAttribute('type', 'password');
    }

    eventTarget.classList.add('d-none');
    targetSibling.classList.remove('d-none');
}
