/**
 Fetch glyphicons string
 */
var claIcon = function(fileName) {
	var icons = docs_list_preload_data.icons;
	var ext = fileName.substr(fileName.lastIndexOf('.') + 1).toLowerCase();
	var icon = _.find(icons, function(icon, key) {
		return key === ext;
	});
	if( typeof icon === 'undefined') {
		icon = 'glyphicons glyphicons-file';
	}
	return icon;
};
/**
 Convert bytes to a more human readable format
 */
var fileSizeConvert = function(bytes, precision) {
	var kilobyte = 1024;
	var megabyte = kilobyte * 1024;
	var gigabyte = megabyte * 1024;
	var terabyte = gigabyte * 1024;
	// I doubt it but just in case :)
	if((bytes >= 0) && (bytes < kilobyte)) {
		return lmsg('documents.functions.bytes', bytes); // return bytes + ' Bytes';
	} else if((bytes >= kilobyte) && (bytes < megabyte)) {
		return (bytes / kilobyte).toFixed(2) + ' ' + lmsg('common.kb');
	} else if((bytes >= megabyte) && (bytes < gigabyte)) {
		return (bytes / megabyte).toFixed(2) + ' ' + lmsg('common.mb');
	} else if((bytes >= gigabyte) && (bytes < terabyte)) {
		return (bytes / gigabyte).toFixed(2) + ' ' + lmsg('common.gb');
	} else if(bytes >= terabyte) {
		return (bytes / terabyte).toFixed(2) + ' ' + lmsg('documents.functions.tb');
	} else {
		return lmsg('documents.functions.bytes', bytes); // bytes + ' Bytes';
	}
	return string;
};
/**
 Shows an alert/confirmation
 */
var docsShowMessage = function(message, message_type)
{
	switch (message_type)
	{
		case 'error':
			cla.showMessage(message, '', true);
			break;
		case 'success':
			cla.showMessage(message, '', false);
			break;
		case 'info':
		default:
			cla.showMessage(message, '', 'info');
			break;
	}
};

