// shows actions on the right side - either actions with selected documents or clipboard actions
var AsideView = Backbone.View.extend({
	selected_collection: null,
	clipboard_collection: null,

	clipboard_view: null,
	selected_actions_view: null,

	setSelectedCollection: function (selected_collection, aside_actions_view)
	{
		if (this.selected_collection)
		{
			this.selected_collection.unbind('change', this.render, this);
			this.selected_collection.unbind('reset', this.render, this);
			this.selected_collection.unbind('remove', this.render, this);
			this.selected_collection.unbind('add', this.render, this);
		}

		this.selected_collection = selected_collection;
		this.selected_collection.bind('change', this.render, this);
		this.selected_collection.bind('reset', this.render, this);
		this.selected_collection.bind('remove', this.render, this);
		this.selected_collection.bind('add', this.render, this);

		if (aside_actions_view)
		{
			if (this.selected_actions_view)
				this.selected_actions_view.undelegateEvents();
			this.selected_actions_view = aside_actions_view;
			this.selected_actions_view.undelegateEvents();
			this.selected_actions_view.delegateEvents();
		}
		this.selected_actions_view.setCollection(this.selected_collection);
	},


	setClipboardCollection: function (clipboard)
	{
		this.clipboard_collection = clipboard;
		this.clipboard_collection.bind('change', this.render, this);
		this.clipboard_collection.bind('reset', this.render, this);
		this.clipboard_collection.bind('remove', this.render, this);
		this.clipboard_collection.bind('add', this.render, this);

		this.clipboard_view = new ClipboardView();
		this.clipboard_view.setCollection(this.clipboard_collection);
	},

	render: function ()
	{
		if (this.selected_actions_view)
			this.selected_actions_view.render();
		if (this.selected_actions_view && this.selected_collection.length > 0)
		{
			this.clipboard_view.hide();
		} else
		{
			this.clipboard_view.render();
		}
	}
});