/**
 * Single bookmark loaded from server.
 * Essential properties are only obj_id and obj_type, but also
 * may contain a document/folder object (instance of DocElementModel)
 */
var BookmarkModel = Backbone.Model.extend({
	urlRoot: '/intranet/rest/documents/bookmark/',

	loadFull: function ()
	{
		this.url = this.urlRoot + this.id + '?full=1';
		this.fetch();//{success: function () {console.log("loaded")}, failure: function () {console.log("load fail")}}); //{success: function (model) { console.log(model); model.initialize(); console.log(model); model.change(); } });
	},

	initialize: function ()
	{
		if (this.has('object'))
		{
			this.get('object').is_bookmarked = true;
		}
	},

	getDocument: function ()
	{
		if (this.has('object'))
		{
			var obj = this.get('object');
			if (typeof(obj.attributes) == 'undefined')
			{
				obj = new DocElementModel(obj);
				this.set({'object': obj}, {silent: true});
			}
			return this.get('object');
		}
		return null;
	},

	parse: function (response)
	{
		if (response['object'])
		{
			response['object']['is_bookmarked'] = true;
		}
		return response;
	},

	validate: function ()
	{
		if (!this.get('obj_type') || !this.get('obj_id'))
			return "wrong data in bookmark";
	},

	isBookmarked: function (obj_type, obj_id)
	{
		//if (this.get('bookmark'))
		return this.get('obj_type') == obj_type && this.get('obj_id') == obj_id;
	},

	matchKeywords: function (keywords)
	{
		if (!this.has('object'))
			return false;
		var doc = this.get('object');
		return doc.matchKeywords(keywords);
	}
});

