var ClipboardActionsView = DashboardActionsView.extend({
	el: $('.js-clipboard-actions'),

	initialize: function ()
	{
		this.all_actions = [];

		this.all_actions.push(new ClipboardActionCopy());
		this.all_actions.push(new ClipboardActionMove());
		this.all_actions.push(new ClipboardActionLink());

		this.all_actions.push(new DashboardActionDownloadZip());
		this.all_actions.push(new DashboardActionRenew());

		this.all_actions.push(new ClipboardActionSelectAll());
		this.all_actions.push(new ClipboardActionRemove());
	},

	setCollection: function (collection)
	{
		DashboardActionsView.prototype.setCollection.call(this, collection);

		this.collection.bind('change', this.render, this);
		this.collection.bind('reset', this.render, this);
		this.collection.bind('remove', this.render, this);
		this.collection.bind('add', this.render, this);
	},

	render: function ()
	{
		var title;
		if (!this.collection)
		{
			this.$el.hide();
			return;
		}

		title = lmsg('documents.clipboard_actions');
		this.$('.aside_dashboard_header').text(title);

		this.renderActions();
		this.$el.show();
	}

});