var UISettingsModel = Backbone.Model.extend({
    initialize : function() {
        this.breadcrumb = new BreadcrumbView();
        this.permission = new PermissionModel();
    },
    
    setDocsListStateModel : function(docs_list_state) {
        this.docs_list_state = docs_list_state;
        docs_list_state.bind('change', this.load, this);
    },

    parse : function(response) {
        this.breadcrumb.breadcrumb.set(response.path);
        this.permission.set(response.permission);
        this.breadcrumb.render();
    },

    load : function() {
        this.url = '/intranet/rest/documents/folder/' + this.docs_list_state.get('folder_id') + '/ui';
        this.fetch();
    }
});
