var importer;

$(document).ready(function() {
	if (import_key > 0)
	{
		importer = new ImportLog(project_id, import_key);
		importer.Run()
	}
});

ImportLog = function(id, key, target)
{
	ImportLog.prototype.project_id = id;
	ImportLog.prototype.import_key = key;
	ImportLog.prototype.log_target = target;
	ImportLog.prototype.last_sequence = 0;
	ImportLog.prototype.import_success = 0;
	ImportLog.prototype.import_failure = 0;
	ImportLog.prototype.log_target = '';
}

ImportLog.prototype.Run = function()
{
	$.ajax(
	{
	  url: "helpdesk_csv_issues.php",
	  data: {
		  		id: this.project_id,
		  		import_key: this.import_key,
		  		last_sequence: this.last_sequence,
		  		action: 'get_update'
	  		},
	  context: document.body
	}).done(function(data, textStatus){importer.FillLog(data, textStatus);});
}

ImportLog.prototype.FillLog = function(data, textStatus)
{
	if (data !== null)
	{
		if (typeof(data.log_target) == 'string')
			this.log_target = data.log_target;
	}

	var log = $('#' + this.log_target + '_log'),
		logRow = $('#' + this.log_target + '_logRow'),
		logRowContainer = $('#' + this.log_target + '_row_container'),
		logSummary = $('#ic_' + this.log_target + '_summary'),
		finished = false;

	if (data !== null)
	{
		var records = data.records;
		if (typeof(records) == 'undefined')
			records = Array();

		if ((typeof records == 'object') &&
			(records.sequence == 0))
		{
			$('#' + this.log_target + '_block').removeClass('d-none');
			log.prepend('<h6 class="text-success">' + records.content.message + '</h6>');
		}

		for (var i = 0; i < records.length; i++)
		{
			var sequence = parseInt(records[i].sequence);
			var content = $.parseJSON(records[i].content);

			if (sequence > -1)
			{
				class_type = content.success == 1 ? 'success' : 'important';
				logRow.append('<tr><td>' + content.id + '</td><td>' + content.full_id + '</td><td class="text-center">' + '<span class="badge xic-import-log- badge-' + class_type + '">' + content.message + '</span></td></tr>');
			}

			if (sequence > this.last_sequence)
				this.last_sequence = sequence;

			if (sequence == -1)
			{
				log.append('<h6 class="text-success">' + content.message + '</h6>');
				finished = true;
			}

			if ((content !== null) &&
				(content.success != undefined))
			{
				if (content.success == 1)
				{
					this.import_success++;
				} else
				{
					this.import_failure++;

					// Change the summary to better indicate that something didn't work properly
					logSummary.removeClass('alert-success');
					logSummary.addClass('alert-danger');
				}
			}
		}

		$('#ic_' + this.log_target + '_summary').html(lmsg('helpdesk.issue.import.summary', (this.import_success + this.import_failure), this.import_success, this.import_failure));
	}

	if (!finished)
	{
		// Wait half a second for more results to build up before querying for updates
		setTimeout("importer.Run()", 500);
	}

	// Scroll to the bottom of the log window
	if (this.log_target != '')
		logRowContainer.scrollTop(logRow[0].scrollHeight);
}
