define(['mootools'], function () {

var ClnAttendees = new Class({
    initialize: function (context) {
        this.context = context;
        this.list = [];
        this.tbody = $(this.context + '_tbody');
    },
    addUser: function (u) {
        if ($defined(this.list[u.id]))
            if (!this.list[u.id].delete_flag) {
                if (!this.list[u.id].complete_deleted) return;
            } else {
                return this.list[u.id].unmarkAsDelete();
            }
        user = new ClnUser(this.context);
        this.list[u.id] = user;
        user.init(u, $(this.context + '_template_row').clone(true));
        var row = user.getRow();
        row.inject(this.tbody);
    },
    getIdsList: function () {
        var list = [];
        this.list.each(function (user) {
            if ($defined(user) && !user.delete_flag && !user.complete_deleted) list.push(user.id);
        });
        return list;
    }
});

var ClnUser = new Class({
    initialize: function (type) {
        this.type = type;
        this.delete_flag = false;
        this.complete_deleted = false;
    },
    init: function (user, row) {
        this.id = user.id;
        this.name = user.name;
        this.stat = user.stat;
        this.notify = user.notify;
        this.row = row;
        this.deleted = user.deleted;
        var tds = this.row.getChildren();
        tds[0].getElement('a').setProperty('href', user.profile).setHTML(user.name);
        tds[1].setHTML(this.getStatAsText(this.stat));
        if ($defined(tds[2])) tds[2].setHTML((this.notify) ? document.lc['calendar.sent'] : document.lc['calendar.not_sent']);
        if ($defined(tds[3])) {
            tds[3].getElement('span').linked_user = this;
            if (this.deleted == 1)
                this.markAsDelete();
            else
                this.unmarkAsDelete();
        }
        this.row.removeClass('d-none');
    },
    getStatAsText: function (stat) {
        if (this.stat == 1) return document.lc['calendar.come'];
        if (this.stat == 2) return document.lc['calendar.not_come'];
        if (this.stat == 0) return document.lc['calendar.unknown'];
    },
    getRow: function () {
        return this.row;
    },
    toggleDeleteMark: function () {
        if (!$defined(this.deleted)) return this.completeDelete();
        if (this.delete_flag == true) return this.unmarkAsDelete();
        this.markAsDelete();
    },
    completeDelete: function () {
        this.row.remove();
        this.complete_deleted = true;
    },
    markAsDelete: function () {
        this.row.addClass('cln_deleted_user');
        this.row.getChildren()[3].childNodes[1].childNodes[1].setProperty('name', 'reload-outline');
        this.delete_flag = true;
    },
    unmarkAsDelete: function () {
        this.row.removeClass('cln_deleted_user');
        this.row.getChildren()[3].childNodes[1].childNodes[1].setProperty('name', 'trash-outline');
        this.delete_flag = false;
    }
});

ClnAttendees.implement(new Events);

return ClnAttendees;
});
