define(['mootools', '/intranet/js/calendar/cln_attendees.js', '/intranet/js/strings.js'], function (mootools, ClnAttendees) {

var ClnEditor = new Class({
	initialize: function(){
		document.cln_editor = this;
		this.init();
		this.users = new ClnAttendees("user");
		this.contacts = new ClnAttendees("contact");
		this.addUsers(cln_attended_users);
		this.addContacts(cln_attended_contacts);
	},
	init: function(){

	},
	addUsers: function(users){
		users.each(function(user){
			this.users.addUser(user);
		}, this);
	},
	addContacts: function(contacts){
		contacts.each(function(contact){
			this.contacts.addUser(contact);
		}, this);
	},
	fillFormForSend: function(){
		$('cln_att_users').setProperty('value', implode(',', this.users.getIdsList() ) );
		$('cln_att_contacts').setProperty('value', implode(',', this.contacts.getIdsList() ) );
	},
	linkWithRoom: function(options){
		this.room_options = options;
		$('cln_rb_link').removeClass('d-none');
		$('cln_location').addClass('d-none');

		// Set rb options
		$('rb_booking').setHTML(strEscapeHTML(options.name) );
		$('rb_location').setHTML(strEscapeHTML(options.location === null? '--' : options.location + ' (' + options.room_name + ')') );
		$('event_location').value = options.location + ' (' + options.room_name + ')';
		$('rb_fac').setHTML(options.facs);
		$('rb_stat').setHTML(options.stat);

		// Rewrite date dialog
		$('rb_date_body').removeClass('d-none');
		$('cln_date_body').addClass('d-none');
		$('rb_when').setHTML(strEscapeHTML(options.range) );
		if (!options.human_string) {
			$$('rb_repetition_row').addClass('d-none');
		}else{
			$('rb_repetition').setHTML(strEscapeHTML(options.human_string) );
		}

		// FILL FORM DATA
		$('rb_id').value = options.id;
		$('rb_start').value = options.start;
		$('rb_end').value = options.end;
		$('rb_full_day').value = options.end ? 1 : 0;
		$('rb_string').value = options.save_string;
	},
	unlinkWithRoom: function(del_flag){
		xajax_unlink_room($('rb_id').value, del_flag);
		$('rb_id').value = 0;
		$('rb_start').value = 0;
		$('rb_end').value = 0;
		$('rb_full_day').value = 0;
		$('rb_string').value = 0;
		$('event_location').value = '';
		this.room_options = {};
		$('cln_rb_link').addClass('d-none');
		$('cln_location').removeClass('d-none');

		$('rb_date_body').addClass('d-none');
		$('cln_date_body').removeClass('d-none');
	},
	openRoomPopup : function(){
		query = new Array();
		this.pushToQuery($('extended_edit').getElements("input[name^=calendar_date]"));
		this.pushToQuery($('extended_edit').getElements("select[name^=calendar_date]"));
		window.open('../rooms/rb_start_book.php?'+implode('&', query), 'new', 'width=800,height=580,top=100,left=200,scrollbars=yes');
	},

	pushToQuery: function(elements) {
		elements.each(function(el){
			if (el.getProperty('type') == 'checkbox'){
				if(el.checked) query.push(el.getProperty('name')+'=on');
			}else{
				query.push(el.getProperty('name')+'='+el.getProperty('value'));
			}
		});
	}
});


window.ClnEvent = new Class({
	initialize: function(){
	}
});

return ClnEditor;
});
